/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.el.contexts;

import com.intellij.micronaut.el.contexts.MnElContextsExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

final class MnCustomContextExtension
extends MnElContextsExtension {
    private static final String MN_CUSTOM_REGISTRAR = "io.micronaut.expressions.context.ExpressionEvaluationContextRegistrar";
    private static final String CONTEXT_CLASS_METHOD = "getContextClassName";

    MnCustomContextExtension() {
    }

    @Override
    @NotNull
    public Collection<PsiMethod> getRootMethods(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            MnCustomContextExtension.$$$reportNull$$$0(0);
        }
        HashSet<PsiMethod> psiVariables = new HashSet<PsiMethod>();
        for (PsiClass evaluationContextClass : MnCustomContextExtension.geCustomEvaluationContextClasses(contextElement)) {
            psiVariables.addAll(Arrays.stream(evaluationContextClass.getAllMethods()).toList());
        }
        HashSet<PsiMethod> hashSet = psiVariables;
        if (hashSet == null) {
            MnCustomContextExtension.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            MnCustomContextExtension.$$$reportNull$$$0(2);
        }
        HashSet<PsiField> psiVariables = new HashSet<PsiField>();
        for (PsiClass evaluationContextClass : MnCustomContextExtension.geCustomEvaluationContextClasses(contextElement)) {
            psiVariables.addAll(Arrays.stream(evaluationContextClass.getAllFields()).toList());
        }
        HashSet<PsiField> hashSet = psiVariables;
        if (hashSet == null) {
            MnCustomContextExtension.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    private static Set<PsiClass> geCustomEvaluationContextClasses(@NotNull PsiElement contextElement) {
        PsiClass registrar;
        if (contextElement == null) {
            MnCustomContextExtension.$$$reportNull$$$0(4);
        }
        if ((registrar = JavaPsiFacade.getInstance((Project)contextElement.getProject()).findClass(MN_CUSTOM_REGISTRAR, contextElement.getResolveScope())) == null) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                MnCustomContextExtension.$$$reportNull$$$0(5);
            }
            return set;
        }
        PsiMethod[] methods = registrar.findMethodsByName(CONTEXT_CLASS_METHOD, false);
        if (methods.length == 1) {
            return MnCustomContextExtension.getCachedEvaluationContextClasses(methods[0]);
        }
        Set<PsiClass> set = Collections.emptySet();
        if (set == null) {
            MnCustomContextExtension.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    private static Set<PsiClass> getCachedEvaluationContextClasses(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            MnCustomContextExtension.$$$reportNull$$$0(7);
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)psiMethod, () -> new CachedValueProvider.Result(MnCustomContextExtension.getEvaluationContextClasses(psiMethod), new Object[]{UastModificationTracker.getInstance((Project)psiMethod.getProject())}));
        if (set == null) {
            MnCustomContextExtension.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private static Set<PsiClass> getEvaluationContextClasses(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            MnCustomContextExtension.$$$reportNull$$$0(9);
        }
        HashSet<PsiClass> evaluationContexts = new HashSet<PsiClass>();
        for (PsiMethod customRegistryMethod : OverridingMethodsSearch.search((PsiMethod)psiMethod).findAll()) {
            PsiCodeBlock body = customRegistryMethod.getBody();
            if (body == null) continue;
            for (PsiStatement psiStatement : body.getStatements()) {
                String evaluatedString;
                UExpression returnExpression;
                UReturnExpression uElement;
                if (!(psiStatement instanceof PsiReturnStatement) || (uElement = (UReturnExpression)UastContextKt.toUElement((PsiElement)psiStatement, UReturnExpression.class)) == null || (returnExpression = uElement.getReturnExpression()) == null || !StringUtil.isNotEmpty((String)(evaluatedString = UastUtils.evaluateString((UExpression)returnExpression)))) continue;
                ContainerUtil.addIfNotNull(evaluationContexts, (Object)JavaPsiFacade.getInstance((Project)psiMethod.getProject()).findClass(evaluatedString, GlobalSearchScope.allScope((Project)psiMethod.getProject())));
            }
        }
        HashSet<PsiClass> hashSet = evaluationContexts;
        if (hashSet == null) {
            MnCustomContextExtension.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/el/contexts/MnCustomContextExtension";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/el/contexts/MnCustomContextExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "geCustomEvaluationContextClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedEvaluationContextClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationContextClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootMethods";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "geCustomEvaluationContextClasses";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCachedEvaluationContextClasses";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluationContextClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

