/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.jam.beans;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.jam.beans.JamPsiMemberMicronautBean;
import com.intellij.micronaut.jam.beans.JamPsiMethodMicronautBean;
import com.intellij.micronaut.jam.beans.MnBean;
import com.intellij.micronaut.jam.beans.MnBeanDefinition;
import com.intellij.micronaut.jam.beans.MnEachBean;
import com.intellij.micronaut.jam.beans.MnFactory;
import com.intellij.micronaut.jam.beans.MnFactoryMethodBean;
import com.intellij.micronaut.jam.beans.MnFieldBean;
import com.intellij.micronaut.jam.beans.MnInject;
import com.intellij.micronaut.jam.beans.MnInjectionPoint;
import com.intellij.micronaut.jam.beans.MnNamedBean;
import com.intellij.micronaut.jam.beans.MnPsiClassBeanDefinition;
import com.intellij.micronaut.jam.beans.MnRepository;
import com.intellij.micronaut.jam.beans.MnSingleton;
import com.intellij.microservices.jvm.cache.ScopedCacheValueHolder;
import com.intellij.microservices.jvm.cache.ScopedCacheValueHolders;
import com.intellij.microservices.jvm.cache.SourceLibSearchProvider;
import com.intellij.microservices.jvm.cache.UastCachedSearchUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class MnBeansModel {
    public static final Map<String, String> KNOWN_INJECTION_CANDIDATES = Map.of("io.micronaut.context.ApplicationContext", "io.micronaut.context.DefaultApplicationContext");
    private static final String[] INJECTION_CONTAINER_CLASSES = new String[]{"java.util.Optional", "java.lang.Iterable", "java.util.stream.Stream", "javax.inject.Provider"};
    private static final SourceLibSearchProvider<List<MnInjectionPoint>, Module> INJECTION_CACHE_KEY = new SourceLibSearchProvider("MN_INJECTION", (project, module, scope) -> MnBeansModel.findInjectionPoints(module, scope));
    private static final SourceLibSearchProvider<List<MnBeanDefinition>, Module> BEANS_CACHE_KEY = new SourceLibSearchProvider("MN_BEANS", (project, module, scope) -> MnBeansModel.findBeans(module, scope));

    @NotNull
    public static Collection<MnBeanDefinition> findAutowiredDependencies(MnInjectionPoint injectionPoint) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)injectionPoint.getOwner());
        if (module == null) {
            List<MnBeanDefinition> list = Collections.emptyList();
            if (list == null) {
                MnBeansModel.$$$reportNull$$$0(0);
            }
            return list;
        }
        Collection<MnBeanDefinition> knownCandidates = MnBeansModel.getKnownInjectionCandidates(injectionPoint, module);
        if (!knownCandidates.isEmpty()) {
            Collection<MnBeanDefinition> collection = knownCandidates;
            if (collection == null) {
                MnBeansModel.$$$reportNull$$$0(1);
            }
            return collection;
        }
        List<MnBeanDefinition> beanDefinitions = MnBeansModel.getAllBeans(module).filter(beanDefinition -> MnBeansModel.isAppropriateCandidate(injectionPoint, beanDefinition, module)).toList();
        return MnBeansModel.filterBeansByPriority(beanDefinitions);
    }

    @NotNull
    public static Collection<MnInjectionPoint> findAutowiredCandidates(MnBeanDefinition beanDefinition) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)beanDefinition.getDefiningPsiElement());
        if (module == null) {
            List<MnInjectionPoint> list = Collections.emptyList();
            if (list == null) {
                MnBeansModel.$$$reportNull$$$0(2);
            }
            return list;
        }
        Collection collection = MnBeansModel.getAllInjectionPoints(module).filter(injectionPoint -> MnBeansModel.isAppropriateCandidate(injectionPoint, beanDefinition, module)).collect(Collectors.toList());
        if (collection == null) {
            MnBeansModel.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private static boolean isAppropriateCandidate(MnInjectionPoint injectionPoint, MnBeanDefinition beanDefinition, Module module) {
        PsiType injectedInstanceType = MnBeansModel.getInjectedInstanceType(injectionPoint.getType(), module);
        return MnBeansModel.hasMatchingType(injectionPoint, injectedInstanceType, beanDefinition, module) && MnBeansModel.hasMatchingQualifiers(beanDefinition, injectionPoint, injectedInstanceType);
    }

    private static boolean hasMatchingType(MnInjectionPoint injectionPoint, PsiType injectedInstanceType, MnBeanDefinition beanDefinition, Module module) {
        PsiModifierListOwner beanDefiningPsiElement;
        PsiAnnotation beanAnnotation;
        PsiElement jamService;
        MnBeanDefinition mnBeanDefinition;
        PsiClass ipPsiClass;
        PsiType beanType = beanDefinition.getBeanType();
        if (beanType == null || injectedInstanceType == null || !injectedInstanceType.isAssignableFrom(beanType)) {
            return false;
        }
        if (!MnBeansModel.ipHasQualifiers(injectionPoint) && injectedInstanceType instanceof PsiClassType && (ipPsiClass = ((PsiClassType)injectedInstanceType).resolve()) != null && MnBeansModel.isConcreteClass(ipPsiClass) && (mnBeanDefinition = (MnBeanDefinition)(jamService = JamService.getJamService((Project)module.getProject())).getJamElement(JamPsiMemberMicronautBean.PSI_MEMBER_BEAN_JAM_KEY, (PsiElement)ipPsiClass)) != null && !injectedInstanceType.equals(beanType)) {
            return false;
        }
        jamService = beanDefinition.getDefiningPsiElement();
        if (jamService instanceof PsiModifierListOwner && (beanAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)(beanDefiningPsiElement = (PsiModifierListOwner)jamService), (String[])new String[]{"io.micronaut.context.annotation.Bean"})) != null) {
            PsiAnnotationMemberValue value = beanAnnotation.findDeclaredAttributeValue("typed");
            if (value instanceof PsiClassObjectAccessExpression) {
                PsiClassObjectAccessExpression classAccessExpression = (PsiClassObjectAccessExpression)value;
                return injectedInstanceType.equals(classAccessExpression.getOperand().getType());
            }
            if (value instanceof PsiArrayInitializerMemberValue) {
                PsiArrayInitializerMemberValue classArray = (PsiArrayInitializerMemberValue)value;
                return ContainerUtil.exists((Object[])classArray.getInitializers(), item -> {
                    PsiClassObjectAccessExpression classAccessExpression;
                    return item instanceof PsiClassObjectAccessExpression && injectedInstanceType.equals((classAccessExpression = (PsiClassObjectAccessExpression)item).getOperand().getType());
                });
            }
        }
        return true;
    }

    private static boolean isConcreteClass(PsiClass psiClass) {
        return !psiClass.isInterface() && !psiClass.isEnum() && !psiClass.isAnnotationType() && !(psiClass instanceof PsiAnonymousClass) && !psiClass.hasModifierProperty("abstract");
    }

    private static boolean hasMatchingQualifiers(MnBeanDefinition beanDefinition, MnInjectionPoint injectionPoint, PsiType injectedInstanceType) {
        if (MnBeansModel.ignoreQualifiers(beanDefinition)) {
            return true;
        }
        List<UAnnotation> qualifiers = MnBeansModel.getInjectionPointQualifiers(injectionPoint);
        if (qualifiers.isEmpty()) {
            return true;
        }
        for (UAnnotation qualifier : qualifiers) {
            if (!(MnBeansModel.isNamedQualifier(qualifier) ? !MnBeansModel.isMatchingNamedBean(injectionPoint, qualifier, injectedInstanceType, beanDefinition) : !MnBeansModel.hasMatchingQualifier(qualifier, beanDefinition))) continue;
            return false;
        }
        return true;
    }

    private static boolean ignoreQualifiers(MnBeanDefinition beanDefinition) {
        PsiElement psiElement = beanDefinition.getDefiningPsiElement();
        if (!(psiElement instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)psiElement;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiModifierListOwner, (String)"io.micronaut.context.annotation.EachProperty", (int)0) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiModifierListOwner, (String)"io.micronaut.context.annotation.EachBean", (int)0);
    }

    @NotNull
    private static List<UAnnotation> getInjectionPointQualifiers(MnInjectionPoint injectionPoint) {
        UAnnotated uAnnotated = (UAnnotated)UastContextKt.toUElement((PsiElement)injectionPoint.getOwner(), UAnnotated.class);
        if (uAnnotated == null) {
            List<UAnnotation> list = Collections.emptyList();
            if (list == null) {
                MnBeansModel.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull((Collection)uAnnotated.getUAnnotations(), uAnnotation -> {
            PsiClass annotationClass = uAnnotation.resolve();
            if (annotationClass == null) {
                return null;
            }
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)annotationClass, (String)"javax.inject.Qualifier", (int)0) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)annotationClass, (String)"jakarta.inject.Qualifier", (int)0)) {
                return null;
            }
            return uAnnotation;
        });
        if (list == null) {
            MnBeansModel.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static boolean ipHasQualifiers(MnInjectionPoint injectionPoint) {
        return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)injectionPoint.getOwner(), List.of("jakarta.inject.Qualifier", "javax.inject.Qualifier"));
    }

    private static boolean isNamedQualifier(UAnnotation qualifier) {
        return "javax.inject.Named".equals(qualifier.getQualifiedName()) || "jakarta.inject.Named".equals(qualifier.getQualifiedName());
    }

    private static boolean isMatchingNamedBean(MnInjectionPoint injectionPoint, UAnnotation qualifier, PsiType injectedInstanceType, MnBeanDefinition beanDefinition) {
        PsiType candidatePsiType = beanDefinition.getBeanType();
        if (candidatePsiType == null) {
            return false;
        }
        String candidateTypeName = candidatePsiType.getPresentableText().toLowerCase(Locale.ENGLISH);
        UDeclaration candidateUDeclaration = (UDeclaration)UastContextKt.toUElement((PsiElement)beanDefinition.getDefiningPsiElement(), UDeclaration.class);
        if (candidateUDeclaration == null) {
            return false;
        }
        UAnnotation candidateNamedAnno = (UAnnotation)ContainerUtil.find((Iterable)candidateUDeclaration.getUAnnotations(), MnBeansModel::isNamedQualifier);
        UExpression ipNamedValueExpression = qualifier.findDeclaredAttributeValue("value");
        if (ipNamedValueExpression == null) {
            String ipDeclarationName;
            if (candidateNamedAnno != null && candidateNamedAnno.findDeclaredAttributeValue("value") != null) {
                return false;
            }
            String string = ipDeclarationName = injectionPoint.getOwner() instanceof PsiNamedElement ? ((PsiNamedElement)injectionPoint.getOwner()).getName() : null;
            if (candidateUDeclaration instanceof UClass) {
                return StringUtil.equalsIgnoreCase((CharSequence)candidateTypeName, (CharSequence)ipDeclarationName);
            }
            if (candidateUDeclaration instanceof UMethod) {
                String methodName = ((UMethod)candidateUDeclaration).getName();
                return StringUtil.equalsIgnoreCase((CharSequence)methodName, (CharSequence)ipDeclarationName) || StringUtil.equalsIgnoreCase((CharSequence)methodName, (CharSequence)("get" + ipDeclarationName));
            }
            if (candidateUDeclaration instanceof UField) {
                return StringUtil.equalsIgnoreCase((CharSequence)((UField)candidateUDeclaration).getName(), (CharSequence)ipDeclarationName);
            }
            return false;
        }
        String qualifierNamedValue = UastUtils.evaluateString((UExpression)ipNamedValueExpression);
        if (qualifierNamedValue == null) {
            return false;
        }
        if (candidateNamedAnno == null || candidateNamedAnno.findDeclaredAttributeValue("value") == null) {
            String combinedNamedQualifier = qualifierNamedValue + injectedInstanceType.getPresentableText();
            return StringUtil.equalsIgnoreCase((CharSequence)combinedNamedQualifier, (CharSequence)candidateTypeName) || StringUtil.equalsIgnoreCase((CharSequence)qualifierNamedValue, (CharSequence)candidateTypeName);
        }
        PsiAnnotation psiAnnotation = candidateNamedAnno.getJavaPsi();
        if (psiAnnotation == null) {
            return false;
        }
        PsiAnnotationMemberValue candidateAttributeValue = psiAnnotation.findDeclaredAttributeValue("value");
        if (candidateAttributeValue == null) {
            return false;
        }
        String candidateNamedValue = AnnotationUtil.getStringAttributeValue((PsiAnnotationMemberValue)candidateAttributeValue);
        return StringUtil.equalsIgnoreCase((CharSequence)qualifierNamedValue, (CharSequence)candidateNamedValue);
    }

    private static boolean hasMatchingQualifier(UAnnotation qualifier, MnBeanDefinition beanType) {
        PsiElement psiElement = beanType.getDefiningPsiElement();
        if (!(psiElement instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner definingElement = (PsiModifierListOwner)psiElement;
        UDeclaration uBeanDeclaration = (UDeclaration)UastContextKt.toUElement((PsiElement)definingElement, UDeclaration.class);
        if (uBeanDeclaration == null) {
            return false;
        }
        String qualifierFqn = qualifier.getQualifiedName();
        if (qualifierFqn == null) {
            return false;
        }
        UAnnotation candidateQualifier = uBeanDeclaration.findAnnotation(qualifierFqn);
        if (candidateQualifier == null) {
            return false;
        }
        return ContainerUtil.all(MnBeansModel.getDeclaredQualifierAttributes(qualifier), qualifierAttribute -> MnBeansModel.hasAttributeValue(candidateQualifier, (String)qualifierAttribute.first, (UExpression)qualifierAttribute.second));
    }

    @NotNull
    private static Collection<Pair<String, UExpression>> getDeclaredQualifierAttributes(@NotNull UAnnotation qualifier) {
        PsiClass psiClass;
        if (qualifier == null) {
            MnBeansModel.$$$reportNull$$$0(6);
        }
        if ((psiClass = qualifier.resolve()) == null || !psiClass.isAnnotationType()) {
            Set<Pair<String, UExpression>> set = Collections.emptySet();
            if (set == null) {
                MnBeansModel.$$$reportNull$$$0(7);
            }
            return set;
        }
        SmartList qualifierAttributes = new SmartList();
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            String attributeName;
            UExpression attributeValue;
            if (psiMethod.hasAnnotation("io.micronaut.context.annotation.NonBinding") || (attributeValue = qualifier.findDeclaredAttributeValue(attributeName = psiMethod.getName())) == null) continue;
            qualifierAttributes.add(Pair.create((Object)attributeName, (Object)attributeValue));
        }
        SmartList smartList = qualifierAttributes;
        if (smartList == null) {
            MnBeansModel.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    private static boolean hasAttributeValue(@NotNull UAnnotation candidateAnnotation, @NotNull String attributeName, @NotNull UExpression qualifierAttributeValue) {
        if (candidateAnnotation == null) {
            MnBeansModel.$$$reportNull$$$0(9);
        }
        if (attributeName == null) {
            MnBeansModel.$$$reportNull$$$0(10);
        }
        if (qualifierAttributeValue == null) {
            MnBeansModel.$$$reportNull$$$0(11);
        }
        UExpression candidateValue = candidateAnnotation.findDeclaredAttributeValue(attributeName);
        if (qualifierAttributeValue instanceof UReferenceExpression && candidateValue instanceof UReferenceExpression) {
            PsiElement qualifierResolvedElement = ((UReferenceExpression)qualifierAttributeValue).resolve();
            PsiElement candidateResolvedElement = ((UReferenceExpression)candidateValue).resolve();
            return Objects.equals(qualifierResolvedElement, candidateResolvedElement);
        }
        Object injectionPointQualifierAttributeValue = qualifierAttributeValue.evaluate();
        Object candidateAttributeValue = candidateValue != null ? candidateValue.evaluate() : null;
        return Objects.equals(injectionPointQualifierAttributeValue, candidateAttributeValue);
    }

    @NotNull
    private static Collection<MnBeanDefinition> filterBeansByPriority(@NotNull Collection<MnBeanDefinition> beanDefinitions) {
        Collection<MnBeanDefinition> primaryBeans;
        if (beanDefinitions == null) {
            MnBeansModel.$$$reportNull$$$0(12);
        }
        if (!(primaryBeans = MnBeansModel.filterPrimaryBeans(beanDefinitions)).isEmpty()) {
            Collection<MnBeanDefinition> collection = primaryBeans;
            if (collection == null) {
                MnBeansModel.$$$reportNull$$$0(13);
            }
            return collection;
        }
        Collection<MnBeanDefinition> nonSecondaryBeans = MnBeansModel.filterNonSecondaryBeans(beanDefinitions);
        if (!nonSecondaryBeans.isEmpty()) {
            Collection<MnBeanDefinition> collection = nonSecondaryBeans;
            if (collection == null) {
                MnBeansModel.$$$reportNull$$$0(14);
            }
            return collection;
        }
        Collection<MnBeanDefinition> collection = beanDefinitions;
        if (collection == null) {
            MnBeansModel.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    private static Collection<MnBeanDefinition> filterPrimaryBeans(@NotNull Collection<MnBeanDefinition> beanDefinitions) {
        if (beanDefinitions == null) {
            MnBeansModel.$$$reportNull$$$0(16);
        }
        List list = ContainerUtil.filter(beanDefinitions, beanDefinition -> {
            PsiElement psiElement = beanDefinition.getDefiningPsiElement();
            if (!(psiElement instanceof PsiModifierListOwner)) {
                return false;
            }
            PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)psiElement;
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiModifierListOwner, (String)"io.micronaut.context.annotation.Primary", (int)0);
        });
        if (list == null) {
            MnBeansModel.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private static Collection<MnBeanDefinition> filterNonSecondaryBeans(@NotNull Collection<MnBeanDefinition> beanDefinitions) {
        if (beanDefinitions == null) {
            MnBeansModel.$$$reportNull$$$0(18);
        }
        List list = ContainerUtil.filter(beanDefinitions, beanDefinition -> {
            PsiElement psiElement = beanDefinition.getDefiningPsiElement();
            if (!(psiElement instanceof PsiModifierListOwner)) {
                return false;
            }
            PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)psiElement;
            return !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiModifierListOwner, (String)"io.micronaut.context.annotation.Secondary", (int)0);
        });
        if (list == null) {
            MnBeansModel.$$$reportNull$$$0(19);
        }
        return list;
    }

    public static Stream<MnBeanDefinition> getAllBeans(Module module) {
        return UastCachedSearchUtils.computeWithCache((ScopedCacheValueHolder)ScopedCacheValueHolders.asCacheValueHolder((Module)module), BEANS_CACHE_KEY).stream().filter(MnBeanDefinition::isValid);
    }

    public static List<MnBeanDefinition> findBeans(Module m, GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)m.getProject());
        HashSet<MnBeanDefinition> definitions = new HashSet<MnBeanDefinition>(MnBeansModel.findAnnotatedBeans(m, scope));
        List factories = jamService.getJamClassElements(MnFactory.META, "io.micronaut.context.annotation.Factory", scope);
        for (MnFactory factory2 : factories) {
            definitions.add(factory2);
            for (PsiMethod method : ((PsiClass)factory2.getPsiElement()).getAllMethods()) {
                ContainerUtil.addIfNotNull(definitions, (Object)((MnFactoryMethodBean)jamService.getJamElement(MnFactoryMethodBean.FACTORY_BEAN_JAM_KEY, (PsiElement)method)));
            }
        }
        definitions.addAll(jamService.getJamFieldElements(MnFieldBean.META, "io.micronaut.context.annotation.Bean", scope));
        definitions.addAll(jamService.getJamClassElements(MnNamedBean.JAM_KEY, MnNamedBean.getNamedAnnotation(m), scope));
        definitions.addAll(jamService.getJamClassElements(MnEachBean.JAM_KEY, "io.micronaut.context.annotation.EachBean", scope));
        definitions.addAll(jamService.getJamClassElements(MnEachBean.JAM_KEY, "io.micronaut.context.annotation.EachProperty", scope));
        return MnBeansModel.filterUniqueBeans(definitions);
    }

    @NotNull
    private static List<MnBeanDefinition> filterUniqueBeans(@NotNull Collection<MnBeanDefinition> beanDefinitions) {
        if (beanDefinitions == null) {
            MnBeansModel.$$$reportNull$$$0(20);
        }
        HashSet seen = new HashSet();
        List list = ContainerUtil.filter(beanDefinitions, definition -> seen.add(definition.getDefiningPsiElement()));
        if (list == null) {
            MnBeansModel.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static Collection<MnBeanDefinition> findAnnotatedBeans(Module module, GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)module.getProject());
        Collection<String> singletonAnnotations = MnSingleton.getSingletonAnnotations(module);
        Stream singletons = singletonAnnotations.stream().flatMap(annotation -> jamService.getJamClassElements(MnSingleton.SINGLETON_JAM_KEY, annotation, scope).stream());
        Collection<String> beanAnnotations = MnBean.getBeanAnnotations(module);
        Stream beans = beanAnnotations.stream().flatMap(annotation -> jamService.getJamClassElements(MnBean.BEAN_JAM_KEY, annotation, scope).stream());
        Collection<String> repositoryAnnotations = MnRepository.getRepositoryAnnotations(module);
        Stream repositories = repositoryAnnotations.stream().flatMap(annotation -> jamService.getJamClassElements(MnRepository.JAM_KEY, annotation, scope).stream());
        return Stream.of(singletons, beans, repositories).flatMap(s -> s).collect(Collectors.toList());
    }

    @NotNull
    private static Collection<MnBeanDefinition> getKnownInjectionCandidates(@NotNull MnInjectionPoint injectionPoint, @NotNull Module module) {
        PsiType psiType;
        if (injectionPoint == null) {
            MnBeansModel.$$$reportNull$$$0(22);
        }
        if (module == null) {
            MnBeansModel.$$$reportNull$$$0(23);
        }
        if (!((psiType = injectionPoint.getType()) instanceof PsiClassType)) {
            List<MnBeanDefinition> list = Collections.emptyList();
            if (list == null) {
                MnBeansModel.$$$reportNull$$$0(24);
            }
            return list;
        }
        String typeFqn = psiType.getCanonicalText();
        if (StringUtil.isEmpty((String)typeFqn)) {
            List<MnBeanDefinition> list = Collections.emptyList();
            if (list == null) {
                MnBeansModel.$$$reportNull$$$0(25);
            }
            return list;
        }
        String beanTypeFqn = KNOWN_INJECTION_CANDIDATES.get(typeFqn);
        if (StringUtil.isEmpty((String)beanTypeFqn)) {
            List<MnBeanDefinition> list = Collections.emptyList();
            if (list == null) {
                MnBeansModel.$$$reportNull$$$0(26);
            }
            return list;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(beanTypeFqn, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        Collection<MnBeanDefinition> collection = psiClass != null ? Collections.singleton(new MnPsiClassBeanDefinition(psiClass)) : Collections.emptyList();
        if (collection == null) {
            MnBeansModel.$$$reportNull$$$0(27);
        }
        return collection;
    }

    @NotNull
    private static Stream<MnInjectionPoint> getAllInjectionPoints(Module module) {
        Stream<MnInjectionPoint> stream = UastCachedSearchUtils.computeWithCache((ScopedCacheValueHolder)ScopedCacheValueHolders.asCacheValueHolder((Module)module), INJECTION_CACHE_KEY).stream().filter(MnInjectionPoint::isValid);
        if (stream == null) {
            MnBeansModel.$$$reportNull$$$0(28);
        }
        return stream;
    }

    private static List<MnInjectionPoint> findInjectionPoints(Module module, GlobalSearchScope scope) {
        LinkedHashSet injects = new LinkedHashSet();
        MnBeansModel.findInjects(module, module.getProject(), scope).forEach(inject -> {
            PsiModifierListOwner element = (PsiModifierListOwner)inject.getPsiElement();
            if (element instanceof PsiField) {
                injects.add(new MnInjectionPoint(element));
            } else if (element instanceof PsiMethod) {
                PsiParameter[] parameters;
                PsiMethod psiMethod = (PsiMethod)element;
                for (PsiParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
                    injects.add(new MnInjectionPoint((PsiModifierListOwner)parameter));
                }
            }
        });
        MnBeansModel.findInjectedFactoryMethods(module.getProject(), scope).forEach(factoryMethod -> {
            PsiParameter[] parameters;
            PsiMethod psiMethod = (PsiMethod)factoryMethod.getPsiElement();
            for (PsiParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"io.micronaut.context.annotation.Value", (int)0)) continue;
                injects.add(new MnInjectionPoint((PsiModifierListOwner)parameter));
            }
        });
        MnBeansModel.findInjectedConstructors(module, scope).forEach(constructor -> {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = constructor.getParameterList().getParameters()) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"io.micronaut.context.annotation.Value", (int)0)) continue;
                injects.add(new MnInjectionPoint((PsiModifierListOwner)parameter));
            }
        });
        return new ArrayList<MnInjectionPoint>(injects);
    }

    private static Stream<MnInject> findInjects(Module module, Project project, GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)project);
        Stream<MnInject> javaxInjects = Stream.concat(jamService.getJamFieldElements(MnInject.FIELD_META, "javax.inject.Inject", scope).stream(), jamService.getJamMethodElements(MnInject.METHOD_META, "javax.inject.Inject", scope).stream());
        Stream<MnInject> jakartaInjects = Stream.concat(jamService.getJamFieldElements(MnInject.FIELD_META, "jakarta.inject.Inject", scope).stream(), jamService.getJamMethodElements(MnInject.METHOD_META, "jakarta.inject.Inject", scope).stream());
        if (MicronautUtils.hasJakartaInject(module) && MicronautUtils.hasJavaxInject(module)) {
            return Stream.concat(jakartaInjects, javaxInjects);
        }
        if (MicronautUtils.hasJavaxInject(module)) {
            return javaxInjects;
        }
        return jakartaInjects;
    }

    private static Stream<JamPsiMethodMicronautBean> findInjectedFactoryMethods(Project project, GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)project);
        List factories = jamService.getJamClassElements(MnFactory.META, "io.micronaut.context.annotation.Factory", scope);
        return factories.stream().flatMap(factory2 -> Arrays.stream(((PsiClass)factory2.getPsiElement()).getAllMethods()).map(method -> (MnFactoryMethodBean)jamService.getJamElement(MnFactoryMethodBean.FACTORY_BEAN_JAM_KEY, (PsiElement)method)).filter(Objects::nonNull).filter(m -> ((PsiMethod)m.getPsiElement()).getParameterList().getParametersCount() > 0));
    }

    private static Stream<PsiMethod> findInjectedConstructors(Module module, GlobalSearchScope scope) {
        Collection<MnBeanDefinition> beans = MnBeansModel.findAnnotatedBeans(module, scope);
        return beans.stream().map(b -> b.getBeanType()).filter(t -> t instanceof PsiClassType).map(ct -> ((PsiClassType)ct).resolve()).filter(c -> c != null).distinct().flatMap(b -> {
            PsiMethod[] constructors;
            for (PsiMethod c2 : constructors = b.getConstructors()) {
                if (c2.getParameterList().getParametersCount() <= 0 || !AnnotationUtil.isAnnotated((PsiModifierListOwner)c2, (String)"javax.inject.Inject", (int)0) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)c2, (String)"jakarta.inject.Inject", (int)0)) continue;
                return Stream.of(c2);
            }
            return Arrays.stream(constructors).filter(c -> c.getParameterList().getParametersCount() > 0 && !c.hasModifierProperty("private"));
        });
    }

    @Nullable
    private static PsiType getInjectedInstanceType(@Nullable PsiType injectionPointType, Module module) {
        PsiType[] parameters;
        if (injectionPointType == null) {
            return null;
        }
        if (injectionPointType instanceof PsiArrayType) {
            return ((PsiArrayType)injectionPointType).getComponentType();
        }
        if (injectionPointType instanceof PsiClassType && (parameters = ((PsiClassType)injectionPointType).getParameters()).length == 1) {
            for (PsiType containerType : MnBeansModel.getInjectedContainerClasses(module)) {
                if (!containerType.isValid() || !containerType.isAssignableFrom(injectionPointType)) continue;
                return parameters[0];
            }
        }
        return injectionPointType;
    }

    private static Collection<PsiType> getInjectedContainerClasses(Module module) {
        CachedValuesManager cacheManager = CachedValuesManager.getManager((Project)module.getProject());
        return (Collection)cacheManager.getCachedValue((UserDataHolder)module, () -> {
            ArrayList<PsiClassType> psiClasses = new ArrayList<PsiClassType>(INJECTION_CONTAINER_CLASSES.length);
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
            for (String containerClassName : INJECTION_CONTAINER_CLASSES) {
                PsiClass containerClass = javaPsiFacade.findClass(containerClassName, scope);
                if (containerClass == null) continue;
                psiClasses.add(javaPsiFacade.getElementFactory().createType(containerClass));
            }
            return CachedValueProvider.Result.create(psiClasses, (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 9, 10, 11, 12, 16, 18, 20, 22, 23 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/jam/beans/MnBeansModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateAnnotation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierAttributeValue";
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanDefinitions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPoint";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAutowiredDependencies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findAutowiredCandidates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionPointQualifiers";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/jam/beans/MnBeansModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredQualifierAttributes";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "filterBeansByPriority";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPrimaryBeans";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNonSecondaryBeans";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUniqueBeans";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownInjectionCandidates";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInjectionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredQualifierAttributes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasAttributeValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterBeansByPriority";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterPrimaryBeans";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterNonSecondaryBeans";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "filterUniqueBeans";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getKnownInjectionCandidates";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 9, 10, 11, 12, 16, 18, 20, 22, 23 -> new IllegalArgumentException(string);
        };
    }
}

