/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.el.util.processors;

import com.intellij.javaee.el.ELElementProcessor;
import com.intellij.lang.properties.IProperty;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import org.jetbrains.annotations.Nullable;

public class PsiTypeELElementProcessor
extends ELElementProcessor {
    private final String myText;
    private PsiType myResult;
    private PsiSubstitutor mySubstitutor;

    public PsiTypeELElementProcessor(String text) {
        this.myText = text;
    }

    @Nullable
    public PsiType getResult() {
        return this.myResult;
    }

    @Override
    public boolean processVariable(PsiVariable variable) {
        if (this.myText.equals(variable.getName())) {
            this.myResult = variable.getType();
            return false;
        }
        return true;
    }

    @Override
    public boolean processMethod(PsiMethod method) {
        if (this.myText.equals(PropertyUtilBase.getPropertyName((PsiMethod)method))) {
            PsiType returnType = method.getReturnType();
            this.myResult = this.mySubstitutor != null ? this.mySubstitutor.substitute(returnType) : returnType;
            return false;
        }
        return true;
    }

    @Override
    public boolean processField(PsiField field) {
        if (this.myText.equals(field.getName())) {
            this.myResult = field.getType();
            return false;
        }
        return true;
    }

    @Override
    public boolean processProperty(IProperty property) {
        return !this.myText.equals(property.getName());
    }

    @Override
    public void setSubstitutor(PsiSubstitutor substitutor) {
        this.mySubstitutor = substitutor;
    }

    @Override
    @Nullable
    public String getNameHint() {
        return this.myText;
    }

    @Override
    public boolean processNSPrefix(String prefix) {
        return true;
    }
}

