/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.contexts.model.BeanClassSearchInheritorsCache;
import com.intellij.spring.contexts.model.SpringExecutorsQueryCachingProcessor;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.utils.search.executors.AbstractSpringBeanQueryExecutor;
import com.intellij.spring.model.utils.search.executors.CustomBeanWrappersQueryExecutor;
import com.intellij.spring.model.utils.search.executors.SpringAbstractBeanQueryExecutor;
import com.intellij.spring.model.utils.search.executors.SpringBeanFactoriesQueryExecutor;
import com.intellij.spring.model.utils.search.executors.SpringBeanFactoryClassesQueryExecutor;
import com.intellij.spring.model.utils.search.executors.XmlBeanClassQueryExecutor;
import com.intellij.spring.model.utils.search.executors.XmlBeanNameQueryExecutor;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.QueryExecutor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class LocalXmlModelIndexProcessor {
    private final XmlFile myConfigFile;
    private final Project myProject;
    private final GlobalSearchScope myLocalFileSearchScope;
    private final boolean myIsInTestSource;
    private static final List<QueryExecutor<SpringBeanPointer<?>, SpringBeanSearchParameters.BeanName>> ourByNameExecutors = List.of(XmlBeanNameQueryExecutor.INSTANCE, CustomBeanWrappersQueryExecutor.BeanName.INSTANCE);
    private final SpringExecutorsQueryCachingProcessor<SpringModelSearchParameters.BeanName, SpringBeanSearchParameters.BeanName> myBeanNameProcessor = new SpringExecutorsQueryCachingProcessor<SpringModelSearchParameters.BeanName, SpringBeanSearchParameters.BeanName>(){

        @Override
        protected ExecutorsQuery<SpringBeanPointer<?>, SpringBeanSearchParameters.BeanName> createQuery(SpringModelSearchParameters.BeanName params) {
            return new ExecutorsQuery((Object)LocalXmlModelIndexProcessor.this.getByNameSearchParameters(params), ourByNameExecutors);
        }
    };
    private final ByClassCacheProcessor myBeansProcessor = new ByClassCacheProcessor((QueryExecutor<SpringBeanPointer<?>, SpringBeanSearchParameters.BeanClass>)XmlBeanClassQueryExecutor.INSTANCE);
    private final ByClassCacheProcessor myFactoryBeansProcessor = new ByClassCacheProcessor((QueryExecutor<SpringBeanPointer<?>, SpringBeanSearchParameters.BeanClass>)SpringBeanFactoriesQueryExecutor.INSTANCE);
    private final ByClassCacheProcessor myFactoryBeanClassesProcessor = new ByClassCacheProcessor((QueryExecutor<SpringBeanPointer<?>, SpringBeanSearchParameters.BeanClass>)SpringBeanFactoryClassesQueryExecutor.INSTANCE);
    private final ByClassCacheProcessor myAbstractBeansProcessor = new ByClassCacheProcessor((QueryExecutor<SpringBeanPointer<?>, SpringBeanSearchParameters.BeanClass>)SpringAbstractBeanQueryExecutor.INSTANCE);
    private final ByClassCacheProcessor myCustomBeanWrapperProcessor = new ByClassCacheProcessor((QueryExecutor<SpringBeanPointer<?>, SpringBeanSearchParameters.BeanClass>)CustomBeanWrappersQueryExecutor.BeanClass.INSTANCE);

    LocalXmlModelIndexProcessor(XmlFile file) {
        this.myConfigFile = file;
        this.myProject = file.getProject();
        this.myLocalFileSearchScope = GlobalSearchScope.fileScope((PsiFile)this.myConfigFile);
        this.myIsInTestSource = ProjectRootsUtil.isInTestSource((PsiFile)this.myConfigFile);
    }

    Collection<XmlTag> getCustomBeanCandidates(String key) {
        SpringBeanSearchParameters.BeanName params = this.getByNameSearchParameters(SpringModelSearchParameters.byName((String)key));
        SmartList result2 = new SmartList();
        Processor processor2 = arg_0 -> LocalXmlModelIndexProcessor.lambda$getCustomBeanCandidates$0(key, (List)result2, arg_0);
        CustomBeanWrappersQueryExecutor.AllWrappers.INSTANCE.execute(params, processor2);
        return result2;
    }

    List<SpringBeansPackagesScan> getComponentScans() {
        SmartList scans = new SmartList();
        Processor collectProcessor = arg_0 -> LocalXmlModelIndexProcessor.lambda$getComponentScans$1((List)scans, arg_0);
        SpringXmlBeansIndex.processComponentScans(this.getByNameSearchParameters(SpringModelSearchParameters.byName((String)"")), collectProcessor);
        return scans;
    }

    private SpringBeanSearchParameters.BeanName getByNameSearchParameters(@NotNull SpringModelSearchParameters.BeanName parameters) {
        if (parameters == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(0);
        }
        SpringBeanSearchParameters.BeanName searchParameters = SpringBeanSearchParameters.byName(this.myProject, parameters);
        this.applyLocalSearchScope(searchParameters);
        return searchParameters;
    }

    @NotNull
    private SpringBeanSearchParameters.BeanClass getByClassSearchParameters(@NotNull SpringModelSearchParameters.BeanClass params) {
        if (params == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(1);
        }
        SpringBeanSearchParameters.BeanClass searchParameters = SpringBeanSearchParameters.byClass(this.myProject, params);
        this.applyLocalSearchScope(searchParameters);
        SpringBeanSearchParameters.BeanClass beanClass = searchParameters;
        if (beanClass == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(2);
        }
        return beanClass;
    }

    boolean processByName(SpringModelSearchParameters.BeanName params, Processor<? super SpringBeanPointer<?>> processor2, Set<String> activeProfiles) {
        return this.myBeanNameProcessor.process((SpringModelSearchParameters)params, processor2, activeProfiles);
    }

    boolean processByClass(SpringModelSearchParameters.BeanClass params, Processor<? super SpringBeanPointer<?>> processor2, Set<String> activeProfiles, Module module, boolean onlyPlainBeans) {
        if (!this.myBeansProcessor.process((SpringModelSearchParameters)params, processor2, activeProfiles)) {
            return false;
        }
        if (params.isWithInheritors() && !this.processInheritors(params, processor2, activeProfiles, module)) {
            return false;
        }
        if (onlyPlainBeans) {
            return true;
        }
        if (!this.myFactoryBeansProcessor.process((SpringModelSearchParameters)params, processor2, activeProfiles)) {
            return false;
        }
        if (params.isEffectiveBeanTypes()) {
            if (!this.myFactoryBeanClassesProcessor.process((SpringModelSearchParameters)params, processor2, activeProfiles)) {
                return false;
            }
            if (!this.processNonIndexedFactoryBeans(params, processor2, activeProfiles, module)) {
                return false;
            }
        }
        if (!this.processAbstractBeans(params, processor2, activeProfiles)) {
            return false;
        }
        return this.myCustomBeanWrapperProcessor.process((SpringModelSearchParameters)params, processor2, activeProfiles);
    }

    private void applyLocalSearchScope(SpringBeanSearchParameters parameters) {
        parameters.setSearchScope(this.myLocalFileSearchScope);
        parameters.setVirtualFile(this.myConfigFile.getVirtualFile());
    }

    private boolean processInheritors(SpringModelSearchParameters.BeanClass params, Processor<? super SpringBeanPointer<?>> processor2, Set<String> activeProfiles, Module module) {
        Collection<SpringModelSearchParameters.BeanClass> inheritorSearchParameters = BeanClassSearchInheritorsCache.getInheritorSearchParameters(module, this.myIsInTestSource, params);
        for (SpringModelSearchParameters.BeanClass inheritor : inheritorSearchParameters) {
            if (this.myBeansProcessor.process((SpringModelSearchParameters)inheritor, processor2, activeProfiles)) continue;
            return false;
        }
        return true;
    }

    private boolean processNonIndexedFactoryBeans(SpringModelSearchParameters.BeanClass params, Processor<? super SpringBeanPointer<?>> processor2, Set<String> activeProfiles, Module module) {
        SpringBeanSearchParameters.BeanClass searchParameters = this.getByClassSearchParameters(params);
        Collection<SpringBeanPointer<?>> nonIndexedFactoryBeans = this.getNonIndexedFactoryBeans(this.myProject, activeProfiles, module);
        return AbstractSpringBeanQueryExecutor.processEffectiveBeanTypes(nonIndexedFactoryBeans, searchParameters, processor2);
    }

    private boolean processAbstractBeans(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<? super SpringBeanPointer<?>> processor2, @NotNull Set<String> activeProfiles) {
        Collection<SpringBeanPointer<?>> pointers;
        if (params == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(4);
        }
        if (activeProfiles == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(5);
        }
        if (!(pointers = this.getAbstractBeanPointers(params, activeProfiles)).isEmpty()) {
            HashMap processedBeans = new HashMap();
            SpringBeanSearchParameters.BeanClass searchParameters = this.getByClassSearchParameters(params);
            for (SpringBeanPointer<?> pointer : pointers) {
                if (this.processAbstractBean(pointer, searchParameters, processor2, new HashSet(), processedBeans, activeProfiles)) continue;
                return false;
            }
        }
        return true;
    }

    private Collection<SpringBeanPointer<?>> getNonIndexedFactoryBeans(@NotNull Project project, Set<String> activeProfiles, Module module) {
        if (project == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(6);
        }
        SmartList nonIndexedBeans = new SmartList();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)nonIndexedBeans);
        for (SpringModelSearchParameters.BeanClass factoryBeanClass : LocalXmlModelIndexProcessor.getNonIndexedFactoryBeanClasses(project)) {
            this.processByClass(factoryBeanClass, processor2, activeProfiles, module, true);
        }
        return nonIndexedBeans;
    }

    private static List<SpringModelSearchParameters.BeanClass> getNonIndexedFactoryBeanClasses(@NotNull Project project) {
        if (project == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(7);
        }
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            SmartList nonIndexedSearchParameters = new SmartList();
            for (PsiClass factoryBeanClass : SpringFactoryBeansManager.getInstance().getKnownBeanFactories(project)) {
                SpringModelSearchParameters.BeanClass searchParameters;
                if (!factoryBeanClass.isValid() || factoryBeanClass.isInterface() || factoryBeanClass.hasModifierProperty("abstract") || LocalXmlModelIndexProcessor.isFactoryBeanClassInIndex(factoryBeanClass) || !(searchParameters = SpringModelSearchParameters.byClass((PsiClass)factoryBeanClass)).canSearch()) continue;
                nonIndexedSearchParameters.add(searchParameters);
            }
            return CachedValueProvider.Result.create((Object)nonIndexedSearchParameters, (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)project), PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static boolean isFactoryBeanClassInIndex(PsiClass factoryBeanClass) {
        String qualifiedName = factoryBeanClass.getQualifiedName();
        return qualifiedName == null || StringUtil.endsWith((CharSequence)qualifiedName, (CharSequence)"FactoryBean");
    }

    @NotNull
    private Collection<SpringBeanPointer<?>> getAbstractBeanPointers(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Set<String> activeProfiles) {
        if (params == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(8);
        }
        if (activeProfiles == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(9);
        }
        SmartList abstractBeans = new SmartList();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)abstractBeans);
        this.myAbstractBeansProcessor.process((SpringModelSearchParameters)params, processor2, activeProfiles);
        SmartList smartList = abstractBeans;
        if (smartList == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private boolean processAbstractBean(@NotNull SpringBeanPointer<?> currentParent, @NotNull SpringBeanSearchParameters.BeanClass params, @NotNull Processor<? super SpringBeanPointer<?>> consumer, @NotNull Set<? super String> noSOE, @NotNull Map<SpringBeanPointer<?>, Set<PsiType>> map, @NotNull Set<String> activeProfiles) {
        if (currentParent == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(11);
        }
        if (params == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(12);
        }
        if (consumer == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(13);
        }
        if (noSOE == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(14);
        }
        if (map == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(15);
        }
        if (activeProfiles == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(16);
        }
        for (PsiType type : this.getSimpleBeanTypes(currentParent, noSOE, map, activeProfiles)) {
            PsiClass psiClass;
            if (params.matchesClass(type) && !consumer.process(currentParent)) {
                return false;
            }
            if (!params.isEffectiveBeanTypes() || !(type instanceof PsiClassType) || (psiClass = ((PsiClassType)type).resolve()) == null || !SpringFactoryBeansManager.getInstance().isFactoryBeanClass(psiClass)) continue;
            for (PsiType psiType : SpringFactoryBeansManager.getInstance().getObjectTypes(type, currentParent.getSpringBean())) {
                if (!params.matchesClass(psiType) || consumer.process(currentParent)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Set<PsiType> getSimpleBeanTypes(@NotNull SpringBeanPointer<?> currentParent, @NotNull Set<? super String> noSOE, @NotNull Map<SpringBeanPointer<?>, Set<PsiType>> map, @NotNull Set<String> activeProfiles) {
        Set<PsiType> psiTypes;
        if (currentParent == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(17);
        }
        if (noSOE == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(18);
        }
        if (map == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(19);
        }
        if (activeProfiles == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(20);
        }
        if ((psiTypes = map.get(currentParent)) != null) {
            Set<PsiType> set = psiTypes;
            if (set == null) {
                LocalXmlModelIndexProcessor.$$$reportNull$$$0(21);
            }
            return set;
        }
        HashSet<PsiType> beanTypes = new HashSet<PsiType>();
        CommonSpringBean springBean = currentParent.getSpringBean();
        if (springBean instanceof SpringBean) {
            SpringBean bean = (SpringBean)springBean;
            if (LocalXmlModelIndexProcessor.hasClassAttribute(bean)) {
                beanTypes.addAll(LocalXmlModelIndexProcessor.getSimpleBeanTypes(bean));
            } else {
                String parent;
                GenericAttributeValue parentBean = bean.getParentBean();
                if (DomUtil.hasXml((DomElement)parentBean) && StringUtil.isNotEmpty((String)(parent = parentBean.getRawText())) && !noSOE.contains(parent)) {
                    noSOE.add(parent);
                    for (SpringBeanPointer<?> parentPointer : this.findParentsByName(parent, activeProfiles)) {
                        CommonSpringBean parentPointerSpringBean = parentPointer.getSpringBean();
                        if (!(parentPointerSpringBean instanceof SpringBean)) continue;
                        beanTypes.addAll(this.getSimpleBeanTypes(parentPointer, noSOE, map, activeProfiles));
                    }
                }
            }
        }
        map.put(currentParent, beanTypes);
        HashSet<PsiType> hashSet = beanTypes;
        if (hashSet == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(22);
        }
        return hashSet;
    }

    private Collection<SpringBeanPointer<?>> findParentsByName(@NotNull String parent, @NotNull Set<String> activeProfiles) {
        if (parent == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(23);
        }
        if (activeProfiles == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(24);
        }
        SpringModelSearchParameters.BeanName parentBeanName = SpringModelSearchParameters.byName((String)parent);
        SmartList beans = new SmartList();
        Processor collectBeans = Processors.cancelableCollectProcessor((Collection)beans);
        this.processByName(parentBeanName, collectBeans, activeProfiles);
        return beans;
    }

    @NotNull
    private static Set<PsiType> getSimpleBeanTypes(@NotNull SpringBean bean) {
        PsiClass aClass;
        if (bean == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(25);
        }
        HashSet<PsiType> psiTypes = new HashSet<PsiType>(1);
        if (bean instanceof AbstractDomSpringBean && (aClass = ((AbstractDomSpringBean)bean).getClassAttributeValue()) != null) {
            PsiClassType classType = PsiTypesUtil.getClassType((PsiClass)aClass);
            psiTypes.add((PsiType)classType);
            if (SpringFactoryBeansManager.getInstance().isFactoryBeanClass(aClass)) {
                ContainerUtil.addAll(psiTypes, (Object[])SpringFactoryBeansManager.getInstance().getObjectTypes((PsiType)classType, (CommonSpringBean)bean));
            }
        }
        HashSet<PsiType> hashSet = psiTypes;
        if (hashSet == null) {
            LocalXmlModelIndexProcessor.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    private static boolean hasClassAttribute(SpringBean bean) {
        return DomUtil.hasXml((DomElement)bean.getClazz());
    }

    private static /* synthetic */ boolean lambda$getComponentScans$1(List scans, SpringBeanPointer pointer) {
        CommonSpringBean bean = pointer.getSpringBean();
        if (bean instanceof SpringBeansPackagesScan) {
            scans.add((SpringBeansPackagesScan)bean);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getCustomBeanCandidates$0(String key, List result2, SpringBeanPointer pointer) {
        CommonSpringBean bean = pointer.getSpringBean();
        if (!(bean instanceof CustomBeanWrapper)) {
            return true;
        }
        CustomBeanWrapper wrapper = (CustomBeanWrapper)bean;
        if (!wrapper.isParsed()) {
            XmlTag tag = wrapper.getXmlTag();
            for (XmlAttribute attribute : tag.getAttributes()) {
                if (!key.equals(attribute.getDisplayValue())) continue;
                result2.add(tag);
                return true;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 21, 22, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: 
            case 10: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 9: 
            case 16: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentParent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noSOE";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getByClassSearchParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbstractBeanPointers";
                break;
            }
            case 21: 
            case 22: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleBeanTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getByNameSearchParameters";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getByClassSearchParameters";
                break;
            }
            case 2: 
            case 10: 
            case 21: 
            case 22: 
            case 26: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processAbstractBeans";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNonIndexedFactoryBeans";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNonIndexedFactoryBeanClasses";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAbstractBeanPointers";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processAbstractBean";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleBeanTypes";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findParentsByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10, 21, 22, 26 -> new IllegalStateException(string);
        };
    }

    private final class ByClassCacheProcessor
    extends SpringExecutorsQueryCachingProcessor<SpringModelSearchParameters.BeanClass, SpringBeanSearchParameters.BeanClass> {
        private final List<QueryExecutor<SpringBeanPointer<?>, SpringBeanSearchParameters.BeanClass>> myExecutors;

        private ByClassCacheProcessor(QueryExecutor<SpringBeanPointer<?>, SpringBeanSearchParameters.BeanClass> executor) {
            this.myExecutors = Collections.singletonList(executor);
        }

        @Override
        protected ExecutorsQuery<SpringBeanPointer<?>, SpringBeanSearchParameters.BeanClass> createQuery(SpringModelSearchParameters.BeanClass params) {
            return new ExecutorsQuery((Object)LocalXmlModelIndexProcessor.this.getByClassSearchParameters(params), this.myExecutors);
        }
    }
}

