/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.spring.factories.resolvers.AbstractTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanReferenceFactoryBeanTypeResolver
extends AbstractTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.beans.factory.config.BeanReferenceFactoryBean";
    @NonNls
    private static final String TARGET_NAME_PROPERTY_NAME = "targetBeanName";

    @Override
    @NotNull
    public Set<PsiType> getObjectType(@Nullable CommonSpringBean context) {
        if (context instanceof SpringBean) {
            PsiClassType fromTargetName;
            SpringBean bean = (SpringBean)context;
            String targetBeanName = this.getPropertyValue(context, TARGET_NAME_PROPERTY_NAME);
            if (targetBeanName != null && (fromTargetName = BeanReferenceFactoryBeanTypeResolver.getTypeFromBeanName(bean, targetBeanName)) != null) {
                Set<PsiClassType> set = Collections.singleton(fromTargetName);
                if (set == null) {
                    BeanReferenceFactoryBeanTypeResolver.$$$reportNull$$$0(0);
                }
                return set;
            }
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            BeanReferenceFactoryBeanTypeResolver.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            BeanReferenceFactoryBeanTypeResolver.$$$reportNull$$$0(2);
        }
        return FACTORY_CLASS.equals(factoryClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/BeanReferenceFactoryBeanTypeResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/BeanReferenceFactoryBeanTypeResolver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

