/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFixKt;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public final class ContextJavaBeanUnresolvedMethodsInspection
extends SpringUastInspectionBase {
    public ContextJavaBeanUnresolvedMethodsInspection() {
        super(new Class[]{UClass.class});
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(1);
        }
        if (!SpringCommonUtils.isInSpringEnabledModule((UElement)aClass)) {
            return null;
        }
        PsiElement sourcePsi = aClass.getSourcePsi();
        if (sourcePsi == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        for (UMethod uMethod : aClass.getMethods()) {
            ContextJavaBeanUnresolvedMethodsInspection.checkMethod(uMethod, holder);
        }
        return holder.getResultsArray();
    }

    private static void checkMethod(@NotNull UMethod uMethod, @NotNull ProblemsHolder holder) {
        ContextJavaBean contextJavaBean;
        if (uMethod == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(3);
        }
        if ((contextJavaBean = ContextJavaBeanUnresolvedMethodsInspection.getContextJavaBean(uMethod, holder.getProject())) != null) {
            ContextJavaBeanUnresolvedMethodsInspection.checkContextJavaBean(contextJavaBean, holder);
        }
    }

    private static void checkContextJavaBean(@NotNull ContextJavaBean contextJavaBean, @NotNull ProblemsHolder holder) {
        if (contextJavaBean == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(5);
        }
        ContextJavaBeanUnresolvedMethodsInspection.checkMethodExists(contextJavaBean, holder, (JamStringAttributeElement<PsiMethod>)contextJavaBean.getInitMethodAttributeElement());
        ContextJavaBeanUnresolvedMethodsInspection.checkMethodExists(contextJavaBean, holder, (JamStringAttributeElement<PsiMethod>)contextJavaBean.getDestroyMethodAttributeElement());
    }

    private static void checkMethodExists(ContextJavaBean contextJavaBean, ProblemsHolder holder, JamStringAttributeElement<PsiMethod> methodAttributeElement) {
        if (StringUtil.isNotEmpty((String)methodAttributeElement.getStringValue()) && methodAttributeElement.getValue() == null) {
            PsiAnnotationMemberValue memberValue = methodAttributeElement.getPsiElement();
            PsiAnnotationMemberValue psiElement = memberValue == null ? contextJavaBean.getPsiAnnotation() : memberValue;
            PsiElement sourcePsiElement = UElementKt.getSourcePsiElement((UElement)UastContextKt.toUElement((PsiElement)psiElement));
            holder.registerProblem((PsiElement)(sourcePsiElement != null ? sourcePsiElement : psiElement), SpringBundle.message("ContextJavaBeanUnresolvedMethodsInspection.cannot.resolve.method", new Object[0]), ContextJavaBeanUnresolvedMethodsInspection.makeFixes(contextJavaBean, methodAttributeElement));
        }
    }

    private static LocalQuickFix[] makeFixes(ContextJavaBean contextJavaBean, JamStringAttributeElement<PsiMethod> methodAttributeElement) {
        PsiClass clazz = PsiTypesUtil.getPsiClass((PsiType)contextJavaBean.getBeanType());
        if (clazz == null) {
            return null;
        }
        String methodName = methodAttributeElement.getStringValue();
        if (methodName == null) {
            return null;
        }
        return CreateMethodFixKt.createVoidMethodFixes((PsiClass)clazz, (String)methodName, (JvmModifier)JvmModifier.PRIVATE);
    }

    @Nullable
    private static ContextJavaBean getContextJavaBean(@NotNull UMethod uMethod, @NotNull Project project) {
        if (uMethod == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(7);
        }
        PsiMethod psi = uMethod.getPsi();
        JamPsiMemberSpringBean memberSpringBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)project).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psi);
        return memberSpringBean instanceof ContextJavaBean ? (ContextJavaBean)memberSpringBean : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextJavaBean";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkContextJavaBean";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextJavaBean";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

