/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.providers;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.Direction;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.ModelTraverse;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.tx.AnnotationDriven;
import com.intellij.spring.model.xml.tx.Mode;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"ADVISE_MODE_ASPECTJ", "", "hasAspectJTransactionMode", "", "module", "Lcom/intellij/openapi/module/Module;", "hasAspectJCachingMode", "isAnnotationDrivenAspectJMode", "m", "Lcom/intellij/spring/contexts/model/LocalXmlModel;", "isEnableTransactionalAspectJMode", "springAnnotationConfig", "Lcom/intellij/psi/PsiClass;", "isEnableCachingAspectJMode", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringAspectJModeSeacher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringAspectJModeSeacher.kt\ncom/intellij/spring/model/highlighting/providers/SpringAspectJModeSeacherKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1761#2,3:91\n*S KotlinDebug\n*F\n+ 1 SpringAspectJModeSeacher.kt\ncom/intellij/spring/model/highlighting/providers/SpringAspectJModeSeacherKt\n*L\n77#1:91,3\n*E\n"})
public final class SpringAspectJModeSeacherKt {
    @NotNull
    public static final String ADVISE_MODE_ASPECTJ = "org.springframework.context.annotation.AdviceMode.ASPECTJ";

    public static final boolean hasAspectJTransactionMode(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        Object object = CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> SpringAspectJModeSeacherKt.hasAspectJTransactionMode$lambda$0(module));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    public static final boolean hasAspectJCachingMode(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        Object object = CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> SpringAspectJModeSeacherKt.hasAspectJCachingMode$lambda$0(module));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAnnotationDrivenAspectJMode(LocalXmlModel m) {
        boolean bl;
        DomFileElement domFileElement = m.getRoot();
        if (domFileElement == null) return false;
        Beans beans = (Beans)domFileElement.getRootElement();
        if (beans == null) return false;
        Beans beans2 = beans;
        boolean bl2 = false;
        List list = DomUtil.getChildrenOf((DomElement)((DomElement)beans2), AnnotationDriven.class);
        if (list == null) return false;
        Iterable iterable = list;
        boolean $i$f$any = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return false;
        }
        Iterator iterator = iterable.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            AnnotationDriven it = (AnnotationDriven)element$iv;
            boolean bl3 = false;
            if (it.getMode().getValue() == Mode.ASPECTJ) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final boolean isEnableTransactionalAspectJMode(PsiClass springAnnotationConfig) {
        String string;
        PsiEnumConstant psiEnumConstant;
        PsiModifierList psiModifierList = springAnnotationConfig.getModifierList();
        PsiAnnotationMemberValue psiAnnotationMemberValue = psiModifierList != null && (psiModifierList = psiModifierList.findAnnotation("org.springframework.transaction.annotation.EnableTransactionManagement")) != null ? psiModifierList.findAttributeValue("mode") : null;
        PsiReferenceExpression psiReferenceExpression = psiAnnotationMemberValue instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiAnnotationMemberValue : null;
        PsiElement psiElement = psiReferenceExpression != null ? psiReferenceExpression.resolve() : null;
        PsiEnumConstant psiEnumConstant2 = psiEnumConstant = psiElement instanceof PsiEnumConstant ? (PsiEnumConstant)psiElement : null;
        if (psiEnumConstant != null) {
            PsiEnumConstant it = psiEnumConstant;
            boolean bl = false;
            PsiClass psiClass = it.getContainingClass();
            string = (psiClass != null ? psiClass.getQualifiedName() : null) + "." + it.getName();
        } else {
            string = null;
        }
        return Intrinsics.areEqual(string, (Object)ADVISE_MODE_ASPECTJ);
    }

    private static final boolean isEnableCachingAspectJMode(PsiClass springAnnotationConfig) {
        String string;
        PsiEnumConstant psiEnumConstant;
        PsiModifierList psiModifierList = springAnnotationConfig.getModifierList();
        PsiAnnotationMemberValue psiAnnotationMemberValue = psiModifierList != null && (psiModifierList = psiModifierList.findAnnotation("org.springframework.cache.annotation.EnableCaching")) != null ? psiModifierList.findAttributeValue("mode") : null;
        PsiReferenceExpression psiReferenceExpression = psiAnnotationMemberValue instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiAnnotationMemberValue : null;
        PsiElement psiElement = psiReferenceExpression != null ? psiReferenceExpression.resolve() : null;
        PsiEnumConstant psiEnumConstant2 = psiEnumConstant = psiElement instanceof PsiEnumConstant ? (PsiEnumConstant)psiElement : null;
        if (psiEnumConstant != null) {
            PsiEnumConstant it = psiEnumConstant;
            boolean bl = false;
            PsiClass psiClass = it.getContainingClass();
            string = (psiClass != null ? psiClass.getQualifiedName() : null) + "." + it.getName();
        } else {
            string = null;
        }
        return Intrinsics.areEqual(string, (Object)ADVISE_MODE_ASPECTJ);
    }

    private static final CachedValueProvider.Result hasAspectJTransactionMode$lambda$0(Module $module) {
        SpringModel springModel = SpringManager.getInstance((Project)$module.getProject()).getCombinedModel($module);
        Intrinsics.checkNotNullExpressionValue((Object)springModel, (String)"getCombinedModel(...)");
        SpringModel model = springModel;
        Ref.BooleanRef isAspectJMode = new Ref.BooleanRef();
        ModelTraverse.traverseModel((CommonSpringModel)((CommonSpringModel)model), (boolean)true, arg_0 -> SpringAspectJModeSeacherKt.hasAspectJTransactionMode$lambda$0$0(isAspectJMode, arg_0));
        Object[] objectArray = new Object[]{SpringModificationTrackersManager.getInstance((Project)$module.getProject()).getOuterModelsDependencies(), PsiModificationTracker.getInstance((Project)$module.getProject()).forLanguage((Language)XMLLanguage.INSTANCE)};
        return CachedValueProvider.Result.create((Object)isAspectJMode.element, (Object[])objectArray);
    }

    private static final Direction hasAspectJTransactionMode$lambda$0$0(Ref.BooleanRef $isAspectJMode, CommonSpringModel m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        CommonSpringModel commonSpringModel = m;
        if (commonSpringModel instanceof LocalAnnotationModel) {
            if (((LocalAnnotationModel)m).isDeclaredInLibrary()) {
                return Direction.PROCEED;
            }
            PsiClass psiClass = ((LocalAnnotationModel)m).getConfig();
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"getConfig(...)");
            $isAspectJMode.element = SpringAspectJModeSeacherKt.isEnableTransactionalAspectJMode(psiClass);
            return $isAspectJMode.element ? Direction.STOP : Direction.TRAVERSE;
        }
        if (commonSpringModel instanceof LocalXmlModel) {
            $isAspectJMode.element = SpringAspectJModeSeacherKt.isAnnotationDrivenAspectJMode((LocalXmlModel)m);
            return $isAspectJMode.element ? Direction.STOP : Direction.TRAVERSE;
        }
        return Direction.TRAVERSE;
    }

    private static final CachedValueProvider.Result hasAspectJCachingMode$lambda$0(Module $module) {
        SpringModel springModel = SpringManager.getInstance((Project)$module.getProject()).getCombinedModel($module);
        Intrinsics.checkNotNullExpressionValue((Object)springModel, (String)"getCombinedModel(...)");
        SpringModel model = springModel;
        Ref.BooleanRef isAspectJMode = new Ref.BooleanRef();
        ModelTraverse.traverseModel((CommonSpringModel)((CommonSpringModel)model), (boolean)true, arg_0 -> SpringAspectJModeSeacherKt.hasAspectJCachingMode$lambda$0$0(isAspectJMode, arg_0));
        Object[] objectArray = new Object[]{SpringModificationTrackersManager.getInstance((Project)$module.getProject()).getOuterModelsDependencies(), PsiModificationTracker.getInstance((Project)$module.getProject()).forLanguage((Language)XMLLanguage.INSTANCE)};
        return CachedValueProvider.Result.create((Object)isAspectJMode.element, (Object[])objectArray);
    }

    private static final Direction hasAspectJCachingMode$lambda$0$0(Ref.BooleanRef $isAspectJMode, CommonSpringModel m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        CommonSpringModel commonSpringModel = m;
        if (commonSpringModel instanceof LocalAnnotationModel) {
            if (((LocalAnnotationModel)m).isDeclaredInLibrary()) {
                return Direction.PROCEED;
            }
            PsiClass psiClass = ((LocalAnnotationModel)m).getConfig();
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"getConfig(...)");
            $isAspectJMode.element = SpringAspectJModeSeacherKt.isEnableCachingAspectJMode(psiClass);
            return $isAspectJMode.element ? Direction.STOP : Direction.TRAVERSE;
        }
        if (commonSpringModel instanceof LocalXmlModel) {
            $isAspectJMode.element = SpringAspectJModeSeacherKt.isAnnotationDrivenAspectJMode((LocalXmlModel)m);
            return $isAspectJMode.element ? Direction.STOP : Direction.TRAVERSE;
        }
        return Direction.TRAVERSE;
    }
}

