/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.custom;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.CustomBeanPsiElement;
import com.intellij.spring.model.xml.custom.CustomNamespaceSpringBean;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CustomBeanFakePsiElement
extends RenameableFakePsiElement
implements CustomBeanPsiElement {
    private final CustomNamespaceSpringBean myBean;

    public CustomBeanFakePsiElement(CustomNamespaceSpringBean bean) {
        super((PsiElement)bean.getContainingFile());
        this.myBean = bean;
    }

    public XmlTag getParent() {
        return this.myBean.getXmlTag();
    }

    public String getName() {
        return this.myBean.getBeanName();
    }

    public String getPresentableText() {
        return SpringPresentationProvider.getSpringBeanName((CommonSpringBean)this.myBean);
    }

    public CustomNamespaceSpringBean getBean() {
        return this.myBean;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlTag xmlTag = this.getParent();
        if (xmlTag == null) {
            CustomBeanFakePsiElement.$$$reportNull$$$0(0);
        }
        return xmlTag;
    }

    public String getTypeName() {
        return SpringBundle.message("spring.bean", new Object[0]);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        XmlAttribute idAttribute;
        if (name == null) {
            CustomBeanFakePsiElement.$$$reportNull$$$0(1);
        }
        if ((idAttribute = this.myBean.getIdAttribute()) != null) {
            idAttribute.setValue(name);
        }
        return super.setName(name);
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof CustomBeanFakePsiElement) {
            CustomBeanFakePsiElement element = (CustomBeanFakePsiElement)another;
            return element.getBean().equals((Object)this.getBean());
        }
        return false;
    }

    public Icon getIcon() {
        return SpringApiIcons.SpringBean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/xml/custom/CustomBeanFakePsiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/xml/custom/CustomBeanFakePsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

