/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.navigation;

import com.intellij.jam.JamService;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.index.SpringBeanIndexType;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class GotoSpringBeanProvider
extends GoToSymbolProvider {
    GotoSpringBeanProvider() {
    }

    protected void addNames(@NotNull Module module, Set<String> result2) {
        if (module == null) {
            GotoSpringBeanProvider.$$$reportNull$$$0(0);
        }
        GotoSpringBeanProvider.getStereotypes(module).map(element -> element.getBeanName()).filter(Objects::nonNull).forEach(s -> result2.add((String)s));
        GotoSpringBeanProvider.getFactoryBeans(module).map(bean -> bean.getBeanName()).filter(Objects::nonNull).forEach(s -> result2.add((String)s));
        FileBasedIndex.getInstance().processAllKeys(SpringXmlBeansIndex.NAME, pair -> {
            if (((SpringBeanIndexType)((Object)((Object)pair.first))).equals((Object)SpringBeanIndexType.BEAN_NAME) && StringUtil.isNotEmpty((String)((String)pair.second))) {
                result2.add((String)pair.second);
            }
            return true;
        }, GotoSpringBeanProvider.getSearchScope(module), null);
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result2) {
        if (module == null) {
            GotoSpringBeanProvider.$$$reportNull$$$0(1);
        }
        GotoSpringBeanProvider.getStereotypes(module).filter(element -> name.equals(element.getBeanName())).forEach(s -> result2.add((NavigationItem)new GoToSymbolProvider.BaseNavigationItem((PsiElement)s.getPsiElement(), name, SpringApiIcons.SpringJavaBean)));
        GotoSpringBeanProvider.getFactoryBeans(module).filter(element -> name.equals(element.getBeanName())).forEach(s -> result2.add((NavigationItem)new GoToSymbolProvider.BaseNavigationItem((PsiElement)s.getPsiElement(), name, SpringApiIcons.SpringJavaBean)));
        SpringModelSearchParameters.BeanName searchParameters = SpringModelSearchParameters.byName((String)name);
        for (LocalXmlModel localXmlModel : SpringAutoConfiguredModels.getLocalXmlModelCandidates(module, GotoSpringBeanProvider.getSearchScope(module))) {
            localXmlModel.processLocalBeansByName(searchParameters, pointer -> {
                PsiElement element = pointer.getPsiElement();
                if (element != null) {
                    result2.add((NavigationItem)new GoToSymbolProvider.BaseNavigationItem(element, name, SpringApiIcons.SpringBean));
                }
                return true;
            });
        }
    }

    private static Stream<ContextJavaBean> getFactoryBeans(@NotNull Module module) {
        if (module == null) {
            GotoSpringBeanProvider.$$$reportNull$$$0(2);
        }
        return ((List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)JamService.getJamService((Project)module.getProject()).getJamMethodElements(ContextJavaBean.BEAN_JAM_KEY, "org.springframework.context.annotation.Bean", GotoSpringBeanProvider.getSearchScope(module)), new Object[]{UastModificationTracker.getInstance((Project)module.getProject())}))).stream();
    }

    private static Stream<SpringStereotypeElement> getStereotypes(@NotNull Module module) {
        if (module == null) {
            GotoSpringBeanProvider.$$$reportNull$$$0(3);
        }
        Project project = module.getProject();
        return ((List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)SpringJamModel.getModel((Project)project).getStereotypeComponents(GotoSpringBeanProvider.getSearchScope(module), module), new Object[]{UastModificationTracker.getInstance((Project)project)}))).stream();
    }

    protected boolean acceptModule(Module module) {
        return SpringCommonUtils.isSpringConfigured((Module)module);
    }

    @NotNull
    private static GlobalSearchScope getSearchScope(@NotNull Module module) {
        if (module == null) {
            GotoSpringBeanProvider.$$$reportNull$$$0(4);
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            GotoSpringBeanProvider.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/navigation/GotoSpringBeanProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/navigation/GotoSpringBeanProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNames";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addItems";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryBeans";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

