/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.template.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentAnnotationTypeMacro
extends Macro {
    private static final List<String> EXCLUDED_ANNOTATIONS = List.of("org.springframework.context.annotation.Configuration", "org.springframework.stereotype.Controller", "org.springframework.stereotype.Service", "org.springframework.stereotype.Repository", "org.springframework.web.bind.annotation.ControllerAdvice");

    @NonNls
    public String getName() {
        return "springComponentAnnotation";
    }

    public String getPresentableName() {
        return "springComponentAnnotation(\"base annotation qname\", \"include base annotation\")";
    }

    @Nullable
    private static Query<PsiMember> findAnnotated(ExpressionContext context, PsiClass myBaseClass) {
        GlobalSearchScope scope = context.getPsiElementAtStartOffset().getResolveScope();
        if (myBaseClass != null) {
            return AnnotatedMembersSearch.search((PsiClass)myBaseClass, (SearchScope)scope).filtering(member -> {
                PsiClass annotation;
                return member instanceof PsiClass && (annotation = (PsiClass)member).isAnnotationType();
            });
        }
        return null;
    }

    public Result calculateResult(Expression @NotNull [] expressions, ExpressionContext expressionContext) {
        PsiMember member;
        boolean includeBaseClass;
        PsiClass myBaseClass;
        if (expressions == null) {
            ComponentAnnotationTypeMacro.$$$reportNull$$$0(0);
        }
        if ((myBaseClass = ComponentAnnotationTypeMacro.getBaseClass(expressions, expressionContext)) == null) {
            return null;
        }
        boolean bl = includeBaseClass = expressions.length > 1 && Boolean.parseBoolean(expressions[1].calculateResult(expressionContext).toString());
        if (includeBaseClass) {
            return new TextResult(myBaseClass.getQualifiedName());
        }
        Query<PsiMember> psiMembers = ComponentAnnotationTypeMacro.findAnnotated(expressionContext, myBaseClass);
        if (psiMembers != null && (member = (PsiMember)psiMembers.findFirst()) != null) {
            return new TextResult(member instanceof PsiClass ? ((PsiClass)member).getQualifiedName() : member.getName());
        }
        return null;
    }

    @Nullable
    private static PsiClass getBaseClass(Expression[] expressions, ExpressionContext expressionContext) {
        if (expressions == null || expressions.length == 0) {
            return null;
        }
        String paramResult = expressions[0].calculateResult(expressionContext).toString();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)expressionContext.getProject());
        return JavaPsiFacade.getInstance((Project)expressionContext.getProject()).findClass(paramResult, scope);
    }

    public Result calculateQuickResult(Expression @NotNull [] expressions, ExpressionContext expressionContext) {
        if (expressions == null) {
            ComponentAnnotationTypeMacro.$$$reportNull$$$0(1);
        }
        return this.calculateResult(expressions, expressionContext);
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
        LookupElementBuilder lookupElement;
        PsiClass myBaseClass;
        if (params == null) {
            ComponentAnnotationTypeMacro.$$$reportNull$$$0(2);
        }
        if ((myBaseClass = ComponentAnnotationTypeMacro.getBaseClass(params, context)) == null) {
            return LookupElement.EMPTY_ARRAY;
        }
        boolean includeBaseClass = params.length > 1 && Boolean.parseBoolean(params[1].calculateResult(context).toString());
        Query<PsiMember> query = ComponentAnnotationTypeMacro.findAnnotated(context, myBaseClass);
        LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
        if (includeBaseClass && (lookupElement = ComponentAnnotationTypeMacro.createLookupElement((PsiMember)myBaseClass)) != null) {
            set.add(lookupElement);
        }
        if (query != null) {
            for (PsiMember psiMember : query.findAll()) {
                LookupElementBuilder lookupElement2;
                if (!ComponentAnnotationTypeMacro.isAccepted(psiMember) || (lookupElement2 = ComponentAnnotationTypeMacro.createLookupElement(psiMember)) == null) continue;
                set.add(lookupElement2);
            }
            return set.toArray(LookupElement.EMPTY_ARRAY);
        }
        return LookupElement.EMPTY_ARRAY;
    }

    private static boolean isAccepted(PsiMember member) {
        if (!(member instanceof PsiClass)) {
            return false;
        }
        PsiClass containingClass = (PsiClass)member;
        if (EXCLUDED_ANNOTATIONS.contains(containingClass.getQualifiedName())) {
            return false;
        }
        return !ContainerUtil.exists(EXCLUDED_ANNOTATIONS, annotation -> member.hasAnnotation(annotation));
    }

    @Nullable
    private static LookupElementBuilder createLookupElement(PsiMember object) {
        if (!(object instanceof PsiClass)) {
            return null;
        }
        PsiClass psiClass = (PsiClass)object;
        String name = object.getName();
        String qualifiedName = psiClass.getQualifiedName();
        if (name == null || qualifiedName == null) {
            return null;
        }
        String packageName = StringUtil.substringBefore((String)qualifiedName, (String)("." + name));
        return LookupElementBuilder.create((String)qualifiedName).withPresentableText(name).withPsiElement((PsiElement)psiClass).withLookupString(qualifiedName).withIcon(object.getIcon(0)).withTypeText(packageName);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/template/macro/ComponentAnnotationTypeMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateQuickResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLookupItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

