/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramColors;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Color;
import java.awt.Shape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramColorManagerBase
extends DiagramColorManager {
    @NotNull
    public static final DiagramColorManager DEFAULT_COLOR_MANAGER = new DiagramColorManagerBase();

    @Override
    @NotNull
    public Color getNodeForeground(@NotNull DiagramBuilder builder, @NotNull DiagramNode node, Object element, boolean selected) {
        if (builder == null) {
            DiagramColorManagerBase.$$$reportNull$$$0(0);
        }
        if (node == null) {
            DiagramColorManagerBase.$$$reportNull$$$0(1);
        }
        if (selected) {
            Color color = (Color)ObjectUtils.notNull((Object)builder.getColorScheme().getColor(EditorColors.SELECTION_FOREGROUND_COLOR), (Object)NamedColorUtil.getListSelectionForeground((boolean)true));
            if (color == null) {
                DiagramColorManagerBase.$$$reportNull$$$0(2);
            }
            return color;
        }
        Color color = builder.getColorScheme().getDefaultForeground();
        if (color == null) {
            DiagramColorManagerBase.$$$reportNull$$$0(3);
        }
        return color;
    }

    @Override
    @Nullable
    public ColorKey getEdgeColorKey(@NotNull DiagramBuilder builder, @NotNull DiagramEdge edge) {
        DiagramRelationshipInfo relationship;
        if (builder == null) {
            DiagramColorManagerBase.$$$reportNull$$$0(4);
        }
        if (edge == null) {
            DiagramColorManagerBase.$$$reportNull$$$0(5);
        }
        if ((relationship = edge.getRelationship()).getTargetArrow() == DiagramRelationshipInfo.DELTA) {
            if (relationship.getLineType() == DiagramLineType.SOLID) {
                return DiagramColors.GENERALIZATION_EDGE;
            }
            if (relationship.getLineType() == DiagramLineType.DASHED) {
                return DiagramColors.REALIZATION_EDGE;
            }
        }
        if (!DiagramColorManagerBase.isArrow(relationship.getTargetArrow()) && !DiagramColorManagerBase.isArrow(relationship.getSourceArrow()) && relationship.getLineType() == DiagramLineType.DOTTED) {
            return DiagramColors.ANNOTATION_EDGE;
        }
        return DiagramColors.DEFAULT_EDGE;
    }

    private static boolean isArrow(@Nullable Shape arrow) {
        return arrow != null && arrow != DiagramRelationshipInfo.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramColorManagerBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramColorManagerBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeForeground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodeForeground";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeColorKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

