/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.v2.tweaks;

import com.intellij.diagram.DiagramColors;
import com.intellij.diagram.v2.handles.GraphChartHandle;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.Gray;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphChartUIParams<N, E>
extends UserDataHolderBase {
    @NotNull
    public Color getNodeHeaderBackground(@NotNull GraphChartHandle<N, E> chart, @NotNull N node) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(0);
        }
        if (node == null) {
            GraphChartUIParams.$$$reportNull$$$0(1);
        }
        Color color = Objects.requireNonNull(this.getColorScheme().getColor(DiagramColors.NODE_HEADER));
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(2);
        }
        return color;
    }

    @NotNull
    public Color getNodeBackground(@NotNull GraphChartHandle<N, E> chart, @NotNull N node, boolean isSelected) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(3);
        }
        if (node == null) {
            GraphChartUIParams.$$$reportNull$$$0(4);
        }
        Color color = isSelected ? UIUtil.getListSelectionBackground((boolean)true) : this.getColorFromScheme(DiagramColors.NODE_BACKGROUND);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(5);
        }
        return color;
    }

    @NotNull
    public Color getNodeSloppyBackgroundColor(@NotNull GraphChartHandle<N, E> chart, @NotNull N node, boolean isSelected) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(6);
        }
        if (node == null) {
            GraphChartUIParams.$$$reportNull$$$0(7);
        }
        Color color = this.getColorFromScheme(DiagramColors.NODE_SLOPPY_BACKGROUND);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(8);
        }
        return color;
    }

    @NotNull
    public Color getNodeBorderColor(@NotNull GraphChartHandle<N, E> chart, @Nullable N node, boolean isSelected) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(9);
        }
        if (GraphExportService.getInstance().isPrintMode()) {
            Gray gray = Gray._168;
            if (gray == null) {
                GraphChartUIParams.$$$reportNull$$$0(10);
            }
            return gray;
        }
        if (isSelected) {
            Color color = this.getSelectedNodeBorderColor(chart, node);
            if (color == null) {
                GraphChartUIParams.$$$reportNull$$$0(11);
            }
            return color;
        }
        Color color = this.getColorFromScheme(DiagramColors.NODE_BORDER);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(12);
        }
        return color;
    }

    @NotNull
    public Color getSelectedNodeBorderColor(@NotNull GraphChartHandle<N, E> chart, @Nullable N node) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(13);
        }
        Color color = this.getColorFromScheme(DiagramColors.SELECTED_NODE_BORDER);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(14);
        }
        return color;
    }

    @NotNull
    public Color getNodeForeground(@NotNull GraphChartHandle<N, E> chart, @NotNull N node, boolean isSelected) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(15);
        }
        if (node == null) {
            GraphChartUIParams.$$$reportNull$$$0(16);
        }
        Color color = this.getColorScheme().getDefaultForeground();
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(17);
        }
        return color;
    }

    @NotNull
    public Color getEdgeColor(@NotNull GraphChartHandle<N, E> chart, @NotNull E edge) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(18);
        }
        if (edge == null) {
            GraphChartUIParams.$$$reportNull$$$0(19);
        }
        ColorKey colorKey = Optional.ofNullable(chart.asViewHandle().getEdgePainter().getEdgeStyle(chart, edge).getLineColorKey()).orElse(DiagramColors.DEFAULT_EDGE);
        Color color = this.getColorFromScheme(colorKey);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(20);
        }
        return color;
    }

    @NotNull
    public Color getEdgeSelectionColor(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(21);
        }
        Color color = this.getColorFromScheme(DiagramColors.EDGE_SELECTION);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(22);
        }
        return color;
    }

    @NotNull
    public Color getBendColor(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(23);
        }
        Color color = this.getColorFromScheme(DiagramColors.BEND);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(24);
        }
        return color;
    }

    @NotNull
    public Color getBendSelectionColor(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(25);
        }
        Color color = this.getColorFromScheme(DiagramColors.BEND_SELECTION);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(26);
        }
        return color;
    }

    @NotNull
    public Color getSelectionBoxBorderColor(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(27);
        }
        Color color = this.getColorFromScheme(DiagramColors.SELECTION_BOX_BORDER);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(28);
        }
        return color;
    }

    @NotNull
    public Color getSelectionBoxBackgroundColor(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(29);
        }
        Color color = this.getColorFromScheme(DiagramColors.SELECTION_BOX_BACKGROUND);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(30);
        }
        return color;
    }

    @NotNull
    public Color getHotSpotColor(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(31);
        }
        Color color = this.getColorFromScheme(DiagramColors.HOT_SPOT);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(32);
        }
        return color;
    }

    @NotNull
    public Color getPortColor(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(33);
        }
        Color color = this.getColorFromScheme(DiagramColors.PORT);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(34);
        }
        return color;
    }

    @NotNull
    public Color getSnappingColor(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(35);
        }
        Color color = this.getColorFromScheme(DiagramColors.SNAPPING);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(36);
        }
        return color;
    }

    @NotNull
    public Color getFineGridColor(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(37);
        }
        Color color = this.getColorFromScheme(DiagramColors.FINE_GRID);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(38);
        }
        return color;
    }

    @NotNull
    public Color getCoarseGridColor(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(39);
        }
        Color color = this.getColorFromScheme(DiagramColors.COARSE_GRID);
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(40);
        }
        return color;
    }

    @NotNull
    public Color getToolbarBackground(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(41);
        }
        Color color = UIUtil.getPanelBackground();
        if (color == null) {
            GraphChartUIParams.$$$reportNull$$$0(42);
        }
        return color;
    }

    @NotNull
    public Font getNodeFont(@NotNull GraphChartHandle<N, E> chart) {
        if (chart == null) {
            GraphChartUIParams.$$$reportNull$$$0(43);
        }
        Font font = StartupUiUtil.getLabelFont();
        if (font == null) {
            GraphChartUIParams.$$$reportNull$$$0(44);
        }
        return font;
    }

    @NotNull
    public EditorColorsScheme getColorScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            GraphChartUIParams.$$$reportNull$$$0(45);
        }
        return editorColorsScheme;
    }

    @NotNull
    public Color getColorFromScheme(@NotNull ColorKey colorKey) {
        Color color;
        if (colorKey == null) {
            GraphChartUIParams.$$$reportNull$$$0(46);
        }
        if ((color = this.getColorScheme().getColor(colorKey)) == null) {
            color = colorKey.getDefaultColor();
        }
        Color color2 = Objects.requireNonNull(color);
        if (color2 == null) {
            GraphChartUIParams.$$$reportNull$$$0(47);
        }
        return color2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 8, 10, 11, 12, 14, 17, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 45, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chart";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/v2/tweaks/GraphChartUIParams";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/v2/tweaks/GraphChartUIParams";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeHeaderBackground";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeBackground";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeSloppyBackgroundColor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeBorderColor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodeBorderColor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeForeground";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeColor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeSelectionColor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getBendColor";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getBendSelectionColor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionBoxBorderColor";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionBoxBackgroundColor";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getHotSpotColor";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPortColor";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnappingColor";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getFineGridColor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoarseGridColor";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarBackground";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeFont";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorFromScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodeHeaderBackground";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 47: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodeBackground";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNodeSloppyBackgroundColor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNodeBorderColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodeBorderColor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNodeForeground";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeColor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeSelectionColor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getBendColor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBendSelectionColor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionBoxBorderColor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionBoxBackgroundColor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getHotSpotColor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPortColor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getSnappingColor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFineGridColor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getCoarseGridColor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getToolbarBackground";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getNodeFont";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getColorFromScheme";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 8, 10, 11, 12, 14, 17, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 45, 47 -> new IllegalStateException(string);
        };
    }
}

