/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.PgDialectBase;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.dataFlow.PgDFABuildingVisitor;
import com.intellij.sql.dialects.postgres.dataFlow.PgErrorSpecHelper;
import com.intellij.sql.dialects.postgres.psi.PgCreatePreparedStatement;
import com.intellij.sql.dialects.postgres.refactoring.PgExtractFunctionHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Pg83Dialect
extends PgDialectBase {
    private final NotNullLazyValue<LazyInstanceData> myInstanceData;

    protected Pg83Dialect(@NotNull String id) {
        if (id == null) {
            Pg83Dialect.$$$reportNull$$$0(0);
        }
        super(id);
        this.myInstanceData = NotNullLazyValue.atomicLazy(() -> new LazyInstanceData());
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor) {
        Object preparedStatement;
        String nameUC;
        if (place == null) {
            Pg83Dialect.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            Pg83Dialect.$$$reportNull$$$0(2);
        }
        if (!super.processReservedEntitiesWithType(name2, place, resolve, processor)) {
            return false;
        }
        String string = nameUC = name2 == null ? null : StringUtil.toUpperCase((String)name2);
        if (resolve && name2 != null && LazyData.ARG_PATTERN.matcher(name2).matches() && (preparedStatement = (PgCreatePreparedStatement)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{PgCreatePreparedStatement.class})) != null && !processor.executeTarget(((PgCreatePreparedStatement)((Object)preparedStatement)).getArgument(name2), (DasType)DasTypeSystemBase.UNKNOWN, null, ResolveState.initial())) {
            return false;
        }
        if (processor.isExpected(ObjectKind.OPERATOR_CLASS)) {
            if (!resolve) {
                for (ReservedEntity target : ((LazyInstanceData)this.myInstanceData.getValue()).myOperatorClasses.values()) {
                    if (processor.executeTarget((DasSymbol)target, (DasType)DasTypeSystemBase.REFERENCE, Boolean.valueOf(false), ResolveState.initial())) continue;
                    return false;
                }
            } else if (((LazyInstanceData)this.myInstanceData.getValue()).myOperatorClasses.containsKey(nameUC) && !processor.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).myOperatorClasses.get(nameUC), (DasType)DasTypeSystemBase.REFERENCE, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        }
        if (processor.isExpected(SqlDbElementType.ACCESS_METHOD)) {
            for (ReservedEntity am : ((LazyInstanceData)this.myInstanceData.getValue()).myAccessMethods) {
                if (Pg83Dialect.processReservedEntitiesWithTypeSimple((ReservedEntity)am, (DasType)DasTypeSystemBase.REFERENCE, (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)false, null)) continue;
                return false;
            }
        }
        if (processor.isExpected(SqlDbElementType.COLUMN)) {
            SqlExpression expression;
            boolean process = true;
            if (!resolve && (expression = SqlImplUtil.getQualifier((PsiElement)place)) != null && expression.getDasType() == DasTypeSystemBase.UNKNOWN) {
                process = false;
            }
            if (process) {
                for (ReservedEntity entity : ((LazyInstanceData)this.myInstanceData.getValue()).myIntegerEntities.values()) {
                    if (Pg83Dialect.processReservedEntitiesWithTypeSimple((ReservedEntity)entity, (DasType)this.getTypeSystem().getIntType(), (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)true, (Boolean)false)) continue;
                    return false;
                }
            }
        }
        if (place instanceof SqlReferenceExpression) {
            SqlReferenceElementType type = ((SqlReferenceExpression)place).getReferenceElementType();
            if (type == SqlCompositeElementTypes.SQL_TABLESPACE_REFERENCE) {
                if (!Pg83Dialect.processReservedEntitiesWithTypeSimple((ReservedEntity)((LazyInstanceData)this.myInstanceData.getValue()).myPgDefaultTablespace, (DasType)DasTypeSystemBase.REFERENCE, (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) {
                    return false;
                }
                if (!Pg83Dialect.processReservedEntitiesWithTypeSimple((ReservedEntity)((LazyInstanceData)this.myInstanceData.getValue()).myPgGlobalTablespace, (DasType)DasTypeSystemBase.REFERENCE, (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) {
                    return false;
                }
            }
            if (((SqlReferenceExpression)place).getQualifierExpression() == null) {
                for (ReservedEntity object : this.getReservedObjects()) {
                    if (processor.executeTarget((DasSymbol)object, null, Boolean.valueOf(false), ResolveState.initial())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        PsiElement refParent;
        if (processor == null) {
            Pg83Dialect.$$$reportNull$$$0(3);
        }
        if (state == null) {
            Pg83Dialect.$$$reportNull$$$0(4);
        }
        if (ref == null) {
            Pg83Dialect.$$$reportNull$$$0(5);
        }
        if ((refParent = ref.getElement().getParent()) instanceof SqlClause && refParent.getParent() instanceof SqlSelectOption && !Pg83Dialect.processAliases((SqlScopeProcessor)processor, (ResolveState)state, (PsiReference)ref)) {
            return false;
        }
        return super.processUnqualifiedResolve(processor, state, ref);
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            Pg83Dialect.$$$reportNull$$$0(6);
        }
        return 63;
    }

    @NotNull
    protected abstract List<ReservedEntity> getReservedObjects();

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        if (type == ObjectKind.OPERATOR_CLASS || type == ObjectKind.OPERATOR_FAMILY || type == PgElementTypes.Kinds.TEXT_SEARCH_PARSER || type == PgElementTypes.Kinds.TEXT_SEARCH_DICTIONARY || type == PgElementTypes.Kinds.TEXT_SEARCH_CONFIGURATION || type == PgElementTypes.Kinds.TEXT_SEARCH_TEMPLATE || type == ObjectKind.LANGUAGE) {
            result.add((ObjectKind)SqlDbElementType.SCHEMA);
        }
        return super.getParentDbTypes(result, type);
    }

    public boolean respectsCurrentTracerContext(@Nullable SqlDefinition definition) {
        return definition == null || !definition.isTemporary();
    }

    @NotNull
    public Trinity<ObjectKind, Boolean, String> getImplicitParentInfo(@Nullable SqlDefinition definition, @NotNull ObjectKind parentKind) {
        if (parentKind == null) {
            Pg83Dialect.$$$reportNull$$$0(7);
        }
        if (parentKind == ObjectKind.SCHEMA && definition != null && definition.isTemporary()) {
            Trinity trinity = Trinity.create((Object)parentKind, (Object)false, (Object)"pg_temp");
            if (trinity == null) {
                Pg83Dialect.$$$reportNull$$$0(8);
            }
            return trinity;
        }
        Trinity trinity = super.getImplicitParentInfo(definition, parentKind);
        if (trinity == null) {
            Pg83Dialect.$$$reportNull$$$0(9);
        }
        return trinity;
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName @Nullable [] dsNames) {
        ObjectName dbName = Pg83Dialect.getDbName(dataSource);
        DasNamespace namespace = Pg83Dialect.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)dbName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[]{namespace.getKind() == SqlDbElementType.SCHEMA ? null : TreePatternUtils.create((ObjectName)PgDialect.LazyData.PUBLIC_NAME, (ObjectKind)SqlDbElementType.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])});
            if (treePattern == null) {
                Pg83Dialect.$$$reportNull$$$0(10);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)SqlImportUtil.createPositiveDatabase((dataSource == null ? 1 : 0) != 0, (ObjectName)dbName, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create((ObjectName)PgDialect.LazyData.PUBLIC_NAME, (ObjectKind)SqlDbElementType.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])}))));
    }

    @NotNull
    public TreePattern applyImplicitImports(ObjectName @Nullable [] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            Pg83Dialect.$$$reportNull$$$0(11);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath((TreePattern)pattern, (ObjectName[])dsNames, Arrays.asList(ObjectName.quoted((String)"pg_temp"), ObjectName.quoted((String)"pg_catalog")), (boolean)true, (ObjectKind[])new ObjectKind[]{SqlImportUtil.DATA_SOURCE, SqlDbElementType.DATABASE, SqlDbElementType.SCHEMA});
        if (treePattern == null) {
            Pg83Dialect.$$$reportNull$$$0(12);
        }
        return treePattern;
    }

    @Override
    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            Pg83Dialect.$$$reportNull$$$0(13);
        }
        if (type == SqlDbElementType.OBJECT_ATTRIBUTE && expectedTypes.contains(SqlDbElementType.COLUMN)) {
            return true;
        }
        if (strict) {
            return false;
        }
        if (SqlDialectImplUtilCore.isLabelOrRoutineQualification((PsiElement)(symbol instanceof PsiElement ? (PsiElement)symbol : null), (ObjectKind)type, (PsiElement)place, (boolean)isCompletion)) {
            return true;
        }
        if (type == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, false, isCompletion);
    }

    public boolean isAutoIncrementColumn(@NotNull DasColumn column) {
        if (column == null) {
            Pg83Dialect.$$$reportNull$$$0(14);
        }
        if (super.isAutoIncrementColumn(column)) {
            return true;
        }
        String type = column.getDasType().getSpecification();
        return LazyData.SERIAL_PATTERN.matcher(type).matches();
    }

    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            Pg83Dialect.$$$reportNull$$$0(15);
        }
        return collection;
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return type != SqlDbElementType.CURSOR && super.shallResolve(o, type);
    }

    @NotNull
    public JBIterable<? extends DasArgument> getSignatureParameters(@NotNull DasRoutine routine) {
        if (routine == null) {
            Pg83Dialect.$$$reportNull$$$0(16);
        }
        JBIterable jBIterable = DasUtil.getParameters((DasRoutine)routine).filter(p -> p.getArgumentDirection().isIn());
        if (jBIterable == null) {
            Pg83Dialect.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return PgExtractFunctionHelper.INSTANCE;
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new PgDFABuildingVisitor((SqlLanguageDialectEx)this);
    }

    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        PgErrorSpecHelper pgErrorSpecHelper = PgErrorSpecHelper.INSTANCE;
        if (pgErrorSpecHelper == null) {
            Pg83Dialect.$$$reportNull$$$0(18);
        }
        return pgErrorSpecHelper;
    }

    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_IF, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false})})});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 12, 15, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentKind";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/Pg83Dialect";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/Pg83Dialect";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitParentInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureParameters";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitParentInfo";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 12, 15, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static final class LazyData {
        static final Pattern ARG_PATTERN = Pattern.compile("\\$\\d+");
        static final Pattern SERIAL_PATTERN = Pattern.compile("(?i)(?:big|small)?serial|serial[248]");
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(SqlDbElementType.KEY, SqlDbElementType.INDEX, SqlDbElementType.TRIGGER, SqlDbElementType.RULE, SqlDbElementType.POLICY);

        private LazyData() {
        }
    }

    private class LazyInstanceData {
        private final List<ReservedEntity> myAccessMethods;
        private final Map<String, ReservedEntity> myIntegerEntities;
        private final ReservedEntity myPgDefaultTablespace;
        private final ReservedEntity myPgGlobalTablespace;
        private final Map<String, ReservedEntity> myOperatorClasses;

        private LazyInstanceData() {
            this.myAccessMethods = Arrays.asList(new ReservedEntity(Pg83Dialect.this.getDbms(), "btree", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "hash", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "gist", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "spgist", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "gin", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "brin", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "bloom", SqlDbElementType.ACCESS_METHOD));
            this.myIntegerEntities = SqlDialectImplUtilCore.buildEntities((Dbms)Pg83Dialect.this.getDbms(), (ObjectKind)SqlDbElementType.COLUMN, (String[])new String[]{"OID", "TABLEOID", "XMIN", "CMIN", "XMAX", "CMAX", "CTID"});
            this.myPgDefaultTablespace = new ReservedEntity(Pg83Dialect.this.getDbms(), "pg_default", SqlDbElementType.TABLESPACE);
            this.myPgGlobalTablespace = new ReservedEntity(Pg83Dialect.this.getDbms(), "pg_global", SqlDbElementType.TABLESPACE);
            this.myOperatorClasses = SqlDialectImplUtilCore.buildEntities((Dbms)Pg83Dialect.this.getDbms(), (ObjectKind)ObjectKind.OPERATOR_CLASS, (String[])new String[]{"INTEGER_OPS", "TEXT_PATTERN_OPS", "INT8_OPS", "INT4_OPS", "INT2_OPS", "VARCHAR_PATTERN_OPS", "BPCHAR_PATTERN_OPS", "JSONB_PATH_OPS", "JSONB_OPS"});
        }
    }
}

