/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.StubElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.JvmFileClassInfo;
import org.jetbrains.kotlin.psi.psiUtil.JvmFileClassUtil;
import org.jetbrains.kotlin.psi.stubs.elements.KtFileStubBuilderKt;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubKindImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtFileStubBuilder;", "Lcom/intellij/psi/stubs/DefaultStubBuilder;", "<init>", "()V", "buildStubTree", "Lcom/intellij/psi/stubs/StubElement;", "file", "Lcom/intellij/psi/PsiFile;", "createStubForFile", "psi-impl"})
public final class KtFileStubBuilder
extends DefaultStubBuilder {
    @NotNull
    public StubElement<?> buildStubTree(@NotNull PsiFile file) {
        StubBuilder stubBuilder;
        KtFile ktFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtFile ktFile2 = ktFile = file instanceof KtFile ? (KtFile)file : null;
        if (ktFile != null && (stubBuilder = ktFile.getCustomStubBuilder()) != null) {
            StubBuilder it = stubBuilder;
            boolean bl = false;
            StubElement stubElement = it.buildStubTree(file);
            Intrinsics.checkNotNullExpressionValue((Object)stubElement, (String)"buildStubTree(...)");
            return stubElement;
        }
        StubElement stubElement = super.buildStubTree(file);
        Intrinsics.checkNotNullExpressionValue((Object)stubElement, (String)"buildStubTree(...)");
        return stubElement;
    }

    @NotNull
    protected StubElement<?> createStubForFile(@NotNull PsiFile file) {
        KotlinFileStubKindImpl kotlinFileStubKindImpl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof KtFile)) {
            StubElement stubElement = super.createStubForFile(file);
            Intrinsics.checkNotNullExpressionValue((Object)stubElement, (String)"createStubForFile(...)");
            return stubElement;
        }
        FqName packageFqName = ((KtFile)file).getPackageFqName();
        String errorMessage = KtFileStubBuilderKt.access$findErrorMessage((KtFile)file);
        if (errorMessage != null) {
            kotlinFileStubKindImpl = new KotlinFileStubKindImpl.Invalid(errorMessage);
        } else if (((KtFile)file).isScript()) {
            kotlinFileStubKindImpl = new KotlinFileStubKindImpl.Script(packageFqName);
        } else if (((KtFile)file).hasTopLevelCallables()) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.INSTANCE.getFileClassInfoNoResolve((KtFile)file);
            kotlinFileStubKindImpl = new KotlinFileStubKindImpl.Facade(packageFqName, fileClassInfo.getFacadeClassFqName());
        } else {
            kotlinFileStubKindImpl = new KotlinFileStubKindImpl.File(packageFqName);
        }
        KotlinFileStubKindImpl.Invalid kind = kotlinFileStubKindImpl;
        return new KotlinFileStubImpl((KtFile)file, kind);
    }
}

