/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers.resolve;

import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.references.UrlPathContextKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.core.model.SwaggerMergedModel;
import com.intellij.swagger.core.model.api.SwMetaHolder;
import com.intellij.swagger.core.model.api.SwModelBase;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.providers.resolve.SpecificationResolveHelperKt;
import com.intellij.swagger.core.providers.resolve.SwUrlPathSpecification;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a+\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0000\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"resolveUrl", "Lkotlin/sequences/Sequence;", "Lcom/intellij/swagger/core/model/api/SwUrl;", "searchedUrl", "Lcom/intellij/microservices/url/UrlPath;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "resolveBasePath", "specificationModel", "Lcom/intellij/swagger/core/model/api/SwModelBase;", "resolveOrdinaryUrl", "resolveLocalObject", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "path", "", "", "(Lcom/intellij/psi/PsiFile;[Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSpecificationResolveHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecificationResolveHelper.kt\ncom/intellij/swagger/core/providers/resolve/SpecificationResolveHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1#2:61\n1761#3,3:62\n*S KotlinDebug\n*F\n+ 1 SpecificationResolveHelper.kt\ncom/intellij/swagger/core/providers/resolve/SpecificationResolveHelperKt\n*L\n47#1:62,3\n*E\n"})
public final class SpecificationResolveHelperKt {
    @NotNull
    public static final Sequence<SwUrl> resolveUrl(@NotNull UrlPath searchedUrl, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)searchedUrl, (String)"searchedUrl");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Project project = scope.getProject();
        if (project == null) {
            return SequencesKt.emptySequence();
        }
        Project project2 = project;
        return SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)SwaggerMergedModel.Companion.getInstance(project2).getBaseModelElements(scope)), arg_0 -> SpecificationResolveHelperKt.resolveUrl$lambda$0(project2, arg_0)), arg_0 -> SpecificationResolveHelperKt.resolveUrl$lambda$1(searchedUrl, arg_0));
    }

    private static final Sequence<SwUrl> resolveBasePath(UrlPath searchedUrl, SwModelBase specificationModel) {
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)specificationModel.getBasePaths()), arg_0 -> SpecificationResolveHelperKt.resolveBasePath$lambda$0(searchedUrl, arg_0));
    }

    private static final Sequence<SwUrl> resolveOrdinaryUrl(UrlPath searchedUrl, SwModelBase specificationModel) {
        int searchedUrlSegmentsCount = searchedUrl.getSegments().size();
        List searchedUrlsWithTrimmedBasePaths2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)specificationModel.getBasePaths()), (Function1)((Function1)resolveOrdinaryUrl.searchedUrlsWithTrimmedBasePaths.1.INSTANCE))), SpecificationResolveHelperKt::resolveOrdinaryUrl$lambda$0), arg_0 -> SpecificationResolveHelperKt.resolveOrdinaryUrl$lambda$1(searchedUrl, arg_0)), arg_0 -> SpecificationResolveHelperKt.resolveOrdinaryUrl$lambda$2(searchedUrlSegmentsCount, searchedUrl, arg_0)));
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)specificationModel.getUrls()), arg_0 -> SpecificationResolveHelperKt.resolveOrdinaryUrl$lambda$3(searchedUrlsWithTrimmedBasePaths2, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final PsiElement resolveLocalObject(@NotNull PsiFile psiFile, String ... path) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        v0 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
        v1 = SwaggerMergedModel.Companion.getInstance(v0);
        v2 = GlobalSearchScope.fileScope((PsiFile)psiFile);
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"fileScope(...)");
        var3_2 = (SwModelBase)CollectionsKt.firstOrNull(v1.getBaseModelElements(v2));
        if (var3_2 == null) ** GOTO lbl-1000
        it = var3_2;
        $i$a$-let-SpecificationResolveHelperKt$resolveLocalObject$cachedOrNewSpec$1 = false;
        v3 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getProject(...)");
        var7_5 = it.substitute(v3);
        var4_6 = var7_5 instanceof SwMetaHolder ? (SwMetaHolder)var7_5 : null;
        if (var4_6 != null) {
            v4 = var4_6;
        } else lbl-1000:
        // 2 sources

        {
            v4 = cachedOrNewSpec = (SwMetaHolder)SwTreeUtil.INSTANCE.getParentOfType((PsiElement)psiFile, SwSpecificationFile.class, true);
        }
        if (cachedOrNewSpec == null) {
            Logger.getInstance((String)"SwSpecificationResolveHelper").warn("Unable to prepare specification model for file " + psiFile.getName());
        }
        v5 = cachedOrNewSpec;
        return v5 != null ? v5.find(Arrays.copyOf(path, path.length)) : null;
    }

    private static final SwModelBase resolveUrl$lambda$0(Project $project, SwModelBase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.substitute($project);
    }

    private static final Sequence resolveUrl$lambda$1(UrlPath $searchedUrl, SwModelBase specification) {
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        return SequencesKt.plus(SpecificationResolveHelperKt.resolveBasePath($searchedUrl, specification), SpecificationResolveHelperKt.resolveOrdinaryUrl($searchedUrl, specification));
    }

    private static final boolean resolveBasePath$lambda$0(UrlPath $searchedUrl, SwUrl basePath2) {
        Intrinsics.checkNotNullParameter((Object)basePath2, (String)"basePath");
        return SwUrlPathSpecification.INSTANCE.parsePath(basePath2.getUrlString()).isCompatibleWith($searchedUrl);
    }

    private static final UrlPath resolveOrdinaryUrl$lambda$0(String basePath2) {
        Intrinsics.checkNotNullParameter((Object)basePath2, (String)"basePath");
        return UrlPathContextKt.chopLeadingEmptyBlock((UrlPath)UrlPath.Companion.fromExactString(basePath2));
    }

    private static final boolean resolveOrdinaryUrl$lambda$1(UrlPath $searchedUrl, UrlPath parsedBasePath) {
        Intrinsics.checkNotNullParameter((Object)parsedBasePath, (String)"parsedBasePath");
        return parsedBasePath.canBePrefixFor($searchedUrl);
    }

    private static final UrlPath resolveOrdinaryUrl$lambda$2(int $searchedUrlSegmentsCount, UrlPath $searchedUrl, UrlPath basePathPrefix) {
        Intrinsics.checkNotNullParameter((Object)basePathPrefix, (String)"basePathPrefix");
        int basePathSegmentsCount = basePathPrefix.getSegments().size();
        return basePathSegmentsCount >= $searchedUrlSegmentsCount ? null : new UrlPath(CollectionsKt.drop((Iterable)$searchedUrl.getSegments(), (int)basePathSegmentsCount));
    }

    private static final boolean resolveOrdinaryUrl$lambda$3(List $searchedUrlsWithTrimmedBasePaths, SwUrl urlFromSpecification) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)urlFromSpecification, (String)"urlFromSpecification");
            Iterable $this$any$iv = $searchedUrlsWithTrimmedBasePaths;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UrlPath it = (UrlPath)element$iv;
                    boolean bl2 = false;
                    if (!SwUrlPathSpecification.INSTANCE.parsePath(urlFromSpecification.getUrlString()).isCompatibleWith(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

