/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.refactoring.rename;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.microservices.url.parameters.PathVariableDeclaringReference;
import com.intellij.microservices.url.parameters.PathVariableUsageReference;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwParameter;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Server;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Variable;
import com.intellij.swagger.core.refactoring.SwRefactoringUtilsKt;
import com.intellij.swagger.core.refactoring.rename.SwYamlPathVariableRenameHandler;
import com.intellij.swagger.core.refactoring.rename.SwYamlPathVariableRenameHandler$findPathVariableDeclarationPsiElement$;
import com.intellij.swagger.core.refactoring.rename.VariableDeclarationInfo;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J-\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J.\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J.\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J.\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001f2\u0006\u0010 \u001a\u00020\u0017H\u0002J.\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020\u0017H\u0002J.\u0010(\u001a\u00020\t2\u0006\u0010\"\u001a\u00020)2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020\u0017H\u0002J&\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020%0\u0013H\u0002\u00a8\u0006."}, d2={"Lcom/intellij/swagger/core/refactoring/rename/SwYamlPathVariableRenameHandler;", "Lcom/intellij/refactoring/rename/PsiElementRenameHandler;", "<init>", "()V", "isAvailableOnDataContext", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "findPathVariableDeclarationPsiElement", "Lcom/intellij/swagger/core/refactoring/rename/VariableDeclarationInfo;", "findPathVariableUsages", "", "Lcom/intellij/usageView/UsageInfo;", "declarationInfo", "variableName", "", "handleUnitTestMode", "variableDeclaration", "variableUsages", "showRenameDialog", "performRename", "declaration", "usages", "", "newName", "renameKeyOfKeyValue", "psiElement", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "rangesInElement", "Lcom/intellij/openapi/util/TextRange;", "yamlElementGenerator", "Lorg/jetbrains/yaml/YAMLElementGenerator;", "renameValueOfKeyValue", "Lorg/jetbrains/yaml/psi/YAMLValue;", "renameAllOccurrencesInText", "replacement", "originalText", "occurrenceRanges", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwYamlPathVariableRenameHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwYamlPathVariableRenameHandler.kt\ncom/intellij/swagger/core/refactoring/rename/SwYamlPathVariableRenameHandler\n+ 2 SwRefactoringUtils.kt\ncom/intellij/swagger/core/refactoring/SwRefactoringUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n28#2,5:234\n28#2,5:240\n28#2,5:246\n28#2,5:252\n40#2,2:258\n42#2,6:261\n1#3:239\n1#3:245\n1#3:251\n1#3:257\n1#3:267\n477#4:260\n1869#5,2:268\n*S KotlinDebug\n*F\n+ 1 SwYamlPathVariableRenameHandler.kt\ncom/intellij/swagger/core/refactoring/rename/SwYamlPathVariableRenameHandler\n*L\n45#1:234,5\n46#1:240,5\n63#1:246,5\n67#1:252,5\n79#1:258,2\n79#1:261,6\n45#1:239\n46#1:245\n63#1:251\n67#1:257\n79#1:260\n153#1:268,2\n*E\n"})
final class SwYamlPathVariableRenameHandler
extends PsiElementRenameHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiReference psiReference;
        PsiReference psiReference2;
        boolean bl;
        PsiReference it$iv;
        PsiReference psiReference3;
        Editor editor$iv;
        PsiReference psiReference4;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        PsiFile psiFile = (PsiFile)dataContext.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof YAMLFile)) return false;
        if (!SwSpecificationDetectionKt.detectIsSwaggerLikeSpecificationFile$default(psiFile2, false, 2, null)) {
            return false;
        }
        DataContext dataContext$iv = dataContext;
        boolean unwrapMultiReference$iv = true;
        boolean $i$f$findReferenceOfType = false;
        Editor editor = (Editor)dataContext$iv.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            psiReference4 = null;
        } else {
            PsiReference psiReference5;
            PsiReference psiReference6;
            editor$iv = editor;
            psiReference3 = TargetElementUtil.findReference((Editor)editor$iv);
            if (psiReference3 != null) {
                it$iv = psiReference3;
                bl = false;
                psiReference6 = PsiReferenceUtil.findReferenceOfClass((PsiReference)it$iv, PathVariableDeclaringReference.class);
            } else {
                psiReference6 = psiReference5 = null;
            }
            if (!(psiReference6 instanceof PathVariableDeclaringReference)) {
                psiReference5 = null;
            }
            psiReference4 = (PsiReference)((PathVariableDeclaringReference)psiReference5);
        }
        if (psiReference4 != null) return true;
        dataContext$iv = dataContext;
        unwrapMultiReference$iv = true;
        $i$f$findReferenceOfType = false;
        Editor editor2 = (Editor)dataContext$iv.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return false;
        }
        editor$iv = editor2;
        psiReference3 = TargetElementUtil.findReference((Editor)editor$iv);
        if (psiReference3 != null) {
            it$iv = psiReference3;
            bl = false;
            psiReference2 = PsiReferenceUtil.findReferenceOfClass((PsiReference)it$iv, PathVariableUsageReference.class);
        } else {
            psiReference2 = psiReference = null;
        }
        if (!(psiReference2 instanceof PathVariableUsageReference)) {
            psiReference = null;
        }
        PsiReference psiReference7 = (PsiReference)((PathVariableUsageReference)psiReference);
        if (psiReference7 == null) return false;
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        VariableDeclarationInfo variableDeclaration = this.findPathVariableDeclarationPsiElement(dataContext);
        if (variableDeclaration == null) {
            super.invoke(project, editor, file, dataContext);
            return;
        }
        List<UsageInfo> variableUsages = this.findPathVariableUsages(variableDeclaration, variableDeclaration.getVariableName());
        if (this.handleUnitTestMode(dataContext, project, variableDeclaration, variableUsages)) {
            return;
        }
        this.showRenameDialog(dataContext, project, variableDeclaration, variableUsages);
    }

    /*
     * WARNING - void declaration
     */
    private final VariableDeclarationInfo findPathVariableDeclarationPsiElement(DataContext dataContext) {
        void $this$filterIsInstance$iv$iv;
        void psiElement$iv;
        PsiReference it$iv;
        PsiReference psiReference;
        PsiReference psiReference2;
        Class[] dataContext$iv = dataContext;
        boolean unwrapMultiReference$iv = true;
        boolean $i$f$findReferenceOfType = false;
        Editor editor = (Editor)dataContext$iv.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            psiReference2 = null;
        } else {
            PsiReference psiReference3;
            PsiReference psiReference4;
            Editor editor$iv = editor;
            PsiReference psiReference5 = TargetElementUtil.findReference((Editor)editor$iv);
            if (psiReference5 != null) {
                PsiReference it$iv2 = psiReference5;
                boolean bl = false;
                psiReference4 = PsiReferenceUtil.findReferenceOfClass((PsiReference)it$iv2, PathVariableDeclaringReference.class);
            } else {
                psiReference4 = psiReference3 = null;
            }
            if (!(psiReference4 instanceof PathVariableDeclaringReference)) {
                psiReference3 = null;
            }
            psiReference2 = (PsiReference)((PathVariableDeclaringReference)psiReference3);
        }
        PathVariableDeclaringReference declarationReferenceAtCaret = (PathVariableDeclaringReference)psiReference2;
        if (declarationReferenceAtCaret != null) {
            return new VariableDeclarationInfo(CollectionsKt.listOf((Object)declarationReferenceAtCaret));
        }
        Class[] dataContext$iv2 = dataContext;
        boolean unwrapMultiReference$iv2 = true;
        boolean $i$f$findReferenceOfType22 = false;
        Editor editor2 = (Editor)dataContext$iv2.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            psiReference = null;
        } else {
            PsiReference psiReference6;
            PsiReference psiReference7;
            Editor editor$iv = editor2;
            PsiReference bl = TargetElementUtil.findReference((Editor)editor$iv);
            if (bl != null) {
                it$iv = bl;
                boolean bl2 = false;
                psiReference7 = PsiReferenceUtil.findReferenceOfClass((PsiReference)it$iv, PathVariableUsageReference.class);
            } else {
                psiReference7 = psiReference6 = null;
            }
            if (!(psiReference7 instanceof PathVariableUsageReference)) {
                psiReference6 = null;
            }
            psiReference = (PsiReference)((PathVariableUsageReference)psiReference6);
        }
        PathVariableUsageReference pathVariableUsageReference = (PathVariableUsageReference)psiReference;
        if (pathVariableUsageReference == null) {
            return null;
        }
        PathVariableUsageReference usageReference = pathVariableUsageReference;
        dataContext$iv2 = new Class[]{SwUrl.class, Openapi3Server.class};
        SwModelElement urlOrServer = (SwModelElement)SequencesKt.firstOrNull(SwTreeUtil.INSTANCE.getParentsOfTypes(usageReference.getElement(), dataContext$iv2));
        SwModelElement $i$f$findReferenceOfType22 = urlOrServer;
        PsiElement psiElement = SwRefactoringUtilsKt.substituteReferenceHolder((PsiElement)($i$f$findReferenceOfType22 instanceof SwUrl ? ((SwUrl)urlOrServer).getSourcePsi() : ($i$f$findReferenceOfType22 instanceof Openapi3Server ? ((Openapi3Server)urlOrServer).getUrlValue().getSourcePsi() : null)));
        if (psiElement == null) {
            return null;
        }
        PsiElement referenceHolder = psiElement;
        $i$f$findReferenceOfType22 = referenceHolder;
        String referenceValue$iv = SwRefactoringUtilsKt.getReferenceText((PsiReference)usageReference);
        boolean $i$f$findReferencesOfType = false;
        PsiReference[] psiReferenceArray = psiElement$iv.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        it$iv = ArraysKt.asSequence((Object[])psiReferenceArray);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)findPathVariableDeclarationPsiElement$$inlined$findReferencesOfType$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List declarationReferences = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<PathVariableDeclaringReference, Boolean>(referenceValue$iv){
            final /* synthetic */ String $referenceValue;
            {
                this.$referenceValue = $referenceValue;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Boolean invoke(PsiReference it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$referenceValue != null ? Intrinsics.areEqual((Object)SwRefactoringUtilsKt.getReferenceText(it), (Object)this.$referenceValue) : true;
            }
        })));
        return !((Collection)declarationReferences).isEmpty() ? new VariableDeclarationInfo(declarationReferences) : null;
    }

    private final List<UsageInfo> findPathVariableUsages(VariableDeclarationInfo declarationInfo, String variableName) {
        Class[] classArray = new Class[]{SwUrl.class, Openapi3Server.class};
        SwModelElement urlOrServer = (SwModelElement)SequencesKt.firstOrNull(SwTreeUtil.INSTANCE.getParentsOfTypes(declarationInfo.getDeclarationPsiElement(), classArray));
        SwModelElement swModelElement = urlOrServer;
        Sequence usagePsiElementSequence = swModelElement instanceof SwUrl ? SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)((SwUrl)urlOrServer).getSupportedOperations()), SwYamlPathVariableRenameHandler::findPathVariableUsages$lambda$0), arg_0 -> SwYamlPathVariableRenameHandler.findPathVariableUsages$lambda$1(variableName, arg_0)), SwYamlPathVariableRenameHandler::findPathVariableUsages$lambda$2) : (swModelElement instanceof Openapi3Server ? SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Openapi3Server)urlOrServer).getVariables()), arg_0 -> SwYamlPathVariableRenameHandler.findPathVariableUsages$lambda$3(variableName, arg_0)), SwYamlPathVariableRenameHandler::findPathVariableUsages$lambda$4) : SequencesKt.emptySequence());
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)usagePsiElementSequence, SwYamlPathVariableRenameHandler::findPathVariableUsages$lambda$5));
    }

    private final boolean handleUnitTestMode(DataContext dataContext, Project project, VariableDeclarationInfo variableDeclaration, List<? extends UsageInfo> variableUsages) {
        boolean bl;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        String newNameInTestMode = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
        boolean bl2 = bl = newNameInTestMode != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "New name must be provided for rename handler";
            throw new AssertionError((Object)string);
        }
        Collection collection = variableUsages;
        String string = newNameInTestMode;
        Intrinsics.checkNotNull((Object)string);
        this.performRename(project, variableDeclaration, collection, string);
        return true;
    }

    private final void showRenameDialog(DataContext dataContext, Project project, VariableDeclarationInfo variableDeclaration, List<? extends UsageInfo> variableUsages) {
        PomTargetPsiElement resolvedPsiElement = variableDeclaration.getResolvedPsiElement();
        if (resolvedPsiElement == null) {
            Logger.getInstance(SwYamlPathVariableRenameHandler.class).error("Path variable reference resolved to null, can not perform rename. Variable declaration ranges: " + CollectionsKt.joinToString$default((Iterable)variableDeclaration.getReferencesRanges(), null, null, null, (int)0, null, null, (int)63, null) + ", declaration PsiElement type: " + variableDeclaration.getDeclarationPsiElement().getClass());
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        new RenameDialog(project, resolvedPsiElement, variableUsages, this, variableDeclaration, editor){
            final /* synthetic */ Project $project;
            final /* synthetic */ List<UsageInfo> $variableUsages;
            final /* synthetic */ SwYamlPathVariableRenameHandler this$0;
            final /* synthetic */ VariableDeclarationInfo $variableDeclaration;
            {
                this.$project = $project;
                this.$variableUsages = $variableUsages;
                this.this$0 = $receiver;
                this.$variableDeclaration = $variableDeclaration;
                super($project, (PsiElement)$resolvedPsiElement, null, $super_call_param$1);
            }

            protected void doAction() {
                this.invokeRefactoring(new BaseRefactoringProcessor(this.$project, this.$variableUsages, this.this$0, this.$variableDeclaration, this){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ List<UsageInfo> $variableUsages;
                    final /* synthetic */ SwYamlPathVariableRenameHandler this$0;
                    final /* synthetic */ VariableDeclarationInfo $variableDeclaration;
                    final /* synthetic */ showRenameDialog.1 this$1;
                    {
                        this.$project = $project;
                        this.$variableUsages = $variableUsages;
                        this.this$0 = $receiver;
                        this.$variableDeclaration = $variableDeclaration;
                        this.this$1 = $receiver2;
                        super($project);
                    }

                    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        PsiElement[] psiElementArray = new PsiElement[]{};
                        return (UsageViewDescriptor)new BaseUsageViewDescriptor(this.$variableUsages, psiElementArray){
                            final /* synthetic */ List<UsageInfo> $variableUsages;
                            {
                                this.$variableUsages = $variableUsages;
                                super($super_call_param$1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public PsiElement[] getElements() {
                                void $this$mapNotNullTo$iv$iv;
                                Iterable $this$mapNotNull$iv = this.$variableUsages;
                                boolean $i$f$mapNotNull = false;
                                Iterable iterable = $this$mapNotNull$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$mapNotNullTo = false;
                                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                boolean $i$f$forEach = false;
                                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                                while (iterator.hasNext()) {
                                    PsiElement it$iv$iv;
                                    T element$iv$iv$iv;
                                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                                    boolean bl = false;
                                    UsageInfo it = (UsageInfo)element$iv$iv;
                                    boolean bl2 = false;
                                    if (it.getElement() == null) continue;
                                    boolean bl3 = false;
                                    destination$iv$iv.add(it$iv$iv);
                                }
                                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                return thisCollection$iv.toArray(new PsiElement[0]);
                            }
                        };
                    }

                    protected UsageInfo[] findUsages() {
                        Collection $this$toTypedArray$iv = this.$variableUsages;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        return thisCollection$iv.toArray(new UsageInfo[0]);
                    }

                    protected void performRefactoring(UsageInfo[] usages) {
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        Collection collection = ArraysKt.asList((Object[])usages);
                        String string = this.this$1.getNewName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewName(...)");
                        SwYamlPathVariableRenameHandler.access$performRename(this.this$0, this.$project, this.$variableDeclaration, collection, string);
                    }

                    protected String getCommandName() {
                        return SwaggerBundle.message("command.refactoring.rename", new Object[0]);
                    }
                });
                this.close(0);
            }
        }.show();
    }

    private final void performRename(Project project, VariableDeclarationInfo declaration, Collection<? extends UsageInfo> usages, String newName) {
        PsiFile[] psiFileArray = new PsiFile[]{declaration.getDeclarationPsiElement().getContainingFile()};
        WriteCommandAction.runWriteCommandAction((Project)project, (String)SwaggerBundle.message("command.refactoring.rename", new Object[0]), null, () -> SwYamlPathVariableRenameHandler.performRename$lambda$0(project, usages, declaration, this, newName), (PsiFile[])psiFileArray);
    }

    private final void renameKeyOfKeyValue(YAMLKeyValue psiElement, List<? extends TextRange> rangesInElement, YAMLElementGenerator yamlElementGenerator, String newName) {
        PsiElement psiElement2 = psiElement.getKey();
        String string = psiElement2 != null ? psiElement2.getText() : null;
        if (string == null) {
            string = "";
        }
        String newKeyText = this.renameAllOccurrencesInText(newName, string, rangesInElement);
        String string2 = SwRefactoringUtilsKt.getIndent((PsiElement)psiElement.getValue());
        YAMLValue yAMLValue = psiElement.getValue();
        String string3 = yAMLValue != null ? yAMLValue.getText() : null;
        if (string3 == null) {
            string3 = "";
        }
        String newValueText = string2 + string3;
        YAMLKeyValue yAMLKeyValue = yamlElementGenerator.createYamlKeyValue(newKeyText, newValueText);
        Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"createYamlKeyValue(...)");
        YAMLKeyValue newPsiElement = yAMLKeyValue;
        psiElement.replace((PsiElement)newPsiElement);
    }

    private final void renameValueOfKeyValue(YAMLValue psiElement, List<? extends TextRange> rangesInElement, YAMLElementGenerator yamlElementGenerator, String newName) {
        String string = psiElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String newValueText = this.renameAllOccurrencesInText(newName, string, rangesInElement);
        YAMLValue yAMLValue = yamlElementGenerator.createYamlKeyValue("IfYouSeeThisMagicExists", newValueText).getValue();
        if (yAMLValue == null) {
            return;
        }
        YAMLValue newPsiElement = yAMLValue;
        psiElement.replace((PsiElement)newPsiElement);
    }

    private final String renameAllOccurrencesInText(String replacement, String originalText, List<? extends TextRange> occurrenceRanges) {
        StringBuilder stringBuilder;
        int preservedRegionOffset = 0;
        StringBuilder $this$renameAllOccurrencesInText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (TextRange textRange : occurrenceRanges) {
            String preservedPrefix;
            Intrinsics.checkNotNullExpressionValue((Object)originalText.substring(preservedRegionOffset, textRange.getStartOffset()), (String)"substring(...)");
            String[] stringArray = new String[]{preservedPrefix, replacement};
            StringsKt.append((StringBuilder)$this$renameAllOccurrencesInText_u24lambda_u240, (String[])stringArray);
            preservedRegionOffset += preservedPrefix.length() + textRange.getLength();
        }
        String string = originalText.substring(preservedRegionOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        $this$renameAllOccurrencesInText_u24lambda_u240.append(string);
        return stringBuilder.toString();
    }

    private static final Iterable findPathVariableUsages$lambda$0(SwHttpOperation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParameters();
    }

    private static final boolean findPathVariableUsages$lambda$1(String $variableName, SwParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getParameterName().getValue(), (Object)$variableName);
    }

    private static final PsiElement findPathVariableUsages$lambda$2(SwParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParameterName().getSourcePsi();
    }

    private static final boolean findPathVariableUsages$lambda$3(String $variableName, Openapi3Variable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName().getValue(), (Object)$variableName);
    }

    private static final PsiElement findPathVariableUsages$lambda$4(Openapi3Variable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName().getSourcePsi();
    }

    private static final UsageInfo findPathVariableUsages$lambda$5(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new UsageInfo(it, ElementManipulators.getValueTextRange((PsiElement)it), false);
    }

    private static final void performRename$lambda$0(Project $project, Collection $usages, VariableDeclarationInfo $declaration, SwYamlPathVariableRenameHandler this$0, String $newName) {
        YAMLElementGenerator yamlElementGenerator = YAMLElementGenerator.getInstance((Project)$project);
        Iterable $this$forEach$iv = $usages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UsageInfo it = (UsageInfo)element$iv;
            boolean bl = false;
            ProperTextRange rangeInElement = it.getRangeInElement();
            if (rangeInElement == null) {
                Logger.getInstance(SwYamlPathVariableRenameHandler.class).warn("Got empty reference range from usage reference");
                continue;
            }
            PsiElement usagePsiElement = it.getElement();
            if (usagePsiElement instanceof YAMLValue) {
                YAMLValue yAMLValue = (YAMLValue)usagePsiElement;
                List list = CollectionsKt.listOf((Object)rangeInElement);
                Intrinsics.checkNotNull((Object)yamlElementGenerator);
                this$0.renameValueOfKeyValue(yAMLValue, list, yamlElementGenerator, $newName);
                continue;
            }
            if (!(usagePsiElement instanceof YAMLKeyValue)) continue;
            YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)usagePsiElement;
            List list = CollectionsKt.listOf((Object)rangeInElement);
            Intrinsics.checkNotNull((Object)yamlElementGenerator);
            this$0.renameKeyOfKeyValue(yAMLKeyValue, list, yamlElementGenerator, $newName);
        }
        PsiElement originalPsiElement = $declaration.getDeclarationPsiElement();
        if (originalPsiElement instanceof YAMLKeyValue) {
            YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)originalPsiElement;
            List<TextRange> list = $declaration.getReferencesRanges();
            Intrinsics.checkNotNull((Object)yamlElementGenerator);
            this$0.renameKeyOfKeyValue(yAMLKeyValue, list, yamlElementGenerator, $newName);
        } else if (originalPsiElement instanceof YAMLValue) {
            YAMLValue yAMLValue = (YAMLValue)originalPsiElement;
            List<TextRange> list = $declaration.getReferencesRanges();
            Intrinsics.checkNotNull((Object)yamlElementGenerator);
            this$0.renameValueOfKeyValue(yAMLValue, list, yamlElementGenerator, $newName);
        }
    }

    public static final /* synthetic */ void access$performRename(SwYamlPathVariableRenameHandler $this, Project project, VariableDeclarationInfo declaration, Collection usages, String newName) {
        $this.performRename(project, declaration, usages, newName);
    }
}

