/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing.templates;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.swagger.core.visualEditing.SwGutterActionData;
import com.intellij.swagger.core.visualEditing.templates.SwLanguageAwareTemplateAdapter;
import com.intellij.swagger.core.visualEditing.templates.SwPreparedTemplate;
import com.intellij.swagger.core.visualEditing.templates.SwTemplateLanguageAdapterKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\"\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"insertNewSemanticNode", "", "actionData", "Lcom/intellij/swagger/core/visualEditing/SwGutterActionData;", "psiElement", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "findSelectedEditor", "Lcom/intellij/openapi/editor/Editor;", "psi", "addTemplateVariableMarkers", "", "templateText", "DOLLAR", "VARIABLE_NUMBER_GROUP", "VARIABLE_REGEX", "Lkotlin/text/Regex;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nswVisualEditingTemplates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 swVisualEditingTemplates.kt\ncom/intellij/swagger/core/visualEditing/templates/SwVisualEditingTemplatesKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,395:1\n67#2:396\n19#3:397\n*S KotlinDebug\n*F\n+ 1 swVisualEditingTemplates.kt\ncom/intellij/swagger/core/visualEditing/templates/SwVisualEditingTemplatesKt\n*L\n22#1:396\n36#1:397\n*E\n"})
public final class SwVisualEditingTemplatesKt {
    @NotNull
    private static final String DOLLAR = "$";
    @NotNull
    private static final String VARIABLE_NUMBER_GROUP = "number";
    @NotNull
    private static final Regex VARIABLE_REGEX = new Regex("VAR_(?<number>\\d+)");

    public static final void insertNewSemanticNode(@NotNull SwGutterActionData actionData, @NotNull PsiElement psiElement, @NotNull Project project) {
        SwPreparedTemplate withSelf$iv22;
        Editor editor;
        block6: {
            block5: {
                SwLanguageAwareTemplateAdapter<?, ?> $this$parentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
                Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Editor editor2 = SwVisualEditingTemplatesKt.findSelectedEditor(psiElement);
                if (editor2 == null) {
                    return;
                }
                editor = editor2;
                PsiElement psiElement2 = psiElement;
                boolean withSelf$iv22 = true;
                boolean $i$f$parentOfType = false;
                PsiNamedElement psiNamedElement = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiNamedElement.class, (boolean)false);
                if (psiNamedElement == null) {
                    return;
                }
                PsiNamedElement parentNamedElement = psiNamedElement;
                $this$parentOfType$iv = SwTemplateLanguageAdapterKt.createTargetLanguageTemplateAdapter((PsiElement)parentNamedElement);
                if ($this$parentOfType$iv == null) break block5;
                Project project2 = parentNamedElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                withSelf$iv22 = $this$parentOfType$iv.createLiveTemplateWithVariables(actionData, project2);
                if (withSelf$iv22 != null) break block6;
            }
            return;
        }
        SwPreparedTemplate swPreparedTemplate = withSelf$iv22;
        int caretOffset = swPreparedTemplate.component1();
        Template modelElementTemplate = swPreparedTemplate.component2();
        PsiFile[] psiFileArray = new PsiFile[]{psiElement.getContainingFile()};
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])psiFileArray).compute(() -> SwVisualEditingTemplatesKt.insertNewSemanticNode$lambda$0(editor, caretOffset, project, modelElementTemplate));
    }

    private static final Editor findSelectedEditor(PsiElement psi) {
        TextEditor textEditor;
        FileEditor $this$asSafely$iv = FileEditorManager.getInstance((Project)psi.getProject()).getSelectedEditor(psi.getContainingFile().getVirtualFile());
        boolean $i$f$asSafely = false;
        FileEditor fileEditor = $this$asSafely$iv;
        if (!(fileEditor instanceof TextEditor)) {
            fileEditor = null;
        }
        return (textEditor = (TextEditor)fileEditor) != null ? textEditor.getEditor() : null;
    }

    @NotNull
    public static final String addTemplateVariableMarkers(@NotNull String templateText) {
        Intrinsics.checkNotNullParameter((Object)templateText, (String)"templateText");
        return VARIABLE_REGEX.replace((CharSequence)templateText, SwVisualEditingTemplatesKt::addTemplateVariableMarkers$lambda$0);
    }

    private static final Unit insertNewSemanticNode$lambda$0(Editor $editor, int $caretOffset, Project $project, Template $modelElementTemplate) {
        $editor.getCaretModel().moveToOffset($caretOffset);
        TemplateManager.getInstance((Project)$project).startTemplate($editor, $modelElementTemplate, false, MapsKt.emptyMap(), null);
        return Unit.INSTANCE;
    }

    private static final CharSequence addTemplateVariableMarkers$lambda$0(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)VARIABLE_NUMBER_GROUP);
        if (object == null || (object = object.getValue()) == null) {
            return matchResult.getValue();
        }
        Object number = object;
        return "$VAR_" + (String)number + DOLLAR;
    }
}

