/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.mysqlbase.MysqlBaseDbms;
import com.intellij.database.util.Version;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlBaseUtils {
    @Contract(value="_,!null->!null")
    public static Version getMysqlMatchingVersion(@NotNull Dbms dbms, @Nullable Version version) {
        if (dbms == null) {
            MysqlBaseUtils.$$$reportNull$$$0(0);
        }
        if (dbms == Dbms.MYSQL_AURORA) {
            return MysqlBaseUtils.getMysqlVersionForAurora(version);
        }
        if (dbms == MysqlBaseDbms.TIDB) {
            return Version.of((int[])new int[]{5, 6});
        }
        return version;
    }

    @Nullable
    public static Version getMysqlVersionForAurora(@Nullable Version version) {
        if (version == null) {
            return null;
        }
        if (version.isOrGreater(new int[]{3})) {
            return Version.of((int[])new int[]{8, 0, 23});
        }
        if (version.isOrGreater(new int[]{2})) {
            return Version.of((int[])new int[]{5, 7});
        }
        return Version.of((int[])new int[]{5, 6});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/dialects/mysqlbase/MysqlBaseUtils", "getMysqlMatchingVersion"));
    }
}

