/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.generator.producers;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.ScriptingFun;
import com.intellij.database.dialects.mysqlbase.generator.producers.MysqlBasePartitionProducersKt;
import com.intellij.database.dialects.mysqlbase.generator.producers.MysqlBaseSubpartitionProducersKt;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseCollation;
import com.intellij.database.dialects.mysqlbase.model.MysqlBasePartition;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseSubpartition;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseTable;
import com.intellij.database.dialects.mysqlbase.model.properties.references.MysqlBaseBinaryCollationReference;
import com.intellij.database.dialects.mysqlbase.model.properties.references.MysqlBaseCharsetReference;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a \u0010\u0005\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a \u0010\b\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\t\u001a\u0004\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u001a$\u0010\f\u001a\u0004\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\u00022\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000eH\u0002\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000eH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a8\u0006\u0016"}, d2={"producePartitionMethods", "", "Lcom/intellij/database/dialects/base/generator/ElementProducer;", "table", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseTable;", "appendSubpartitionBy", "", "needNumber", "appendPartitionBy", "makeEngineSpec", "", "engine", "makeTableCollationSpec", "collationRef", "Lcom/intellij/database/model/properties/BasicReferenceInfo;", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseCollation;", "getCharset", "isMaria", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "getServerVersion", "Lcom/intellij/database/util/Version;", "intellij.database.dialects.mysqlbase"})
@SourceDebugExtension(value={"SMAP\nMysqlBaseTableProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlBaseTableProducers.kt\ncom/intellij/database/dialects/mysqlbase/generator/producers/MysqlBaseTableProducersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ElementProducer.kt\ncom/intellij/database/dialects/base/generator/BaseProducer\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,241:1\n1740#2,3:242\n1740#2,3:245\n1634#2,3:248\n1#3:251\n98#4:252\n98#4:253\n19#5:254\n*S KotlinDebug\n*F\n+ 1 MysqlBaseTableProducers.kt\ncom/intellij/database/dialects/mysqlbase/generator/producers/MysqlBaseTableProducersKt\n*L\n182#1:242,3\n183#1:245,3\n193#1:248,3\n210#1:252\n214#1:253\n227#1:254\n*E\n"})
public final class MysqlBaseTableProducersKt {
    private static final boolean producePartitionMethods(ElementProducer<?> $this$producePartitionMethods, MysqlBaseTable table) {
        boolean bl;
        boolean defaultPartitions;
        block12: {
            boolean bl2;
            block10: {
                ModPositioningNamingFamily<? extends MysqlBasePartition> modPositioningNamingFamily = table.getPartitions();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getPartitions(...)");
                Iterable $this$all$iv = (Iterable)modPositioningNamingFamily;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        MysqlBasePartition it = (MysqlBasePartition)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (MysqlBasePartitionProducersKt.isDefaultState(it)) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            defaultPartitions = bl2;
            ModPositioningNamingFamily<? extends MysqlBasePartition> modPositioningNamingFamily = table.getPartitions();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getPartitions(...)");
            Iterable $this$all$iv = (Iterable)modPositioningNamingFamily;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl4;
                    block11: {
                        MysqlBasePartition p = (MysqlBasePartition)element$iv;
                        boolean bl5 = false;
                        ModPositioningNamingFamily<? extends MysqlBaseSubpartition> modPositioningNamingFamily2 = p.getSubpartitions();
                        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily2, (String)"getSubpartitions(...)");
                        Iterable $this$all$iv2 = (Iterable)modPositioningNamingFamily2;
                        boolean $i$f$all2 = false;
                        if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                            bl4 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv2) {
                                MysqlBaseSubpartition it = (MysqlBaseSubpartition)element$iv2;
                                boolean bl6 = false;
                                Intrinsics.checkNotNull((Object)it);
                                if (MysqlBaseSubpartitionProducersKt.isDefaultState(it)) continue;
                                bl4 = false;
                                break block11;
                            }
                            bl4 = true;
                        }
                    }
                    if (bl4) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        boolean defaultSubpartitions = bl;
        boolean isDefault = defaultPartitions && defaultSubpartitions;
        MysqlBaseTableProducersKt.appendPartitionBy($this$producePartitionMethods, table, isDefault);
        if (table.getSubpartitionMethod() != null) {
            MysqlBaseTableProducersKt.appendSubpartitionBy($this$producePartitionMethods, table, defaultSubpartitions);
        }
        return isDefault;
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendSubpartitionBy(ElementProducer<?> $this$appendSubpartitionBy, MysqlBaseTable table, boolean needNumber) {
        int n;
        if (!needNumber) {
            n = 0;
        } else {
            void $this$mapTo$iv;
            ModPositioningNamingFamily<? extends MysqlBasePartition> modPositioningNamingFamily = table.getPartitions();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getPartitions(...)");
            Iterable iterable = (Iterable)modPositioningNamingFamily;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                MysqlBasePartition mysqlBasePartition = (MysqlBasePartition)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(it.getSubpartitions().size());
            }
            Integer n2 = (Integer)CollectionsKt.singleOrNull((Iterable)destination$iv);
            n = n2 != null ? n2 : 0;
        }
        int spnum = n;
        $this$appendSubpartitionBy.sqlClause(arg_0 -> MysqlBaseTableProducersKt.appendSubpartitionBy$lambda$1(table, spnum, arg_0));
    }

    private static final void appendPartitionBy(ElementProducer<?> $this$appendPartitionBy, MysqlBaseTable table, boolean needNumber) {
        int pnum = !needNumber || MysqlBasePartitionProducersKt.partitionRequiresCondition(table.getPartitionMethod()) ? 0 : table.getPartitions().size();
        $this$appendPartitionBy.sqlClause(arg_0 -> MysqlBaseTableProducersKt.appendPartitionBy$lambda$0(table, pnum, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final String makeEngineSpec(ElementProducer<?> $this$makeEngineSpec, String engine) {
        String string;
        String string2 = engine;
        if (string2 != null) {
            void this_$iv;
            String it = string2;
            boolean bl = false;
            BaseProducer baseProducer = (BaseProducer)$this$makeEngineSpec;
            String $this$scr$iv = it;
            boolean $i$f$getScr = false;
            string = "engine=" + this_$iv.getContext().getNamingService().catToScript($this$scr$iv, null, this_$iv.getStyle().getQuotesPriority(), ScriptingFun.getForceQuoting((ScriptingContext)this_$iv.getContext()));
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String makeTableCollationSpec(ElementProducer<?> $this$makeTableCollationSpec, BasicReferenceInfo<? extends MysqlBaseCollation> collationRef) {
        String string;
        String charSet = MysqlBaseTableProducersKt.getCharset(collationRef);
        if (charSet != null) {
            void this_$iv;
            BaseProducer baseProducer = (BaseProducer)$this$makeTableCollationSpec;
            String $this$scr$iv = charSet;
            boolean $i$f$getScr = false;
            string = "charset=" + this_$iv.getContext().getNamingService().catToScript($this$scr$iv, null, this_$iv.getStyle().getQuotesPriority(), ScriptingFun.getForceQuoting((ScriptingContext)this_$iv.getContext()));
        } else {
            BasicReferenceInfo<? extends MysqlBaseCollation> basicReferenceInfo = collationRef;
            string = basicReferenceInfo != null ? "collate=" + $this$makeTableCollationSpec.extractName(basicReferenceInfo) : null;
        }
        return string;
    }

    @Nullable
    public static final String getCharset(@Nullable BasicReferenceInfo<? extends MysqlBaseCollation> collationRef) {
        if (collationRef == null) {
            return null;
        }
        Object object = (MysqlBaseCollation)collationRef.getTarget();
        if (object != null) {
            MysqlBaseCollation mysqlBaseCollation;
            MysqlBaseCollation collation = object;
            boolean bl = false;
            MysqlBaseCollation it = mysqlBaseCollation = collation;
            boolean bl2 = false;
            MysqlBaseCollation mysqlBaseCollation2 = it.isDefaultForCharset() ? mysqlBaseCollation : null;
            return mysqlBaseCollation2 != null ? mysqlBaseCollation2.getCharset() : null;
        }
        BasicReference it = collationRef.getReference();
        boolean bl = false;
        BasicReference $this$asSafely$iv = it instanceof MysqlBaseBinaryCollationReference ? ((MysqlBaseBinaryCollationReference)it).ref : it;
        boolean $i$f$asSafely = false;
        BasicReference basicReference = $this$asSafely$iv;
        if (!(basicReference instanceof MysqlBaseCharsetReference)) {
            basicReference = null;
        }
        return (object = (MysqlBaseCharsetReference)basicReference) != null ? ((MysqlBaseCharsetReference)object).charsetName : null;
    }

    public static final boolean isMaria(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Intrinsics.areEqual((Object)ScriptingTaskKt.getDbms((ScriptingTask)context.getTask()), (Object)Dbms.MARIA);
    }

    @NotNull
    public static final Version getServerVersion(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getTask().getVersion();
    }

    private static final Unit appendSubpartitionBy$lambda$1(MysqlBaseTable $table, int $spnum, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
            $this$sqlClause.minus($this$sqlClause.minus($this$sqlClause.minus($this$sqlClause.plus($this$sqlClause.unaryPlus((CharSequence)"subpartition by"), (CharSequence)StringUtil.toLowerCase((String)$table.getSubpartitionMethod())), (CharSequence)"("), (CharSequence)$table.getSubpartitionExpression()), (CharSequence)")");
            Integer n = $spnum;
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it > 1 ? n : null;
            if (n2 == null) break block0;
            it = ((Number)n2).intValue();
            boolean bl2 = false;
            $this$sqlClause.unaryPlus((CharSequence)("subpartitions " + it));
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendPartitionBy$lambda$0(MysqlBaseTable $table, int $pnum, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
            $this$sqlClause.minus($this$sqlClause.minus($this$sqlClause.minus($this$sqlClause.plus($this$sqlClause.unaryPlus((CharSequence)"partition by"), (CharSequence)StringUtil.toLowerCase((String)$table.getPartitionMethod())), (CharSequence)"("), (CharSequence)$table.getPartitionExpression()), (CharSequence)")");
            Integer n = $pnum;
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it > 1 ? n : null;
            if (n2 == null) break block0;
            it = ((Number)n2).intValue();
            boolean bl2 = false;
            $this$sqlClause.unaryPlus((CharSequence)("partitions " + it));
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$producePartitionMethods(ElementProducer $receiver, MysqlBaseTable table) {
        return MysqlBaseTableProducersKt.producePartitionMethods($receiver, table);
    }

    public static final /* synthetic */ String access$makeTableCollationSpec(ElementProducer $receiver, BasicReferenceInfo collationRef) {
        return MysqlBaseTableProducersKt.makeTableCollationSpec($receiver, (BasicReferenceInfo<? extends MysqlBaseCollation>)collationRef);
    }

    public static final /* synthetic */ String access$makeEngineSpec(ElementProducer $receiver, String engine) {
        return MysqlBaseTableProducersKt.makeEngineSpec($receiver, engine);
    }
}

