/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.structuralsearch.predicates;

import com.intellij.database.model.DasTypeAwareObject;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$J(\u0010\u000e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate;", "Lcom/intellij/structuralsearch/impl/matcher/predicates/MatchPredicate;", "isCaseSensitive", "", "<init>", "(Z)V", "()Z", "matchType", "dasType", "Lcom/intellij/database/types/DasType;", "matchedNode", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/structuralsearch/impl/matcher/MatchContext;", "match", "start", "", "end", "ByTypeList", "ByTypeRegex", "Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate$ByTypeList;", "Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate$ByTypeRegex;", "intellij.database.sql.impl"})
public abstract sealed class SqlExpressionTypePredicate
extends MatchPredicate {
    private final boolean isCaseSensitive;

    private SqlExpressionTypePredicate(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    protected final boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    protected abstract boolean matchType(@NotNull DasType var1, @NotNull PsiElement var2, @NotNull MatchContext var3);

    public boolean match(@NotNull PsiElement matchedNode, int start, int end, @NotNull MatchContext context) {
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DasTypeAwareObject dasTypeAwareObject = matchedNode instanceof DasTypeAwareObject ? (DasTypeAwareObject)matchedNode : null;
        if (dasTypeAwareObject == null || (dasTypeAwareObject = dasTypeAwareObject.getDasType()) == null) {
            return false;
        }
        DasTypeAwareObject dasType = dasTypeAwareObject;
        return this.matchType((DasType)dasType, matchedNode, context);
    }

    public /* synthetic */ SqlExpressionTypePredicate(boolean isCaseSensitive, DefaultConstructorMarker $constructor_marker) {
        this(isCaseSensitive);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate$ByTypeList;", "Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate;", "typePattern", "", "isCaseSensitive", "", "<init>", "(Ljava/lang/String;Z)V", "types", "Ljava/util/ArrayList;", "categories", "Ljava/util/HashSet;", "Lcom/intellij/database/types/DasTypeCategory;", "matchType", "dasType", "Lcom/intellij/database/types/DasType;", "matchedNode", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/structuralsearch/impl/matcher/MatchContext;", "intellij.database.sql.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlExpressionTypePredicate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlExpressionTypePredicate.kt\ncom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate$ByTypeList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1761#2,3:68\n*S KotlinDebug\n*F\n+ 1 SqlExpressionTypePredicate.kt\ncom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate$ByTypeList\n*L\n43#1:68,3\n*E\n"})
    public static final class ByTypeList
    extends SqlExpressionTypePredicate {
        @NotNull
        private final ArrayList<String> types;
        @NotNull
        private final HashSet<DasTypeCategory> categories;

        public ByTypeList(@NotNull String typePattern, boolean isCaseSensitive) {
            Intrinsics.checkNotNullParameter((Object)typePattern, (String)"typePattern");
            super(isCaseSensitive, null);
            this.types = new ArrayList();
            this.categories = new HashSet();
            for (String item : StringUtil.split((String)typePattern, (String)"|")) {
                Intrinsics.checkNotNull((Object)item);
                String typeText = ((Object)StringsKt.trim((CharSequence)item)).toString();
                if (StringsKt.startsWith$default((String)typeText, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)typeText, (String)"]", (boolean)false, (int)2, null)) {
                    Object object;
                    Collection collection = this.categories;
                    try {
                        String string = typeText.substring(1, StringsKt.getLastIndex((CharSequence)typeText));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        object = string;
                        Locale locale = Locale.ENGLISH;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                        String string2 = ((String)object).toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                        object = DasTypeCategory.valueOf((String)string2);
                    }
                    catch (Exception e) {
                        object = DasTypeCategory.UNKNOWN;
                    }
                    collection.add(object);
                    continue;
                }
                ((Collection)this.types).add(typeText);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean matchType(@NotNull DasType dasType, @NotNull PsiElement matchedNode, @NotNull MatchContext context) {
            String it;
            Intrinsics.checkNotNullParameter((Object)dasType, (String)"dasType");
            Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (CollectionsKt.contains((Iterable)this.categories, (Object)DasTypeUtilsKt.getCategory((DasType)dasType))) return true;
            Iterable $this$any$iv = this.types;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl = false;
            } while (!StringsKt.equals((String)dasType.getDescription(), (String)it, (!this.isCaseSensitive() ? 1 : 0) != 0));
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate$ByTypeRegex;", "Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate;", "typePattern", "", "name", "isTarget", "", "isCaseSensitive", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZZ)V", "regexPredicate", "Lcom/intellij/structuralsearch/impl/matcher/predicates/RegExpPredicate;", "matchType", "dasType", "Lcom/intellij/database/types/DasType;", "matchedNode", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/structuralsearch/impl/matcher/MatchContext;", "intellij.database.sql.impl"})
    public static final class ByTypeRegex
    extends SqlExpressionTypePredicate {
        @NotNull
        private final RegExpPredicate regexPredicate;

        public ByTypeRegex(@NotNull String typePattern, @NotNull String name, boolean isTarget, boolean isCaseSensitive) {
            Intrinsics.checkNotNullParameter((Object)typePattern, (String)"typePattern");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(isCaseSensitive, null);
            this.regexPredicate = new RegExpPredicate(typePattern, isCaseSensitive, name, false, isTarget);
        }

        @Override
        protected boolean matchType(@NotNull DasType dasType, @NotNull PsiElement matchedNode, @NotNull MatchContext context) {
            Intrinsics.checkNotNullParameter((Object)dasType, (String)"dasType");
            Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.regexPredicate.doMatch(dasType.getDescription(), context, matchedNode) || this.regexPredicate.doMatch("[" + DasTypeUtilsKt.getCategory((DasType)dasType) + "]", context, matchedNode);
        }
    }
}

