/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.server.DisposablePositionManager;
import com.intellij.javaee.web.deployment.JspDeploymentManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatBundle;

public class Tomcat40PositionManager
implements DisposablePositionManager {
    private static final Logger LOG = Logger.getInstance(Tomcat40PositionManager.class);
    private static final Set<FileType> ourFileTypes = Set.of(StdFileTypes.JSP, StdFileTypes.JSPX);
    @NonNls
    private static final String PATTERN_TEXT = "\\/\\/\\s*begin\\s+\\[file=\"(.*?)\";from=\\((\\d+),(\\d+)\\);to=\\((\\d+),(\\d+)\\)\\][\\n\\r]*(.*?)[\\n\\r]*\\s*\\/\\/\\s*end";
    private static final int JSP_SOURCE_GROUP = 1;
    private static final int FROM_LINE_GROUP = 2;
    private static final int FROM_COLUMN_GROUP = 3;
    private static final int TO_LINE_GROUP = 4;
    private static final int TO_COLUMN_GROUP = 5;
    private static final int CODE_GROUP = 6;
    private final DebugProcess myDebugProcess;
    private final Pattern myPattern;
    private final String myGeneratedFilesPath;
    private final Map<ServletPosition, JspPosition> myServletToJspPositionMap;
    private final Map<JspPosition, ServletPosition> myJspToServletPositionMap;
    private VirtualFile myGeneratedFilesDirectory;
    private VirtualFileListener myFileListener;
    private final JspDeploymentManager myJavaClassHelper;
    @NonNls
    private static final String APACHE_PACKAGE = "org.apache.jsp";
    private final Map<VirtualFile, Long> myServletTimeStamps;
    private final Map<VirtualFile, PsiFile> myServletToPsiFile;
    @NonNls
    protected static final String JSP_SUFFIX = "$jsp";
    private final JavaeeFacet[] myScope;
    private LocalFileSystem.WatchRequest myGeneratedPathsWatchRequest;

    public Tomcat40PositionManager(DebugProcess debugProcess, @NotNull String generatedFilePath, JavaeeFacet[] scopeFacets) {
        if (generatedFilePath == null) {
            Tomcat40PositionManager.$$$reportNull$$$0(0);
        }
        this.myServletToJspPositionMap = new HashMap<ServletPosition, JspPosition>();
        this.myJspToServletPositionMap = new HashMap<JspPosition, ServletPosition>();
        this.myServletTimeStamps = new HashMap<VirtualFile, Long>();
        this.myServletToPsiFile = new HashMap<VirtualFile, PsiFile>();
        this.myScope = scopeFacets;
        this.myDebugProcess = debugProcess;
        this.myGeneratedFilesPath = generatedFilePath;
        this.myPattern = Pattern.compile(PATTERN_TEXT, 34);
        this.myJavaClassHelper = JspDeploymentManager.getInstance();
        this.runWriteAction(() -> {
            LocalFileSystem fs = LocalFileSystem.getInstance();
            this.myGeneratedFilesDirectory = fs.refreshAndFindFileByPath(this.myGeneratedFilesPath);
        });
        if (this.myGeneratedFilesDirectory == null) {
            debugProcess.printToConsole(TomcatBundle.message("message.text.cannot.handle.breakpoint.path.not.found", this.myGeneratedFilesPath));
        }
        this.invoke(() -> {
            if (this.myGeneratedFilesDirectory != null) {
                FileTypeManager typeManager = FileTypeManager.getInstance();
                this.processDirectory(this.myGeneratedFilesDirectory, typeManager);
                this.myFileListener = new UpdateListener();
                VirtualFileManager.getInstance().addVirtualFileListener(this.myFileListener);
                this.myGeneratedPathsWatchRequest = LocalFileSystem.getInstance().addRootToWatch(this.myGeneratedFilesDirectory.getPath(), true);
            }
        });
        this.refreshGeneratedFilesDirectory();
    }

    private void refreshGeneratedFilesDirectory() {
        this.runWriteAction(() -> {
            if (this.myGeneratedFilesDirectory != null) {
                this.myGeneratedFilesDirectory.refresh(false, true);
            }
        });
    }

    private void runWriteAction(Runnable r) {
        this.invoke(() -> ApplicationManager.getApplication().runWriteAction(r));
    }

    private void invoke(Runnable runnable) {
        try {
            ApplicationManager.getApplication().invokeAndWait(runnable, ModalityState.nonModal());
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    private void processDirectory(VirtualFile dir, FileTypeManager typeManager) {
        VirtualFile[] children;
        for (VirtualFile child : children = dir.getChildren()) {
            if (child.isDirectory()) {
                this.processDirectory(child, typeManager);
                continue;
            }
            if (!FileTypeRegistry.getInstance().isFileOfType(child, (FileType)StdFileTypes.JAVA) || !child.getNameWithoutExtension().endsWith(JSP_SUFFIX)) continue;
            this.parseGeneratedServlet(child);
        }
    }

    private static boolean isModified(Map servletTimeStamps, VirtualFile file) {
        Long ts = (Long)servletTimeStamps.get(file);
        return ts.longValue() != file.getTimeStamp();
    }

    private PsiFile getPsiFile(VirtualFile servletFile) {
        if (!servletFile.isValid()) {
            this.myServletTimeStamps.remove(servletFile);
            this.myServletToPsiFile.remove(servletFile);
            return null;
        }
        if (this.myServletTimeStamps.containsKey(servletFile) && !Tomcat40PositionManager.isModified(this.myServletTimeStamps, servletFile)) {
            return this.myServletToPsiFile.get(servletFile);
        }
        if (FileDocumentManager.getInstance().getDocument(servletFile) != null) {
            String servletText = FileDocumentManager.getInstance().getDocument(servletFile).getText();
            PsiFile servletPsiFile = PsiFileFactory.getInstance((Project)this.myDebugProcess.getProject()).createFileFromText(servletFile.getName(), servletText);
            this.myServletToPsiFile.put(servletFile, servletPsiFile);
            this.myServletTimeStamps.put(servletFile, servletFile.getTimeStamp());
            return servletPsiFile;
        }
        this.myDebugProcess.printToConsole(TomcatBundle.message("message.text.cannot.read.from.file.with.exception", servletFile.getPath(), ""));
        return null;
    }

    private String findClassQualifiedName(VirtualFile file, int startOffset, int endOffset) {
        return (String)ReadAction.compute(() -> {
            TextRange range;
            PsiElement element;
            PsiFile psiFile = this.getPsiFile(file);
            if (psiFile == null) {
                return null;
            }
            for (element = psiFile.findElementAt(startOffset); !(element instanceof PsiClass || element == null || element instanceof PsiComment && (range = element.getTextRange()).containsRange(startOffset, endOffset)); element = element.getParent()) {
            }
            if (!(element instanceof PsiClass)) {
                return null;
            }
            return ((PsiClass)element).getQualifiedName();
        });
    }

    private void parseGeneratedServlet(VirtualFile servletFile) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Project project = this.myDebugProcess.getProject();
            if (project.isDisposed()) {
                this.dispose();
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(servletFile);
            if (psiFile == null) {
                return;
            }
            String servletText = psiFile.getText();
            Document document = EditorFactory.getInstance().createDocument((CharSequence)servletText);
            Matcher matcher = this.myPattern.matcher(servletText);
            while (matcher.find()) {
                String jspFilePath = FileUtil.toCanonicalPath((String)matcher.group(1));
                int startServletLine = document.getLineNumber(servletText.indexOf(matcher.group(6), matcher.start())) + 1;
                int startJspLine = Integer.parseInt(matcher.group(2)) + 1;
                int endJspLine = Integer.parseInt(matcher.group(4)) + 1;
                if (startServletLine + (endJspLine - startJspLine) >= document.getLineCount()) {
                    endJspLine = startJspLine + (document.getLineCount() - startServletLine - 1);
                }
                int jspLine = startJspLine;
                int servletLine = startServletLine;
                while (jspLine <= endJspLine) {
                    JspPosition jspPosition = new JspPosition(jspFilePath, jspLine);
                    String classQualifiedName = this.findClassQualifiedName(servletFile, document.getLineStartOffset(servletLine), document.getLineEndOffset(servletLine));
                    if (classQualifiedName != null) {
                        ServletPosition servletPosition = new ServletPosition(servletFile, classQualifiedName, servletLine);
                        this.putMapping(servletPosition, jspPosition);
                    }
                    ++jspLine;
                    ++servletLine;
                }
            }
        });
    }

    public void dispose() {
        if (this.myGeneratedPathsWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(this.myGeneratedPathsWatchRequest);
            this.myGeneratedPathsWatchRequest = null;
        }
        if (this.myFileListener != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener(this.myFileListener);
            this.myFileListener = null;
        }
    }

    private void putMapping(ServletPosition servletPosition, JspPosition javaPosition) {
        this.myServletToJspPositionMap.put(servletPosition, javaPosition);
        this.myJspToServletPositionMap.put(javaPosition, servletPosition);
    }

    private JspPosition findJspPosition(ServletPosition servletPosition) {
        return this.myServletToJspPositionMap.get(servletPosition);
    }

    private ServletPosition findServletPosition(JspPosition jspPosition) {
        return this.myJspToServletPositionMap.get(jspPosition);
    }

    private void clearMappings(VirtualFile servletFile) {
        Set<ServletPosition> servletPositions = this.myServletToJspPositionMap.keySet();
        for (ServletPosition servletPosition : servletPositions) {
            if (!servletPosition.getFile().equals(servletFile)) continue;
            JspPosition jspPosition = this.myServletToJspPositionMap.remove(servletPosition);
            this.myJspToServletPositionMap.remove(jspPosition);
        }
    }

    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        PsiFile jspSource;
        SourcePosition sourcePosition = null;
        if (this.myGeneratedFilesDirectory == null) {
            return null;
        }
        JspPosition jspPosition = this.findJspPosition(new ServletPosition(location.declaringType().name(), location.lineNumber()));
        if (jspPosition != null && (jspSource = this.myJavaClassHelper.getDeployedJspSource(jspPosition.getFileName(), this.myDebugProcess.getProject(), this.myScope)) != null) {
            sourcePosition = SourcePosition.createFromLine((PsiFile)jspSource, (int)(jspPosition.getLine() - 1));
        }
        if (sourcePosition == null) {
            throw NoDataException.INSTANCE;
        }
        return sourcePosition;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) throws NoDataException {
        FileType fileType;
        if (classPosition == null) {
            Tomcat40PositionManager.$$$reportNull$$$0(1);
        }
        if ((fileType = classPosition.getFile().getFileType()) != StdFileTypes.JSP && fileType != StdFileTypes.JSPX) {
            throw NoDataException.INSTANCE;
        }
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>();
        List allClasses = this.myDebugProcess.getVirtualMachineProxy().allClasses();
        for (ReferenceType referenceType : allClasses) {
            if (!referenceType.name().startsWith(APACHE_PACKAGE) || this.locationsOfLine(referenceType, classPosition).isEmpty()) continue;
            result.add(referenceType);
        }
        ArrayList<ReferenceType> arrayList = result;
        if (arrayList == null) {
            Tomcat40PositionManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        FileType fileType;
        if (type == null) {
            Tomcat40PositionManager.$$$reportNull$$$0(3);
        }
        if (position == null) {
            Tomcat40PositionManager.$$$reportNull$$$0(4);
        }
        if ((fileType = position.getFile().getFileType()) != StdFileTypes.JSP && fileType != StdFileTypes.JSPX) {
            throw NoDataException.INSTANCE;
        }
        String deployedJspName = (String)ReadAction.compute(() -> this.myJavaClassHelper.getSourceJspDeployment(position.getFile()));
        JspPosition jspPosition = new JspPosition(deployedJspName, position.getLine() + 1);
        ServletPosition servletPosition = this.findServletPosition(jspPosition);
        if (servletPosition != null) {
            List<Location> list;
            try {
                list = type.locationsOfLine(servletPosition.getLine());
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
            if (list == null) {
                Tomcat40PositionManager.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            Tomcat40PositionManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    public ClassPrepareRequest createPrepareRequest(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        FileType fileType;
        if (requestor == null) {
            Tomcat40PositionManager.$$$reportNull$$$0(7);
        }
        if (position == null) {
            Tomcat40PositionManager.$$$reportNull$$$0(8);
        }
        if ((fileType = position.getFile().getFileType()) != StdFileTypes.JSP && fileType != StdFileTypes.JSPX) {
            throw NoDataException.INSTANCE;
        }
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(new ClassPrepareRequestor(){

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                Tomcat40PositionManager.this.refreshGeneratedFilesDirectory();
                try {
                    if (!Tomcat40PositionManager.this.locationsOfLine(referenceType, position).isEmpty()) {
                        requestor.processClassPrepare(debuggerProcess, referenceType);
                    }
                }
                catch (NoDataException noDataException) {
                    // empty catch block
                }
            }
        }, "org.apache.jsp.*");
    }

    @NotNull
    public Set<? extends FileType> getAcceptedFileTypes() {
        Set<FileType> set = ourFileTypes;
        if (set == null) {
            Tomcat40PositionManager.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedFilePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPosition";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/tomcat/Tomcat40PositionManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/tomcat/Tomcat40PositionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 9 -> new IllegalStateException(string);
        };
    }

    private static class JspPosition {
        private final String myFileName;
        private final int myLine;

        JspPosition(String fileName, int line) {
            this.myFileName = fileName;
            this.myLine = line;
        }

        public String getFileName() {
            return this.myFileName;
        }

        public int getLine() {
            return this.myLine;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JspPosition)) {
                return false;
            }
            JspPosition javaPosition = (JspPosition)o;
            if (this.myLine != javaPosition.myLine) {
                return false;
            }
            return !(this.myFileName != null ? !this.myFileName.equals(javaPosition.myFileName) : javaPosition.myFileName != null);
        }

        public int hashCode() {
            int result = this.myFileName != null ? this.myFileName.hashCode() : 0;
            result = 29 * result + this.myLine;
            return result;
        }
    }

    private static class ServletPosition {
        private final VirtualFile myFile;
        private final String myClassName;
        private final int myLine;

        ServletPosition(String className, int line) {
            this.myFile = null;
            this.myClassName = className;
            this.myLine = line;
        }

        ServletPosition(@NotNull VirtualFile file, String className, int line) {
            if (file == null) {
                ServletPosition.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            this.myClassName = className;
            this.myLine = line;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public String getMyClassName() {
            return this.myClassName;
        }

        public int getLine() {
            return this.myLine;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ServletPosition)) {
                return false;
            }
            ServletPosition servletPosition = (ServletPosition)o;
            if (this.myLine != servletPosition.myLine) {
                return false;
            }
            return this.myClassName.equals(servletPosition.myClassName);
        }

        public int hashCode() {
            int result = this.myClassName.hashCode();
            result = 29 * result + this.myLine;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/tomcat/Tomcat40PositionManager$ServletPosition", "<init>"));
        }
    }

    private class UpdateListener
    implements VirtualFileListener {
        private final FileTypeManager myTypeManager = FileTypeManager.getInstance();

        UpdateListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            VirtualFile file;
            if (event == null) {
                UpdateListener.$$$reportNull$$$0(0);
            }
            if (this.isGenerated(file = event.getFile())) {
                if (file.isDirectory()) {
                    this.checkCreatedDir(file);
                } else if (this.isGeneratedServlet(file)) {
                    Tomcat40PositionManager.this.parseGeneratedServlet(file);
                }
            }
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            VirtualFile file;
            if (event == null) {
                UpdateListener.$$$reportNull$$$0(1);
            }
            if (this.isGenerated(file = event.getFile()) && this.isGeneratedServlet(file)) {
                Tomcat40PositionManager.this.clearMappings(file);
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            VirtualFile file;
            if (event == null) {
                UpdateListener.$$$reportNull$$$0(2);
            }
            if (this.isGenerated(file = event.getFile()) && this.isGeneratedServlet(file)) {
                Tomcat40PositionManager.this.parseGeneratedServlet(file);
            }
        }

        private void checkCreatedDir(VirtualFile dir) {
            VirtualFile[] children;
            for (VirtualFile child : children = dir.getChildren()) {
                if (child.isDirectory()) {
                    this.checkCreatedDir(child);
                    continue;
                }
                if (!this.isGeneratedServlet(child)) continue;
                Tomcat40PositionManager.this.parseGeneratedServlet(child);
            }
        }

        private boolean isGenerated(VirtualFile file) {
            return VfsUtilCore.isAncestor((VirtualFile)Tomcat40PositionManager.this.myGeneratedFilesDirectory, (VirtualFile)file, (boolean)true);
        }

        private boolean isGeneratedServlet(VirtualFile file) {
            if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)StdFileTypes.JAVA)) {
                return false;
            }
            return file.getName().contains(Tomcat40PositionManager.JSP_SUFFIX);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/jetbrains/idea/tomcat/Tomcat40PositionManager$UpdateListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

