/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceSerialization;
import com.intellij.database.util.common.StringFun;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0000\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001\u001a(\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0018j\b\u0012\u0004\u0012\u00020\r`\u00192\u0006\u0010\u0016\u001a\u00020\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u001aF\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\r\u0018\u00010\u0018j\n\u0012\u0004\u0012\u00020\r\u0018\u0001`\u00192\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u001a\u001a\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u001a\u001a\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u001a\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"DATA_SOURCE_SETTINGS_HEADER", "", "DATA_SOURCE_SETTINGS_BEGIN", "DATA_SOURCE_SETTINGS_END", "DATA_SOURCE_RAW_SETTINGS_BEGIN", "DATA_SOURCE_RAW_SETTINGS_END", "DATA_SOURCE_RAW_SETTINGS_BEGIN2", "Lkotlin/text/Regex;", "DATA_SOURCE_RAW_SETTINGS_BEGIN2_P", "DATA_SOURCE_RAW_SETTINGS_END2", "exportDataSourcesSettings", "dss", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "exportSettings", "", "ds", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isDataSourceSettings", "", "text", "importDataSourceFromText", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "project", "Lcom/intellij/openapi/project/Project;", "importDataSourcesBy", "prefix", "suffix", "include", "createDataSourceFromSettings", "buffer", "addSuffixIfNeeded", "originalName", "getDataSourceNames", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceExportImportHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceExportImportHelper.kt\ncom/intellij/database/dataSource/DataSourceExportImportHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1563#2:89\n1634#2,3:90\n*S KotlinDebug\n*F\n+ 1 DataSourceExportImportHelper.kt\ncom/intellij/database/dataSource/DataSourceExportImportHelperKt\n*L\n87#1:89\n87#1:90,3\n*E\n"})
public final class DataSourceExportImportHelperKt {
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_HEADER = "#DataSourceSettings#";
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_BEGIN = "#BEGIN#";
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_END = "#END#";
    @NotNull
    public static final String DATA_SOURCE_RAW_SETTINGS_BEGIN = "<data-source source=\"LOCAL\" ";
    @NotNull
    public static final String DATA_SOURCE_RAW_SETTINGS_END = "</data-source>";
    @NotNull
    private static final Regex DATA_SOURCE_RAW_SETTINGS_BEGIN2 = new Regex("^<\\?xml\\s+.{1,60}\\?>\\s*<dataSource\\s+name");
    @NotNull
    private static final String DATA_SOURCE_RAW_SETTINGS_BEGIN2_P = "<dataSource";
    @NotNull
    private static final String DATA_SOURCE_RAW_SETTINGS_END2 = "</dataSource>";

    @Nullable
    public static final String exportDataSourcesSettings(@NotNull Collection<? extends LocalDataSource> dss) {
        Intrinsics.checkNotNullParameter(dss, (String)"dss");
        StringBuilder b = new StringBuilder(1024);
        b.append(DATA_SOURCE_SETTINGS_HEADER).append('\n');
        for (LocalDataSource localDataSource : dss) {
            DataSourceExportImportHelperKt.exportSettings(localDataSource, b);
        }
        if (((CharSequence)b).length() == 0) {
            return null;
        }
        return b.toString();
    }

    public static final void exportSettings(@NotNull LocalDataSource ds, @NotNull StringBuilder b) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        b.append("#LocalDataSource: ").append(ds.getName()).append('\n');
        StringBuffer text2 = LocalDataSourceSerialization.INSTANCE.serializedSettings(null, ds);
        b.append(DATA_SOURCE_SETTINGS_BEGIN).append('\n');
        b.append(text2);
        if (b.charAt(b.length() - 1) != '\n') {
            b.append('\n');
        }
        b.append(DATA_SOURCE_SETTINGS_END).append('\n').append('\n');
    }

    public static final boolean isDataSourceSettings(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return StringsKt.startsWith$default((String)text2, (String)DATA_SOURCE_SETTINGS_HEADER, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text2, (String)DATA_SOURCE_RAW_SETTINGS_BEGIN, (boolean)false, (int)2, null) || StringFun.startsWith((CharSequence)text2, (Regex)DATA_SOURCE_RAW_SETTINGS_BEGIN2);
    }

    @NotNull
    public static final ArrayList<LocalDataSource> importDataSourceFromText(@NotNull String text2, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        ArrayList arrayList = DataSourceExportImportHelperKt.importDataSourcesBy(DATA_SOURCE_SETTINGS_BEGIN, DATA_SOURCE_SETTINGS_END, false, text2, project);
        if (arrayList == null && (arrayList = DataSourceExportImportHelperKt.importDataSourcesBy(DATA_SOURCE_RAW_SETTINGS_BEGIN, DATA_SOURCE_RAW_SETTINGS_END, true, text2, project)) == null && (arrayList = DataSourceExportImportHelperKt.importDataSourcesBy(DATA_SOURCE_RAW_SETTINGS_BEGIN2_P, DATA_SOURCE_RAW_SETTINGS_END2, true, text2, project)) == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    private static final ArrayList<LocalDataSource> importDataSourcesBy(String prefix, String suffix, boolean include, String text2, Project project) {
        int q1;
        int p2;
        int p1 = StringsKt.indexOf$default((CharSequence)text2, (String)prefix, (int)0, (boolean)false, (int)6, null);
        if (p1 == -1) {
            return null;
        }
        ArrayList<LocalDataSource> dataSources = new ArrayList<LocalDataSource>();
        while (p1 >= 0 && (p2 = StringsKt.indexOf$default((CharSequence)text2, (String)suffix, (int)(q1 = p1 + (include ? 0 : prefix.length())), (boolean)false, (int)4, null)) >= 0) {
            int q2 = p2 + (include ? suffix.length() : 0);
            Collection collection = dataSources;
            String string = text2.substring(q1, q2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(DataSourceExportImportHelperKt.createDataSourceFromSettings(string, project));
            p1 = StringsKt.indexOf$default((CharSequence)text2, (String)prefix, (int)(p2 + suffix.length()), (boolean)false, (int)4, null);
        }
        return dataSources;
    }

    private static final LocalDataSource createDataSourceFromSettings(String buffer, Project project) {
        LocalDataSource localDataSource;
        LocalDataSource $this$createDataSourceFromSettings_u24lambda_u240 = localDataSource = LocalDataSourceSerialization.INSTANCE.createDataSourceFromSettings(project, buffer, false);
        boolean bl = false;
        $this$createDataSourceFromSettings_u24lambda_u240.resolveDriver();
        if ($this$createDataSourceFromSettings_u24lambda_u240.getDatabaseDriver() == null) {
            $this$createDataSourceFromSettings_u24lambda_u240.ensureDriverConfigured();
        }
        $this$createDataSourceFromSettings_u24lambda_u240.setGlobal(project == null);
        String string = $this$createDataSourceFromSettings_u24lambda_u240.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        $this$createDataSourceFromSettings_u24lambda_u240.setName(DataSourceExportImportHelperKt.addSuffixIfNeeded(string, project));
        return localDataSource;
    }

    private static final String addSuffixIfNeeded(String originalName, Project project) {
        Collection<String> existentNames = DataSourceExportImportHelperKt.getDataSourceNames(project);
        Object name = originalName;
        int k = 1;
        while (existentNames.contains(name)) {
            name = originalName + " [" + ++k + "]";
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<String> getDataSourceNames(Project project) {
        void $this$mapTo$iv$iv;
        List<LocalDataSource> list = DataSourceStorage.getStorage(project).getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalDataSource localDataSource = (LocalDataSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }
}

