/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.layoutedQueries;

import com.intellij.database.layoutedQueries.DBCommandRunner;
import com.intellij.database.layoutedQueries.DBQueryRunner;
import com.intellij.database.layoutedQueries.DBScriptRunner;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.remote.jdba.sql.SqlCommand;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdba.sql.SqlScript;
import com.intellij.database.remote.jdba.sql.SqlStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BaseScriptRunner
implements DBScriptRunner {
    @NotNull
    private final DBTransaction myTransaction;
    @NotNull
    private final SqlScript myScript;

    BaseScriptRunner(@NotNull DBTransaction transaction, @NotNull SqlScript script) {
        if (transaction == null) {
            BaseScriptRunner.$$$reportNull$$$0(0);
        }
        if (script == null) {
            BaseScriptRunner.$$$reportNull$$$0(1);
        }
        this.myTransaction = transaction;
        this.myScript = script;
    }

    @Override
    public DBScriptRunner run() {
        List statements = this.myScript.getStatements();
        for (SqlStatement statement : statements) {
            if (statement instanceof SqlCommand) {
                this.runCommand((SqlCommand)statement);
            }
            if (!(statement instanceof SqlQuery)) continue;
            this.runQuery((SqlQuery)statement);
        }
        return this;
    }

    private void runCommand(SqlCommand command) {
        try (DBCommandRunner runner = this.myTransaction.command(command);){
            runner.run();
        }
    }

    private void runQuery(SqlQuery<?> query) {
        try (DBQueryRunner<?> runner = this.myTransaction.query(query);){
            runner.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "transaction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "script";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/layoutedQueries/BaseScriptRunner";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

