/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.HSet;
import com.intellij.database.dataSource.ConfigUrlBean;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.RunnableWithDebounce;
import com.intellij.ide.PlatformIdeService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.SafeFileOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.xmlpull.v1.XmlPullParser;

@Service
public final class ModelExternalData {
    private static final Logger LOG = Logger.getInstance(ModelExternalData.class);
    private static final ExtensionPointName<ConfigUrlBean> CONFIG_EP = ExtensionPointName.create((String)"com.intellij.database.modelExternalData");
    private static final String EXTERNAL_DATA_PATH = "EXTERNAL_DATA_PATH";
    private volatile MultiMap<Dbms, Data> myDataByDbms;
    private final Map<String, Pair<Data, Long>> myDataByFile;

    public static ModelExternalData getInstance() {
        return (ModelExternalData)ApplicationManager.getApplication().getService(ModelExternalData.class);
    }

    public ModelExternalData(@NotNull CoroutineScope cs) {
        if (cs == null) {
            ModelExternalData.$$$reportNull$$$0(0);
        }
        this.myDataByFile = ContainerUtil.createSoftValueMap();
        this.updateState();
        RunnableWithDebounce handler = new RunnableWithDebounce(cs, () -> this.updateState());
        CONFIG_EP.addChangeListener(cs, (Runnable)handler);
    }

    private void updateState() {
        try {
            MultiMap dataByDbms = MultiMap.createLinkedSet();
            for (URL url : ConfigUrlBean.getUrls(CONFIG_EP.getExtensionsIfPointIsRegistered())) {
                try {
                    InputStream stream = url.openStream();
                    try {
                        ModelExternalData.loadConfig((MultiMap<Dbms, Data>)dataByDbms, stream);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to load " + url.toExternalForm(), (Throwable)e);
                }
            }
            this.myDataByDbms = dataByDbms;
        }
        catch (Throwable th) {
            LOG.error("Failed to load model external data", th);
        }
    }

    private MultiMap<Dbms, Data> getDataByDbms() {
        return this.myDataByDbms;
    }

    private static void loadConfig(@NotNull MultiMap<Dbms, Data> dataByDbms, @NotNull InputStream stream) {
        if (dataByDbms == null) {
            ModelExternalData.$$$reportNull$$$0(1);
        }
        if (stream == null) {
            ModelExternalData.$$$reportNull$$$0(2);
        }
        ModelExternalData.loadConfig(dataByDbms, ModelExternalData.createReader(stream));
    }

    @NotNull
    private static HierarchicalStreamReader createReader(@NotNull InputStream stream) {
        if (stream == null) {
            ModelExternalData.$$$reportNull$$$0(3);
        }
        return new XppReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), (XmlPullParser)new MXParser());
    }

    private static void loadConfig(@NotNull MultiMap<Dbms, Data> dataByDbms, @NotNull HierarchicalStreamReader reader) {
        if (dataByDbms == null) {
            ModelExternalData.$$$reportNull$$$0(4);
        }
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(5);
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            ModelExternalData.loadData(dataByDbms, reader);
            reader.moveUp();
        }
    }

    private static void loadData(@NotNull MultiMap<Dbms, Data> dataByDbms, @NotNull HierarchicalStreamReader reader) {
        if (dataByDbms == null) {
            ModelExternalData.$$$reportNull$$$0(6);
        }
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(7);
        }
        if (!"data".equals(reader.getNodeName())) {
            return;
        }
        String dbms = reader.getAttribute("dbms");
        if (dbms == null) {
            return;
        }
        Data data = ModelExternalData.loadDataInner(reader);
        for (String s : StringUtil.tokenize((String)dbms, (String)",")) {
            boolean found = false;
            for (Dbms d : Dbms.allValues((HSet)HSet.create((String)s))) {
                found = true;
                dataByDbms.putValue((Object)d, (Object)data);
            }
            if (found) continue;
            LOG.warn("No dbms " + s);
        }
    }

    @NotNull
    private static Data loadDataInner(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(8);
        }
        Data data = new Data();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            ModelExternalData.loadObjectSet(data.objSet, reader);
            reader.moveUp();
        }
        Data data2 = data;
        if (data2 == null) {
            ModelExternalData.$$$reportNull$$$0(9);
        }
        return data2;
    }

    private static void loadObjectSet(@NotNull @NotNull MultiMap<@NotNull ObjectPath, ObjDesc> objSet, @NotNull HierarchicalStreamReader reader) {
        if (objSet == null) {
            ModelExternalData.$$$reportNull$$$0(10);
        }
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(11);
        }
        if (!"object-set".equals(reader.getNodeName()) && !"table-set".equals(reader.getNodeName())) {
            return;
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            ModelExternalData.loadObjects(objSet, reader);
            reader.moveUp();
        }
    }

    private static void loadObjects(@NotNull @NotNull MultiMap<@NotNull ObjectPath, ObjDesc> objSet, @NotNull HierarchicalStreamReader reader) {
        if (objSet == null) {
            ModelExternalData.$$$reportNull$$$0(12);
        }
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(13);
        }
        ObjectPath objectPath = ModelExternalData.getPath(reader, false);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            ObjDesc desc = ModelExternalData.loadFkDesc(reader);
            if (desc == null) {
                desc = ModelExternalData.loadColDesc(reader);
            }
            if (desc == null) {
                desc = ModelExternalData.loadViewDesc(reader);
            }
            if (desc != null) {
                objSet.putValue((Object)objectPath, (Object)desc);
            } else {
                LOG.warn("Failed to load " + reader.getNodeName());
            }
            reader.moveUp();
        }
    }

    private static FkDesc loadFkDesc(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(14);
        }
        ObjectPath ref = ModelExternalData.getPath(reader, true);
        String from = reader.getAttribute("from");
        if (from == null) {
            return null;
        }
        String to = reader.getAttribute("to");
        if (to == null) {
            LOG.warn("Missing to attr");
            return null;
        }
        String name = reader.getAttribute("name");
        return new FkDesc(StringUtil.nullize((String)name), StringUtil.split((String)from, (String)","), ref, StringUtil.split((String)to, (String)","));
    }

    private static ColDesc loadColDesc(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(15);
        }
        if (!"column".equals(reader.getNodeName())) {
            return null;
        }
        String expr = reader.getAttribute("expr");
        if (expr == null) {
            LOG.warn("Missing expr attr");
            return null;
        }
        String name = reader.getAttribute("name");
        return new ColDesc(name, expr);
    }

    private static ViewDesc loadViewDesc(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(16);
        }
        if (!"view".equals(reader.getNodeName())) {
            return null;
        }
        String query = reader.getAttribute("query");
        if (query == null) {
            LOG.warn("Missing query attr");
            return null;
        }
        String name = reader.getAttribute("name");
        return new ViewDesc(name, query);
    }

    @Nullable
    private static ObjectPath getPath(@NotNull HierarchicalStreamReader reader, boolean opt) {
        ObjectKind kind;
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(17);
        }
        if ((kind = ObjectKind.getKind((String)reader.getNodeName())) == null) {
            if (!opt) {
                LOG.warn("Invalid table kind " + reader.getNodeName());
            }
            return null;
        }
        String path = reader.getAttribute("path");
        return path == null && opt && kind != ObjectKind.ROOT ? null : ModelExternalData.loadPath(path, kind);
    }

    @Nullable
    private static ObjectPath loadPath(@Nullable String path, @NotNull ObjectKind kind) {
        if (kind == null) {
            ModelExternalData.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmpty((String)path) && kind == ObjectKind.ROOT) {
            return ObjectPath.create((String)"", (ObjectKind)ObjectKind.ROOT);
        }
        if (path == null) {
            LOG.warn("Missing `path` attr");
            return null;
        }
        String[] split = path.split("\\.");
        if (split.length > 3) {
            LOG.warn("Path should be no longer than db.sc.tab, but it is " + path);
            return null;
        }
        ObjectPath p = null;
        for (int i2 = 0; i2 < split.length; ++i2) {
            int pd = split.length - i2 - 1;
            ObjectKind k = pd == 0 ? kind : (pd == 1 ? ObjectKind.SCHEMA : ObjectKind.DATABASE);
            p = ObjectPath.create((String)split[i2], (ObjectKind)k, (boolean)true, null, p);
        }
        return p;
    }

    @NotNull
    public JBIterable<Data> getDataSourceData(@NotNull LocalDataSource dataSource, boolean editableOnly) {
        JBIterable data;
        if (dataSource == null) {
            ModelExternalData.$$$reportNull$$$0(19);
        }
        Data dsData = this.getDataSourceData(dataSource);
        JBIterable jBIterable = data = editableOnly ? JBIterable.empty() : JBIterable.from((Iterable)this.getDataByDbms().get((Object)dataSource.getDbms()));
        if (dsData != null) {
            data = data.append((Object)dsData);
        }
        JBIterable jBIterable2 = data;
        if (jBIterable2 == null) {
            ModelExternalData.$$$reportNull$$$0(20);
        }
        return jBIterable2;
    }

    @Nullable
    private Data getDataSourceData(@NotNull LocalDataSource dataSource) {
        String path;
        if (dataSource == null) {
            ModelExternalData.$$$reportNull$$$0(21);
        }
        return (path = ModelExternalData.getExternalDataPath(dataSource)) == null ? null : this.getData(path);
    }

    @NotNull
    public static <T> JBIterable<T> extract(@NotNull @NotNull MultiMap<@NotNull ObjectPath, T> ts, @Nullable ObjectPath path) {
        if (ts == null) {
            ModelExternalData.$$$reportNull$$$0(22);
        }
        JBIterable jBIterable = path == null ? JBIterable.empty() : JBIterable.from((Iterable)ts.get((Object)path)).append(ModelExternalData.extract(ts, ModelExternalData.trimStart(path)));
        if (jBIterable == null) {
            ModelExternalData.$$$reportNull$$$0(23);
        }
        return jBIterable;
    }

    @NotNull
    public static <T> JBIterable<T> extract(@NotNull Data d, @NotNull ObjectPath path, Class<T> c2) {
        if (d == null) {
            ModelExternalData.$$$reportNull$$$0(24);
        }
        if (path == null) {
            ModelExternalData.$$$reportNull$$$0(25);
        }
        JBIterable jBIterable = ModelExternalData.extract(d.objSet, path).filter(c2);
        if (jBIterable == null) {
            ModelExternalData.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    @Nullable
    private static ObjectPath trimStart(@Nullable ObjectPath path) {
        if (path == null) {
            return null;
        }
        if (path.parent == null) {
            if (path.name.isEmpty()) {
                return null;
            }
            return ObjectPath.create((String)"", (ObjectKind)path.kind);
        }
        return ObjectPath.create((String)path.name, (ObjectKind)path.kind, (boolean)path.isQuoted(), (String)path.getIdentity(), (ObjectPath)ModelExternalData.trimStart(path.parent));
    }

    @NlsSafe
    public static @SystemDependent @Nullable String getExternalDataPath(@NotNull LocalDataSource ds) {
        if (ds == null) {
            ModelExternalData.$$$reportNull$$$0(27);
        }
        return StringUtil.nullize((String)ds.getAdditionalProperty(EXTERNAL_DATA_PATH));
    }

    public static void setExternalDataPath(@NotNull LocalDataSource ds, @SystemDependent @Nullable String path) {
        if (ds == null) {
            ModelExternalData.$$$reportNull$$$0(28);
        }
        ds.setAdditionalProperty(EXTERNAL_DATA_PATH, StringUtil.nullize((String)path));
    }

    @Nullable
    private static DasObject resolveSimilar(@Nullable DasObject anchor, @Nullable ObjectPath path) {
        if (path == null || anchor == null) {
            return anchor;
        }
        DasObject parent = anchor.getDasParent();
        DasObject resolvedParent = ModelExternalData.resolveSimilar(parent, path.parent);
        Condition condition = DbSqlUtilCore.byName(path.name, path.isQuoted(), null, DbImplUtilCore.getCasingProvider(anchor));
        if (parent == resolvedParent && anchor.getKind() == path.kind && condition.value((Object)anchor)) {
            return anchor;
        }
        if (resolvedParent == null) {
            return null;
        }
        return (DasObject)resolvedParent.getDasChildren(path.kind).filter(condition).first();
    }

    @Nullable
    private Data getData(@SystemDependent @NotNull String path) {
        if (path == null) {
            ModelExternalData.$$$reportNull$$$0(29);
        }
        File file = new File(path);
        long modified = file.lastModified();
        return this.getData(file, null, modified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Data getData(File file, @Nullable String canonical, long modified) {
        String key = canonical == null ? file.getPath() : canonical;
        Map<String, Pair<Data, Long>> map = this.myDataByFile;
        synchronized (map) {
            Pair<Data, Long> cached = this.myDataByFile.get(key);
            if (cached != null && (Long)cached.second >= modified) {
                return (Data)cached.first;
            }
        }
        Data res = canonical == null ? this.computeCanonicalData(file, modified) : ModelExternalData.computeData(file);
        Map<String, Pair<Data, Long>> map2 = this.myDataByFile;
        synchronized (map2) {
            Pair data = this.myDataByFile.get(key);
            if (data != null && (Long)data.second >= modified) {
                return (Data)data.first;
            }
            data = Pair.create((Object)res, (Object)modified);
            this.myDataByFile.put(key, (Pair<Data, Long>)data);
            return res;
        }
    }

    @Nullable
    private Data computeCanonicalData(File file, long modified) {
        try {
            String canonical = file.getCanonicalPath();
            if (!file.getPath().equals(canonical)) {
                return this.getData(file, canonical, modified);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return ModelExternalData.computeData(file);
    }

    @Nullable
    private static Data computeData(File file) {
        Data res = null;
        if (file.exists()) {
            try (FileInputStream stream = new FileInputStream(file);){
                res = ModelExternalData.loadDataInner(ModelExternalData.createReader(stream));
            }
            catch (Throwable e) {
                String message = DatabaseBundle.message((String)"notification.content.unable.to.load", (Object[])new Object[]{file.getPath()});
                LOG.warn(message, e);
                PlatformIdeService.getInstance().notification("Database configuration", PlatformIdeService.NotificationType.ERROR, null, null, message, null, "ModelExternalData.load.failed");
            }
        }
        return res;
    }

    public static void modify(@NotNull String path, @NotNull Consumer<? super Data> modifier) {
        Data data;
        if (path == null) {
            ModelExternalData.$$$reportNull$$$0(30);
        }
        if (modifier == null) {
            ModelExternalData.$$$reportNull$$$0(31);
        }
        if ((data = ModelExternalData.getInstance().getData(path)) == null) {
            data = new Data();
        }
        modifier.consume((Object)data);
        try {
            ModelExternalData.serialize(data, path);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void serialize(@NotNull Data data, String path) throws IOException {
        if (data == null) {
            ModelExternalData.$$$reportNull$$$0(32);
        }
        try (SafeFileOutputStream out = new SafeFileOutputStream(new File(path));){
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            PrettyPrintWriter writer = new PrettyPrintWriter((Writer)printWriter);
            ModelExternalData.serialize(data, (HierarchicalStreamWriter)writer);
            writer.close();
        }
    }

    private static void serialize(@NotNull Data data, @NotNull HierarchicalStreamWriter writer) {
        if (data == null) {
            ModelExternalData.$$$reportNull$$$0(33);
        }
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(34);
        }
        writer.startNode("data");
        ModelExternalData.serialize(data.objSet, writer);
        writer.endNode();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void serialize(@NotNull @NotNull MultiMap<@NotNull ObjectPath, ObjDesc> objSet, @NotNull HierarchicalStreamWriter writer) {
        if (objSet == null) {
            ModelExternalData.$$$reportNull$$$0(35);
        }
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(36);
        }
        writer.startNode("object-set");
        @NotNull List sorted = ContainerUtil.sorted((Collection)objSet.entrySet(), Map.Entry.comparingByKey(ObjectPaths::compare));
        for (Map.Entry entry : sorted) {
            ModelExternalData.startPathNode(writer, (ObjectPath)entry.getKey(), ObjectKind.ROOT);
            for (ObjDesc o : ContainerUtil.sorted((Collection)((Collection)entry.getValue()))) {
                if (o instanceof FkDesc) {
                    ModelExternalData.serializeRef(writer, (FkDesc)o);
                    continue;
                }
                if (o instanceof ColDesc) {
                    ModelExternalData.serializeCol(writer, (ColDesc)o);
                    continue;
                }
                if (!(o instanceof ViewDesc)) continue;
                ModelExternalData.serializeView(writer, (ViewDesc)o);
            }
            writer.endNode();
        }
        writer.endNode();
    }

    private static void serializeRef(@NotNull HierarchicalStreamWriter writer, @NotNull FkDesc desc) {
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(37);
        }
        if (desc == null) {
            ModelExternalData.$$$reportNull$$$0(38);
        }
        ModelExternalData.startPathNode(writer, desc.ref, ObjectKind.TABLE);
        if (StringUtil.isNotEmpty((String)desc.name)) {
            writer.addAttribute("name", desc.name);
        }
        writer.addAttribute("from", StringUtil.join(desc.columns, (String)","));
        writer.addAttribute("to", StringUtil.join(desc.refColumns, (String)","));
        writer.endNode();
    }

    private static void serializeCol(@NotNull HierarchicalStreamWriter writer, @NotNull ColDesc desc) {
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(39);
        }
        if (desc == null) {
            ModelExternalData.$$$reportNull$$$0(40);
        }
        writer.startNode("column");
        if (StringUtil.isNotEmpty((String)desc.name)) {
            writer.addAttribute("name", desc.name);
        }
        writer.addAttribute("expr", desc.expr);
        writer.endNode();
    }

    private static void serializeView(@NotNull HierarchicalStreamWriter writer, @NotNull ViewDesc desc) {
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(41);
        }
        if (desc == null) {
            ModelExternalData.$$$reportNull$$$0(42);
        }
        writer.startNode("view");
        if (StringUtil.isNotEmpty((String)desc.name)) {
            writer.addAttribute("name", desc.name);
        }
        writer.addAttribute("query", desc.query);
        writer.endNode();
    }

    private static void startPathNode(@NotNull HierarchicalStreamWriter writer, @Nullable ObjectPath path, @NotNull ObjectKind defKind) {
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(43);
        }
        if (defKind == null) {
            ModelExternalData.$$$reportNull$$$0(44);
        }
        writer.startNode((path == null ? defKind : path.kind).code());
        if (path != null) {
            writer.addAttribute("path", path.getDisplayName());
        }
    }

    public static JBIterable<ColDesc> getExtraColumns(@Nullable DasDataSource dataSource, boolean editableOnly, @Nullable DasObject table) {
        LocalDataSource lds = DbImplUtilCore.getMaybeLocalDataSource(dataSource);
        if (lds != null && table instanceof DasTable) {
            return ModelExternalData.getExtraColumns(lds, editableOnly, (DasTable)table);
        }
        return JBIterable.empty();
    }

    public static JBIterable<ColDesc> getExtraColumns(@NotNull LocalDataSource dataSource, boolean editableOnly, @NotNull DasTable table) {
        if (dataSource == null) {
            ModelExternalData.$$$reportNull$$$0(45);
        }
        if (table == null) {
            ModelExternalData.$$$reportNull$$$0(46);
        }
        ModelExternalData instance = ModelExternalData.getInstance();
        ObjectPath path = ObjectPaths.of((DasObject)table);
        JBIterable<Data> data = instance.getDataSourceData(dataSource, editableOnly);
        return data.flatten(d -> ModelExternalData.extract(d, path, ColDesc.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 20, 23, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataByDbms";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 9: 
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelExternalData";
                break;
            }
            case 10: 
            case 12: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objSet";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 19: 
            case 21: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ts";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 25: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 38: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defKind";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelExternalData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDataInner";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceData";
                break;
            }
            case 23: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadConfig";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createReader";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadDataInner";
                break;
            }
            case 9: 
            case 20: 
            case 23: 
            case 26: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadObjectSet";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadObjects";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadFkDesc";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadColDesc";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadViewDesc";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadPath";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceData";
                break;
            }
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getExternalDataPath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setExternalDataPath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "serializeRef";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "serializeCol";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "serializeView";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "startPathNode";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getExtraColumns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 20, 23, 26 -> new IllegalStateException(string);
        };
    }

    public static final class Data {
        public MultiMap<@NotNull ObjectPath, ObjDesc> objSet = new MultiMap<ObjectPath, ObjDesc>(CollectionFactory.createCustomHashingStrategyMap(ObjectPaths.SIMPLE_INSENSITIVE_STRATEGY)){

            @NotNull
            protected Collection<ObjDesc> createCollection() {
                return new LinkedHashSet<ObjDesc>();
            }
        };
    }

    public static final class FkDesc
    extends ObjDesc {
        public final String name;
        public final List<String> columns;
        public final ObjectPath ref;
        public final List<String> refColumns;

        public FkDesc(@Nullable String name, @NotNull List<String> columns, @Nullable ObjectPath ref, @NotNull List<String> refColumns) {
            if (columns == null) {
                FkDesc.$$$reportNull$$$0(0);
            }
            if (refColumns == null) {
                FkDesc.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.columns = columns;
            this.ref = ref;
            this.refColumns = refColumns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FkDesc)) {
                return false;
            }
            FkDesc desc = (FkDesc)o;
            return Objects.equals(this.name, desc.name) && this.columns.equals(desc.columns) && Objects.equals(this.ref, desc.ref) && this.refColumns.equals(desc.refColumns);
        }

        @Override
        public int compareTo(@NotNull ObjDesc desc) {
            if (desc == null) {
                FkDesc.$$$reportNull$$$0(2);
            }
            if (this == desc) {
                return 0;
            }
            if (desc instanceof FkDesc) {
                FkDesc fk = (FkDesc)desc;
                int res = ObjectPaths.compare(this.ref, fk.ref);
                if (res != 0) {
                    return res;
                }
                res = Comparing.compare((Comparable)((Object)this.name), (Comparable)((Object)fk.name));
                if (res != 0) {
                    return res;
                }
                res = ContainerUtil.compareLexicographically(this.columns, fk.columns);
                if (res != 0) {
                    return res;
                }
                res = ContainerUtil.compareLexicographically(this.refColumns, fk.refColumns);
                return res;
            }
            return super.compareTo(desc);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.columns, this.ref, this.refColumns);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refColumns";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/ModelExternalData$FkDesc";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ColDesc
    extends ObjDesc {
        public final String name;
        public final String expr;

        public ColDesc(@Nullable String name, @NotNull String expr) {
            if (expr == null) {
                ColDesc.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.expr = expr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ColDesc)) {
                return false;
            }
            ColDesc desc = (ColDesc)o;
            return Objects.equals(this.name, desc.name) && this.expr.equals(desc.expr);
        }

        @Override
        public int compareTo(@NotNull ObjDesc desc) {
            if (desc == null) {
                ColDesc.$$$reportNull$$$0(1);
            }
            if (this == desc) {
                return 0;
            }
            if (desc instanceof ColDesc) {
                ColDesc c2 = (ColDesc)desc;
                int res = Comparing.compare((Comparable)((Object)this.name), (Comparable)((Object)c2.name));
                if (res != 0) {
                    return res;
                }
                res = Comparing.compare((Comparable)((Object)this.expr), (Comparable)((Object)c2.expr));
                return res;
            }
            return super.compareTo(desc);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.expr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/ModelExternalData$ColDesc";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ViewDesc
    extends ObjDesc {
        @NotNull
        public final String name;
        public final String query;

        public ViewDesc(@NotNull String name, @NotNull String query) {
            if (name == null) {
                ViewDesc.$$$reportNull$$$0(0);
            }
            if (query == null) {
                ViewDesc.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.query = query;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ViewDesc)) {
                return false;
            }
            ViewDesc desc = (ViewDesc)o;
            return this.name.equals(desc.name) && this.query.equals(desc.query);
        }

        @Override
        public int compareTo(@NotNull ObjDesc desc) {
            if (desc == null) {
                ViewDesc.$$$reportNull$$$0(2);
            }
            if (this == desc) {
                return 0;
            }
            if (desc instanceof ViewDesc) {
                ViewDesc v = (ViewDesc)desc;
                int res = Comparing.compare((Comparable)((Object)this.name), (Comparable)((Object)v.name));
                if (res != 0) {
                    return res;
                }
                res = Comparing.compare((Comparable)((Object)this.query), (Comparable)((Object)v.query));
                return res;
            }
            return super.compareTo(desc);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.query);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/ModelExternalData$ViewDesc";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ObjDesc
    implements Comparable<ObjDesc> {
        @Override
        public int compareTo(@NotNull ObjDesc desc) {
            if (desc == null) {
                ObjDesc.$$$reportNull$$$0(0);
            }
            if (desc == this) {
                return 0;
            }
            return Comparing.compare((Comparable)((Object)this.getClass().getSimpleName()), (Comparable)((Object)desc.getClass().getSimpleName()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/database/model/ModelExternalData$ObjDesc", "compareTo"));
        }
    }

    private static final class FakeColumn
    implements DasColumn {
        private final DasTable myTable;
        private final String myName;
        private final DasType myDasType;

        private FakeColumn(DasTable table, String name, DasType dasType) {
            this.myTable = table;
            this.myName = name;
            this.myDasType = dasType;
        }

        public short getPosition() {
            return 0;
        }

        @Nullable
        public DasTable getTable() {
            return this.myTable;
        }

        @NotNull
        public DasType getDasType() {
            DasType dasType = this.myDasType;
            if (dasType == null) {
                FakeColumn.$$$reportNull$$$0(0);
            }
            return dasType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                FakeColumn.$$$reportNull$$$0(1);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                FakeColumn.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isQuoted() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/model/ModelExternalData$FakeColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static final class ExtraForeignKey
    extends ModelRelationManager.ExtraRelation {
        private final FkDesc myFk;

        private ExtraForeignKey(@NotNull DasTable table, @NotNull FkDesc fk, @Nullable DasTable refTable) {
            if (table == null) {
                ExtraForeignKey.$$$reportNull$$$0(0);
            }
            if (fk == null) {
                ExtraForeignKey.$$$reportNull$$$0(1);
            }
            super(table, refTable);
            this.myFk = fk;
        }

        @Override
        public String getProviderId() {
            return "External";
        }

        @Override
        public String getRefTableName() {
            return this.myFk.ref == null ? null : this.myFk.ref.name;
        }

        @Override
        public String getRefTableSchema() {
            ObjectPath parent = this.myFk.ref == null ? null : this.myFk.ref.parent;
            return parent == null ? null : parent.name;
        }

        @Override
        public String getRefTableCatalog() {
            ObjectPath parent = this.myFk.ref == null ? null : this.myFk.ref.parent;
            parent = parent == null ? null : parent.parent;
            return parent == null ? null : parent.name;
        }

        @NotNull
        public MultiRef<? extends DasTypedObject> getRefColumns() {
            DasTable table = this.getRefTable();
            CasingProvider casingProvider = DbImplUtilCore.getCasingProvider((DasObject)table);
            MultiRef multiRef = DasUtil.asRef(this.myFk.refColumns, (Function)Functions.id(), c2 -> ExtraForeignKey.resolveColumn(table, c2, casingProvider));
            if (multiRef == null) {
                ExtraForeignKey.$$$reportNull$$$0(2);
            }
            return multiRef;
        }

        private static DasColumn resolveColumn(DasTable table, String c2, CasingProvider casingProvider) {
            if (table == null) {
                return null;
            }
            DasColumn res = (DasColumn)table.getDasChildren(ObjectKind.COLUMN).filter(DbSqlUtilCore.byName(c2, true, null, casingProvider)).filter(DasColumn.class).first();
            if (res != null) {
                return res;
            }
            return new FakeColumn(table, c2, DasUnresolvedTypeReference.of(DataTypeFactory.of("int")));
        }

        @NotNull
        public MultiRef<? extends DasTypedObject> getColumnsRef() {
            CasingProvider casingProvider = DbImplUtilCore.getCasingProvider((DasObject)this.getTable());
            MultiRef multiRef = DasUtil.asRef(this.myFk.columns, (Function)Functions.id(), c2 -> ExtraForeignKey.resolveColumn(this.getTable(), c2, casingProvider));
            if (multiRef == null) {
                ExtraForeignKey.$$$reportNull$$$0(3);
            }
            return multiRef;
        }

        @Override
        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myFk.name);
            if (string == null) {
                ExtraForeignKey.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExtraForeignKey)) {
                return false;
            }
            ExtraForeignKey key = (ExtraForeignKey)o;
            if (!super.equals(o)) {
                return false;
            }
            return this.myFk.equals(key.myFk);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myFk);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fk";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/ModelExternalData$ExtraForeignKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/ModelExternalData$ExtraForeignKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefColumns";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnsRef";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ExternalRelations
    implements ModelRelationManager.ModelRelationProvider {
        public static final String ID = "External";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public JBIterable<DasForeignKey> getForeignKeys(@Nullable Project project, @NotNull DasTable table, @Nullable DasTable target) {
            if (table == null) {
                ExternalRelations.$$$reportNull$$$0(0);
            }
            Dbms dbms = DbImplUtilCore.getDbms((DasObject)table);
            JBIterable data = JBIterable.from((Iterable)ModelExternalData.getInstance().getDataByDbms().get((Object)dbms)).append(ExternalRelations.getDataSourceData(project, (DasObject)table));
            return ExternalRelations.getForeignKeys((JBIterable<Data>)data, table, target);
        }

        public static JBIterable<DasForeignKey> getForeignKeys(@NotNull LocalDataSource dataSource, boolean editableOnly, @NotNull DasTable table) {
            if (dataSource == null) {
                ExternalRelations.$$$reportNull$$$0(1);
            }
            if (table == null) {
                ExternalRelations.$$$reportNull$$$0(2);
            }
            ModelExternalData instance = ModelExternalData.getInstance();
            JBIterable<Data> data = instance.getDataSourceData(dataSource, editableOnly);
            return ExternalRelations.getForeignKeys(data, table, null);
        }

        @NotNull
        private static @NotNull JBIterable<@NotNull DasForeignKey> getForeignKeys(@NotNull JBIterable<Data> data, @NotNull DasTable table, @Nullable DasTable target) {
            if (data == null) {
                ExternalRelations.$$$reportNull$$$0(3);
            }
            if (table == null) {
                ExternalRelations.$$$reportNull$$$0(4);
            }
            ObjectPath path = ObjectPaths.of((DasObject)table);
            JBIterable jBIterable = data.flatten(d -> ModelExternalData.extract(d, path, FkDesc.class)).filter(fk -> ExternalRelations.isApplicable(fk, table, target)).filterMap(fk -> {
                DasTable refTable = target == null ? (DasTable)ObjectUtils.tryCast((Object)ModelExternalData.resolveSimilar((DasObject)table, fk.ref), DasTable.class) : target;
                return new ExtraForeignKey(table, (FkDesc)fk, refTable);
            });
            if (jBIterable == null) {
                ExternalRelations.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static Iterable<Data> getDataSourceData(@Nullable Project project, @NotNull DasObject object) {
            if (object == null) {
                ExternalRelations.$$$reportNull$$$0(6);
            }
            return project == null ? JBIterable.empty() : ExternalRelations.getDataSources(project, object).filterMap(ModelExternalData.getInstance()::getDataSourceData);
        }

        private static boolean isApplicable(@NotNull FkDesc fk, @NotNull DasTable table, @Nullable DasTable target) {
            if (fk == null) {
                ExternalRelations.$$$reportNull$$$0(7);
            }
            if (table == null) {
                ExternalRelations.$$$reportNull$$$0(8);
            }
            return target == null || ExternalRelations.matches((DasObject)target, fk.ref);
        }

        private static boolean matches(@NotNull DasObject obj, @Nullable ObjectPath path) {
            if (obj == null) {
                ExternalRelations.$$$reportNull$$$0(9);
            }
            if (path == null || !path.name.equals(obj.getName()) || obj.getKind() != path.kind) {
                return false;
            }
            if (path.parent == null) {
                return true;
            }
            DasObject parent = obj.getDasParent();
            return parent != null && ExternalRelations.matches(parent, path.parent);
        }

        @NotNull
        private static JBIterable<LocalDataSource> getDataSources(@NotNull Project project, @NotNull DasObject obj) {
            if (project == null) {
                ExternalRelations.$$$reportNull$$$0(10);
            }
            if (obj == null) {
                ExternalRelations.$$$reportNull$$$0(11);
            }
            if (obj instanceof DbElement) {
                JBIterable jBIterable = JBIterable.of((Object)DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)((DbElement)obj).getDataSource()));
                if (jBIterable == null) {
                    ExternalRelations.$$$reportNull$$$0(12);
                }
                return jBIterable;
            }
            if (obj instanceof BasicElement) {
                DbModelRegistry r = (DbModelRegistry)project.getService(DbModelRegistry.class);
                JBIterable jBIterable = JBIterable.of((Object)DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)r.findDbDataSource(obj)));
                if (jBIterable == null) {
                    ExternalRelations.$$$reportNull$$$0(13);
                }
                return jBIterable;
            }
            if (obj instanceof PsiElement) {
                PsiFile file = ((PsiElement)obj).getContainingFile();
                JBIterable jBIterable = file == null ? JBIterable.empty() : DbSqlUtilCore.getAppropriateDataSources(file, false, true).filterMap(DbImplUtilCore::getMaybeLocalDataSource);
                if (jBIterable == null) {
                    ExternalRelations.$$$reportNull$$$0(14);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ExternalRelations.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 12, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 5: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/ModelExternalData$ExternalRelations";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fk";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/ModelExternalData$ExternalRelations";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForeignKeys";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getForeignKeys";
                    break;
                }
                case 5: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSourceData";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSources";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 12, 13, 14, 15 -> new IllegalStateException(string);
            };
        }
    }
}

