/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.quadtree.Node;

public abstract class NodeBase
implements Serializable {
    protected List items = Collections.synchronizedList(new ArrayList());
    protected Node[] subnode = new Node[4];

    public static int getSubnodeIndex(Envelope env, double centrex, double centrey) {
        int subnodeIndex = -1;
        if (env.getMinX() >= centrex) {
            if (env.getMinY() >= centrey) {
                subnodeIndex = 3;
            }
            if (env.getMaxY() <= centrey) {
                subnodeIndex = 1;
            }
        }
        if (env.getMaxX() <= centrex) {
            if (env.getMinY() >= centrey) {
                subnodeIndex = 2;
            }
            if (env.getMaxY() <= centrey) {
                subnodeIndex = 0;
            }
        }
        return subnodeIndex;
    }

    public List getItems() {
        return this.items;
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    public void add(Object item) {
        this.items.add(item);
    }

    public boolean remove(Envelope itemEnv, Object item) {
        if (!this.isSearchMatch(itemEnv)) {
            return false;
        }
        boolean found = false;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.subnode[i2] == null || !(found = this.subnode[i2].remove(itemEnv, item))) continue;
            if (!this.subnode[i2].isPrunable()) break;
            this.subnode[i2] = null;
            break;
        }
        if (found) {
            return found;
        }
        found = this.items.remove(item);
        return found;
    }

    public boolean isPrunable() {
        return !this.hasChildren() && !this.hasItems();
    }

    public boolean hasChildren() {
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.subnode[i2] == null) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        if (!this.items.isEmpty()) {
            isEmpty = false;
        } else {
            for (int i2 = 0; i2 < 4; ++i2) {
                if (this.subnode[i2] == null || this.subnode[i2].isEmpty()) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public List addAllItems(List resultItems) {
        resultItems.addAll(this.items);
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.subnode[i2] == null) continue;
            this.subnode[i2].addAllItems(resultItems);
        }
        return resultItems;
    }

    protected abstract boolean isSearchMatch(Envelope var1);

    public void addAllItemsFromOverlapping(Envelope searchEnv, List resultItems) {
        if (!this.isSearchMatch(searchEnv)) {
            return;
        }
        resultItems.addAll(this.items);
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.subnode[i2] == null) continue;
            this.subnode[i2].addAllItemsFromOverlapping(searchEnv, resultItems);
        }
    }

    public void visit(Envelope searchEnv, ItemVisitor visitor) {
        if (!this.isSearchMatch(searchEnv)) {
            return;
        }
        this.visitItems(searchEnv, visitor);
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.subnode[i2] == null) continue;
            this.subnode[i2].visit(searchEnv, visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitItems(Envelope searchEnv, ItemVisitor visitor) {
        List list = this.items;
        synchronized (list) {
            for (int i2 = 0; i2 < this.items.size(); ++i2) {
                visitor.visitItem(this.items.get(i2));
            }
        }
    }

    int depth() {
        int maxSubDepth = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int sqd;
            if (this.subnode[i2] == null || (sqd = this.subnode[i2].depth()) <= maxSubDepth) continue;
            maxSubDepth = sqd;
        }
        return maxSubDepth + 1;
    }

    int size() {
        int subSize = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.subnode[i2] == null) continue;
            subSize += this.subnode[i2].size();
        }
        return subSize + this.items.size();
    }

    int getNodeCount() {
        int subSize = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.subnode[i2] == null) continue;
            subSize += this.subnode[i2].size();
        }
        return subSize + 1;
    }
}

