/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.hibernate;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.hibernate.model.manipulators.SessionFactoryManipulator;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.manipulators.AbstractPersistenceManipulator;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistenceUnitManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.persistence.integration.hibernate.HibernateIntegrationUtil;
import com.intellij.spring.persistence.integration.hibernate.SpringXmlHibernateSessionFactory;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.GenericValueUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringBeanPersistenceUnitManipulator
extends AbstractPersistenceManipulator<SpringXmlHibernateSessionFactory>
implements PersistenceUnitManipulator<SpringXmlHibernateSessionFactory> {
    SpringBeanPersistenceUnitManipulator(SpringXmlHibernateSessionFactory target) {
        super((Object)target);
    }

    public List<PersistenceAction> getCreateActions() {
        return SessionFactoryManipulator.getCreateActionsDefault((PersistenceUnitManipulator)this, new ArrayList());
    }

    public void ensureMappingIncluded(PersistenceMappings mappings) {
        if (mappings instanceof DomElement && !GenericValueUtil.containsValue((Collection)((SpringXmlHibernateSessionFactory)((Object)this.getManipulatorTarget())).getModelHelper().getMappingFiles(PersistenceMappings.class), (Object)mappings)) {
            SpringBean bean = (SpringBean)((SpringXmlHibernateSessionFactory)((Object)this.getManipulatorTarget())).getBean();
            SpringPropertyDefinition propertyDef = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)"mappingLocations");
            propertyDef = propertyDef != null ? propertyDef : SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)"cacheableMappingLocations");
            propertyDef = propertyDef != null ? propertyDef : SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)"mappingResources");
            String fileReferenceString = SpringResourcesUtil.getInstance().getResourceFileReferenceString(mappings.getContainingFile());
            HibernateIntegrationUtil.setBeanProperty(bean, propertyDef, "mappingLocations", fileReferenceString, true);
        }
    }

    public void ensureClassIncluded(PsiClass psiClass) {
        if (!((SpringXmlHibernateSessionFactory)((Object)this.getManipulatorTarget())).supportsAnnotations()) {
            return;
        }
        if (!GenericValueUtil.containsValue((Collection)((SpringXmlHibernateSessionFactory)((Object)this.getManipulatorTarget())).getModelHelper().getClasses(), (Object)psiClass)) {
            String packageName = ((PsiJavaFile)psiClass.getContainingFile()).getPackageName();
            PsiManager manager = psiClass.getManager();
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(packageName);
            for (GenericValue pkgValue : ((SpringXmlHibernateSessionFactory)((Object)this.getManipulatorTarget())).getModelHelper().getPackages()) {
                if (!manager.areElementsEquivalent((PsiElement)psiPackage, (PsiElement)pkgValue.getValue())) continue;
                return;
            }
            SpringBean bean = (SpringBean)((SpringXmlHibernateSessionFactory)((Object)this.getManipulatorTarget())).getBean();
            HibernateIntegrationUtil.setBeanProperty(bean, "annotatedClasses", null, psiClass.getQualifiedName(), true);
        }
    }

    public void setConnectionProperties(@NotNull Project project, @NotNull RawConnectionConfig info, @Nullable Credentials credentials) {
        SpringXmlHibernateSessionFactory unit;
        SpringBean bean;
        SpringPropertyDefinition propertyDef;
        if (project == null) {
            SpringBeanPersistenceUnitManipulator.$$$reportNull$$$0(0);
        }
        if (info == null) {
            SpringBeanPersistenceUnitManipulator.$$$reportNull$$$0(1);
        }
        if (!((propertyDef = SpringPropertyUtils.findPropertyByName((CommonSpringBean)(bean = (SpringBean)(unit = (SpringXmlHibernateSessionFactory)((Object)this.getManipulatorTarget())).getBean()), (String)"hibernateProperties")) instanceof SpringProperty)) {
            if (propertyDef != null) {
                propertyDef.undefine();
            }
            SpringProperty property = bean.addProperty();
            property.getName().setStringValue("hibernateProperties");
            propertyDef = property;
        }
        SpringProperty hibernateProperties = (SpringProperty)propertyDef;
        String url = DataSourceUtil.getEffectiveUrl((Project)project, (RawConnectionConfig)info);
        HibernateIntegrationUtil.setBeanProperty(hibernateProperties.getProps(), HibernateUtil.getFullPropertyName((String)"connection.url"), "connection.url", url);
        HibernateIntegrationUtil.setBeanProperty(hibernateProperties.getProps(), HibernateUtil.getFullPropertyName((String)"connection.driver_class"), "connection.driver_class", info.getDriverClass());
        HibernateIntegrationUtil.setBeanProperty(hibernateProperties.getProps(), HibernateUtil.getFullPropertyName((String)"connection.username"), "connection.username", credentials == null ? null : credentials.getUserName());
        HibernateIntegrationUtil.setBeanProperty(hibernateProperties.getProps(), HibernateUtil.getFullPropertyName((String)"connection.password"), "connection.password", credentials == null ? null : credentials.getPasswordAsString());
        Prop dialect = HibernateIntegrationUtil.findProp(hibernateProperties.getProps(), HibernateUtil.getFullPropertyName((String)"dialect"), "dialect");
        if (dialect == null) {
            dialect = hibernateProperties.getProps().addProp();
            String dialectValue = HibernateUtil.getDefaultDialectValue((PsiElement)dialect.getXmlElement(), (String)url);
            if (StringUtil.isNotEmpty((String)dialectValue)) {
                dialect.getKey().setStringValue(HibernateUtil.getFullPropertyName((String)"dialect"));
                dialect.setStringValue(dialectValue);
            } else {
                dialect.undefine();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/persistence/integration/hibernate/SpringBeanPersistenceUnitManipulator";
        objectArray[2] = "setConnectionProperties";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

