/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.database.dialects.oracle.OraDbSqlUtils;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.util.NameChecker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNavigationUtils;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.base.NavigationHelperBase;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlCreateTypeStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraNavigationHelper
extends NavigationHelperBase {
    public @Nullable Pair<@NlsContexts.PopupTitle String, JBIterable<? extends DasObject>> findSuperDefinitions(@NotNull DasObject def, boolean checkOnly) {
        if (def == null) {
            OraNavigationHelper.$$$reportNull$$$0(0);
        }
        if (def.getKind() == ObjectKind.BODY) {
            return Pair.create((Object)SqlBundle.message((String)"popup.title.go.to.specification", (Object[])new Object[0]), checkOnly ? JBIterable.empty() : OraNavigationHelper.findBodySpecifications(def));
        }
        if (OraDbSqlUtils.isBodyRoutine((DasObject)def, (boolean)false)) {
            JBIterable<? extends DasObject> specifications = OraNavigationHelper.findRoutineSpecifications(def);
            if (checkOnly && specifications.isEmpty()) {
                return null;
            }
            return Pair.create((Object)SqlBundle.message((String)"popup.title.go.to.specification", (Object[])new Object[0]), checkOnly ? JBIterable.empty() : specifications);
        }
        if (def.getKind() == ObjectKind.OBJECT_TYPE) {
            if (checkOnly && !OraNavigationHelper.hasSuperTypes(def)) {
                return null;
            }
            return Pair.create((Object)SqlBundle.message((String)"popup.title.go.to.super.type", (Object[])new Object[0]), checkOnly ? JBIterable.empty() : OraNavigationHelper.findSuperTypes(def));
        }
        return null;
    }

    public @Nullable Pair<@NlsContexts.PopupTitle String, JBIterable<? extends DasObject>> findDefinitions(@NotNull DasObject def, boolean checkOnly) {
        ObjectKind pKind;
        ObjectKind kind;
        if (def == null) {
            OraNavigationHelper.$$$reportNull$$$0(1);
        }
        if ((kind = def.getKind()) == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE) {
            return Pair.create((Object)SqlBundle.message((String)"popup.title.go.to.body", (Object[])new Object[0]), checkOnly ? JBIterable.empty() : OraNavigationHelper.findBodies(def));
        }
        DasObject parent = def.getDasParent();
        ObjectKind objectKind = pKind = parent == null ? null : parent.getKind();
        if (kind == ObjectKind.ROUTINE && (pKind == ObjectKind.PACKAGE || pKind == ObjectKind.OBJECT_TYPE || OraNavigationHelper.isBlockRoutineDefinition(def))) {
            return Pair.create((Object)SqlBundle.message((String)"popup.title.go.to.routine.definition", (Object[])new Object[0]), checkOnly ? JBIterable.empty() : OraNavigationHelper.findBodyRoutines(def));
        }
        return null;
    }

    private static boolean isBlockRoutineDefinition(@NotNull DasObject object) {
        if (object == null) {
            OraNavigationHelper.$$$reportNull$$$0(2);
        }
        return object instanceof SqlRoutineDefinition && ((SqlRoutineDefinition)object).getBody().isEmpty() && !(SqlImplUtil.sqlParent((PsiElement)((SqlRoutineDefinition)object)) instanceof SqlFile);
    }

    @NotNull
    private static JBIterable<? extends DasObject> findBodies(@NotNull DasObject element) {
        JBIterable bodies;
        if (element == null) {
            OraNavigationHelper.$$$reportNull$$$0(3);
        }
        if ((bodies = element.getDasChildren(ObjectKind.BODY)).isNotEmpty()) {
            JBIterable jBIterable = bodies;
            if (jBIterable == null) {
                OraNavigationHelper.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        JBIterable objects = SqlImplUtil.unwrapFake((DasObject)element);
        bodies = objects.flatten(e -> e.getDasChildren(ObjectKind.BODY));
        if (bodies.isEmpty()) {
            bodies = objects.filter(PsiElement.class).flatten(o -> SqlNavigationUtils.findRelatedDbElements((PsiElement)o, (boolean)true)).flatten(e -> e.getDasChildren(ObjectKind.BODY));
        }
        JBIterable jBIterable = bodies;
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    private static JBIterable<? extends DasObject> findBodyRoutines(@NotNull DasObject element) {
        Condition<DasObject> condition;
        DasObject parent;
        ObjectKind kind;
        if (element == null) {
            OraNavigationHelper.$$$reportNull$$$0(6);
        }
        ObjectKind objectKind = kind = (parent = element.getDasParent()) == null ? null : parent.getKind();
        if (kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.PACKAGE) {
            condition = DbSqlUtilCore.byName((DasObject)element, null, (CasingProvider)DbImplUtilCore.getCasingProvider((DasObject)element));
            JBIterable result = OraNavigationHelper.findBodies(parent).flatten(arg_0 -> OraNavigationHelper.lambda$findBodyRoutines$3((Condition)condition, element, arg_0));
            if (result.isNotEmpty()) {
                return result;
            }
        }
        if (element instanceof SqlRoutineDefinition && ((SqlRoutineDefinition)element).getBody().isEmpty() && !(SqlImplUtil.sqlParent((PsiElement)((SqlRoutineDefinition)element)) instanceof SqlFile)) {
            condition = OraNavigationHelper.routineSpecCondition((DasRoutine)element);
            return SqlImplUtil.siblings((PsiElement)((SqlRoutineDefinition)element)).skip(1).filter(DasRoutine.class).filter(condition);
        }
        return JBIterable.empty();
    }

    @NotNull
    private static JBIterable<? extends DasObject> findBodySpecifications(@NotNull DasObject body) {
        DasObject parent;
        JBIterable pkgs;
        if (body == null) {
            OraNavigationHelper.$$$reportNull$$$0(7);
        }
        if ((pkgs = SqlImplUtil.unwrapFake((DasObject)(parent = body.getDasParent()))).isEmpty() && body instanceof PsiElement) {
            pkgs = SqlNavigationUtils.findRelatedDbElements((PsiElement)((PsiElement)body), (boolean)true).map(DbElement::getParent);
        }
        JBIterable jBIterable = pkgs;
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    private static boolean matchArgumentTypes(@NotNull DasArgument arg1, @NotNull DasArgument arg2, @NotNull CasingProvider casingProvider) {
        if (arg1 == null) {
            OraNavigationHelper.$$$reportNull$$$0(9);
        }
        if (arg2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(10);
        }
        if (casingProvider == null) {
            OraNavigationHelper.$$$reportNull$$$0(11);
        }
        if (!(arg1 instanceof SqlParameterDefinition) || !(arg2 instanceof SqlParameterDefinition)) {
            return false;
        }
        SqlTypeElement type1 = ((SqlParameterDefinition)arg1).getTypeElement();
        SqlTypeElement type2 = ((SqlParameterDefinition)arg2).getTypeElement();
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        return OraNavigationHelper.matchTypeElements(type1, type2, casingProvider);
    }

    private static boolean matchTypeElements(@NotNull SqlTypeElement type1, @NotNull SqlTypeElement type2, @NotNull CasingProvider casingProvider) {
        if (type1 == null) {
            OraNavigationHelper.$$$reportNull$$$0(12);
        }
        if (type2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(13);
        }
        if (casingProvider == null) {
            OraNavigationHelper.$$$reportNull$$$0(14);
        }
        List children1 = SqlImplUtil.sqlChildrenNoWS((PsiElement)type1).toList();
        List children2 = SqlImplUtil.sqlChildrenNoWS((PsiElement)type2).toList();
        if (children1.size() != children2.size()) {
            return false;
        }
        for (int i = 0; i < children1.size(); ++i) {
            PsiElement child1 = (PsiElement)children1.get(i);
            PsiElement child2 = (PsiElement)children2.get(i);
            if (child1 instanceof SqlReferenceExpression) {
                SqlReferenceExpression ref1 = (SqlReferenceExpression)child1;
                if (!(child2 instanceof SqlReferenceExpression)) {
                    return false;
                }
                SqlReferenceExpression ref2 = (SqlReferenceExpression)child2;
                NameChecker checker = new NameChecker(ref1.getName(), ref1.isQuoted(), casingProvider, (SqlLanguageDialect)SqlImplUtil.getSqlDialectSafe((PsiElement)type1));
                if (!checker.checkName((DasNamed)ref2, null)) {
                    return false;
                }
            }
            if (child1 instanceof SqlTypeElement) {
                if (!(child2 instanceof SqlTypeElement)) {
                    return false;
                }
                if (!OraNavigationHelper.matchTypeElements((SqlTypeElement)child1, (SqlTypeElement)child2, casingProvider)) {
                    return false;
                }
            }
            if (child1.getText().equalsIgnoreCase(child2.getText())) continue;
            return false;
        }
        return true;
    }

    private static Condition<DasObject> routineSpecCondition(@NotNull DasRoutine routine) {
        if (routine == null) {
            OraNavigationHelper.$$$reportNull$$$0(15);
        }
        CasingProvider casingProvider = DbImplUtilCore.getCasingProvider((DasObject)routine);
        Condition nameCondition = DbSqlUtilCore.byName((DasObject)routine, null, (CasingProvider)casingProvider);
        Collection args = ContainerUtil.toCollection((Iterable)routine.getArguments());
        List argConditions = ContainerUtil.map((Collection)args, arg -> Conditions.and((Condition)DbSqlUtilCore.byName((DasObject)arg, null, (CasingProvider)DbImplUtilCore.getCasingProvider((DasObject)arg)), o -> o instanceof DasArgument && ((DasArgument)o).getArgumentDirection() == arg.getArgumentDirection() && OraNavigationHelper.matchArgumentTypes((DasArgument)o, arg, casingProvider)));
        return obj -> {
            if (!(obj instanceof DasRoutine)) {
                return false;
            }
            if (!nameCondition.value(obj)) {
                return false;
            }
            Collection currentArgs = ContainerUtil.toCollection((Iterable)((DasRoutine)obj).getArguments());
            if (currentArgs.size() != argConditions.size()) {
                return false;
            }
            int i = 0;
            for (DasArgument currentArg : currentArgs) {
                Condition argCondition;
                if ((argCondition = (Condition)argConditions.get(i++)).value((Object)currentArg)) continue;
                return false;
            }
            return true;
        };
    }

    @NotNull
    private static JBIterable<? extends DasObject> findRoutineSpecifications(@NotNull DasObject routine) {
        DasObject body;
        if (routine == null) {
            OraNavigationHelper.$$$reportNull$$$0(16);
        }
        if (!(routine instanceof DasRoutine)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                OraNavigationHelper.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }
        if (routine instanceof SqlRoutineDefinition && !(SqlImplUtil.sqlParent((PsiElement)((SqlRoutineDefinition)routine)) instanceof SqlFile)) {
            Condition<DasObject> condition = OraNavigationHelper.routineSpecCondition((DasRoutine)routine);
            JBIterable result = SqlImplUtil.revSiblings((PsiElement)((SqlRoutineDefinition)routine)).skip(1).filter(DasRoutine.class).filter(condition);
            if (result.isNotEmpty()) {
                JBIterable jBIterable = result;
                if (jBIterable == null) {
                    OraNavigationHelper.$$$reportNull$$$0(18);
                }
                return jBIterable;
            }
        }
        if ((body = routine.getDasParent()) != null && body.getKind() == ObjectKind.BODY) {
            Condition condition = DbSqlUtilCore.byName((DasObject)routine, null, (CasingProvider)DbImplUtilCore.getCasingProvider((DasObject)routine));
            JBIterable result = OraNavigationHelper.findBodySpecifications(body).flatten(b -> b.getDasChildren(ObjectKind.ROUTINE).filter(condition));
            if (result.isNotEmpty()) {
                JBIterable jBIterable = result;
                if (jBIterable == null) {
                    OraNavigationHelper.$$$reportNull$$$0(19);
                }
                return jBIterable;
            }
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    private static boolean hasSuperTypes(@NotNull DasObject type) {
        if (type == null) {
            OraNavigationHelper.$$$reportNull$$$0(21);
        }
        if (type instanceof SqlCreateTypeStatementImpl) {
            return ((SqlCreateTypeStatementImpl)type).getSuperTypeReference() != null;
        }
        if (type instanceof DasUserDefinedType) {
            return ((DasUserDefinedType)type).getSuperType() != null;
        }
        return false;
    }

    @NotNull
    private static JBIterable<? extends DasObject> findSuperTypes(@NotNull DasObject type) {
        DasUserDefinedType tp;
        DasUserDefinedType st;
        if (type == null) {
            OraNavigationHelper.$$$reportNull$$$0(22);
        }
        DasUserDefinedType dasUserDefinedType = st = (tp = (DasUserDefinedType)ObjectUtils.tryCast((Object)type, DasUserDefinedType.class)) == null ? null : tp.getSuperType();
        if (st == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                OraNavigationHelper.$$$reportNull$$$0(23);
            }
            return jBIterable;
        }
        JBIterable supers = SqlImplUtil.unwrapFake((DasObject)st);
        if (supers.isEmpty() && st instanceof PsiElement) {
            supers = SqlNavigationUtils.findRelatedDbElements((PsiElement)((PsiElement)st), (boolean)true);
        }
        JBIterable jBIterable = supers;
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    private static /* synthetic */ Iterable lambda$findBodyRoutines$3(Condition condition, DasObject element, DasObject b) {
        DbElement db = (DbElement)ObjectUtils.tryCast((Object)b, DbElement.class);
        if (db == null) {
            return b.getDasChildren(ObjectKind.ROUTINE).filter(condition);
        }
        VirtualFile file = DbTargetUtil.getContainingFile((DbElement)db, (boolean)false);
        if (file == null) {
            return JBIterable.empty();
        }
        return JBIterable.of((Object)DbTargetUtil.calcTarget((Project)db.getProject(), (VirtualFile)file, (DasObject)element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 17, 18, 19, 20, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/OraNavigationHelper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg2";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/OraNavigationHelper";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findBodies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findBodySpecifications";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findRoutineSpecifications";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSuperDefinitions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findDefinitions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isBlockRoutineDefinition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findBodies";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBodyRoutines";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBodySpecifications";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchArgumentTypes";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchTypeElements";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "routineSpecCondition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findRoutineSpecifications";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasSuperTypes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findSuperTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8, 17, 18, 19, 20, 23, 24 -> new IllegalStateException(string);
        };
    }
}

