/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SpringCustomNamespaces {
    public static final ExtensionPointName<SpringCustomNamespaces> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.customNamespaces");

    public abstract NamespacePolicies getNamespacePolicies();

    public void registerExtensions(DomExtensionsRegistrar registrar) {
    }

    public int getModelVersion() {
        return 0;
    }

    public int getStubVersion() {
        return 0;
    }

    public static class NamespacePolicies {
        private final Map<String, List<String>> policies = new HashMap<String, List<String>>();

        public static NamespacePolicies simple(String key, String namespace) {
            NamespacePolicies policies = new NamespacePolicies();
            return policies.add(key, namespace);
        }

        public NamespacePolicies add(String key, String ... namespaces) {
            this.policies.put(key, Arrays.asList(namespaces));
            return this;
        }

        public boolean isRegistered(String namespace) {
            for (List<String> namespaces : this.policies.values()) {
                if (!namespaces.contains(namespace)) continue;
                return true;
            }
            return false;
        }

        public void process(DomFileDescription domFileDescription) {
            for (Map.Entry<String, List<String>> entry : this.policies.entrySet()) {
                domFileDescription.registerNamespacePolicy(entry.getKey(), ArrayUtilRt.toStringArray((Collection)entry.getValue()));
            }
        }
    }
}

