/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.Nullable;

public class CustomConverterRegistry {
    private static final CustomConverterRegistry ourInstance = new CustomConverterRegistry();

    public static CustomConverterRegistry getRegistry() {
        return ourInstance;
    }

    @Nullable
    public Converter<?> getCustomConverter(Class aClass, GenericDomValue context) {
        for (Provider provider : Provider.EXTENSION_POINT_NAME.getExtensionList()) {
            if (!aClass.equals(provider.getConverterClass()) || !provider.value(context)) continue;
            return provider.getConverter();
        }
        return null;
    }

    public static interface Provider
    extends Condition<GenericDomValue> {
        public static final ExtensionPointName<Provider> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.spring.customConverterProvider");

        public Converter getConverter();

        public Class getConverterClass();
    }
}

