/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.util.JSCommonRefactoringUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNestedIfJoinLinesHandler
implements JoinRawLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        if (document == null) {
            JSNestedIfJoinLinesHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JSNestedIfJoinLinesHandler.$$$reportNull$$$0(1);
        }
        return -1;
    }

    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        JSExpression rOperand;
        JSExpression condition;
        JSBlockStatement blockStatement;
        if (document == null) {
            JSNestedIfJoinLinesHandler.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSNestedIfJoinLinesHandler.$$$reportNull$$$0(3);
        }
        if (start == 0) {
            return -1;
        }
        LeafPsiElement elementAtStartLineEnd = (LeafPsiElement)ObjectUtils.tryCast((Object)file.findElementAt(start - 1), LeafPsiElement.class);
        if (elementAtStartLineEnd == null) {
            return -1;
        }
        JSIfStatement outerIf = null;
        if (elementAtStartLineEnd.getElementType().equals(JSTokenTypes.RPAR)) {
            outerIf = (JSIfStatement)ObjectUtils.tryCast((Object)elementAtStartLineEnd.getParent(), JSIfStatement.class);
        } else if (elementAtStartLineEnd.getElementType().equals(JSTokenTypes.LBRACE) && (blockStatement = (JSBlockStatement)ObjectUtils.tryCast((Object)elementAtStartLineEnd.getParent(), JSBlockStatement.class)) != null && ((outerIf = (JSIfStatement)ObjectUtils.tryCast((Object)blockStatement.getParent(), JSIfStatement.class)) == null || outerIf.getThenBranch() != blockStatement)) {
            return -1;
        }
        if (outerIf == null || !JSNestedIfJoinLinesHandler.areNestedIfs(outerIf)) {
            return -1;
        }
        JSStatement newStatement = JSNestedIfJoinLinesHandler.mergeNestedIfs(outerIf);
        if (newStatement == null) {
            return -1;
        }
        int caretOffset = newStatement.getTextRange().getStartOffset();
        if (newStatement instanceof JSIfStatement && (condition = ((JSIfStatement)newStatement).getCondition()) instanceof JSBinaryExpression && (rOperand = ((JSBinaryExpression)condition).getROperand()) != null) {
            caretOffset = rOperand.getTextRange().getStartOffset();
        }
        return caretOffset;
    }

    public static boolean areNestedIfs(@NotNull JSIfStatement parentStatement) {
        if (parentStatement == null) {
            JSNestedIfJoinLinesHandler.$$$reportNull$$$0(4);
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)parentStatement)) {
            return false;
        }
        JSStatement thenBranch = ControlFlowUtils.stripBraces((JSStatement)parentStatement.getThenBranch());
        JSStatement elseBranch = ControlFlowUtils.stripBraces((JSStatement)parentStatement.getElseBranch());
        if (!(thenBranch instanceof JSIfStatement) || elseBranch != null) {
            return false;
        }
        return ((JSIfStatement)thenBranch).getElseBranch() == null;
    }

    @Nullable
    public static JSStatement mergeNestedIfs(@NotNull JSIfStatement outerIf) {
        JSIfStatement childStatement;
        if (outerIf == null) {
            JSNestedIfJoinLinesHandler.$$$reportNull$$$0(5);
        }
        if ((childStatement = (JSIfStatement)ControlFlowUtils.stripBraces((JSStatement)outerIf.getThenBranch())) == null) {
            return null;
        }
        JSExpression childCondition = childStatement.getCondition();
        if (childCondition == null) {
            return null;
        }
        JSExpression parentCondition = outerIf.getCondition();
        if (parentCondition == null) {
            return null;
        }
        String childConditionText = JSParenthesesUtils.getParenthesized(childCondition, 14);
        String parentConditionText = JSParenthesesUtils.getParenthesized(parentCondition, 14);
        JSStatement childThenBranch = (JSStatement)childStatement.getThenBranch();
        if (childThenBranch == null) {
            return null;
        }
        ASTNode lPar = outerIf.getNode().findChildByType(JSTokenTypes.LPAR);
        if (lPar == null) {
            return null;
        }
        String ifStatementPrefix = outerIf.getText().substring(0, lPar.getStartOffsetInParent() + 1);
        String statement = ifStatementPrefix + parentConditionText + " && " + childConditionText + ") " + childThenBranch.getText();
        return JSCommonRefactoringUtil.replaceStatementAndReformat(outerIf, statement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerIf";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/editing/JSNestedIfJoinLinesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryJoinLines";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryJoinRawLines";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "areNestedIfs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeNestedIfs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

