/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocElementType;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeImpl;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeValueImpl;
import com.intellij.lang.javascript.util.JSCommonRefactoringUtil;
import com.intellij.lang.typescript.BasicTypeScriptElementTypes;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptTypedHandler
extends TypedHandlerDelegate {
    private boolean myJavaScriptLTTyped;

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(2);
        }
        if (!JavaScriptTypedHandler.charOfInterest(charTyped)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(3);
            }
            return result;
        }
        if (!this.isJSDialect(editor, file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        if (JavaScriptTypedHandler.isNotApplicableByLexer(charTyped, editor, offset)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(5);
            }
            return result;
        }
        if (file.getContext() == null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
        return JavaScriptTypedHandler.checkAutoPopupByChar(charTyped, project, editor, file, offset);
    }

    @NotNull
    private static TypedHandlerDelegate.Result checkAutoPopupByChar(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (project == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(8);
        }
        AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)project);
        PsiElement at = file.findElementAt(offset);
        if (charTyped == '/') {
            if (at instanceof LeafPsiElement && ((LeafPsiElement)at).getElementType() == JSTokenTypes.STRING_LITERAL && JavaScriptTypedHandler.isImportOrRequireCall(at = at.getParent())) {
                autoPopupController.scheduleAutoPopup(editor);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaScriptTypedHandler.$$$reportNull$$$0(9);
                }
                return result;
            }
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(10);
            }
            return result;
        }
        if (charTyped == ' ' || charTyped == ',') {
            if (at != null && at.getParent() instanceof JSArgumentList) {
                autoPopupController.autoPopupParameterInfo(editor, null);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaScriptTypedHandler.$$$reportNull$$$0(11);
                }
                return result;
            }
            if (charTyped == ',') {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaScriptTypedHandler.$$$reportNull$$$0(12);
                }
                return result;
            }
        }
        if (charTyped == '{') {
            if (at != null && at.getParent() instanceof JSXmlAttributeImpl) {
                autoPopupController.autoPopupParameterInfo(editor, null);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaScriptTypedHandler.$$$reportNull$$$0(13);
                }
                return result;
            }
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(14);
            }
            return result;
        }
        if (charTyped == '\'' || charTyped == '\"') {
            autoPopupController.scheduleAutoPopup(editor);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(15);
            }
            return result;
        }
        if (at != null) {
            if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{PsiComment.class, JSLiteralExpression.class, JSConditionalExpression.class}) != null || at.getParent() instanceof JSSwitchStatement) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    JavaScriptTypedHandler.$$$reportNull$$$0(16);
                }
                return result;
            }
            if (at instanceof PsiWhiteSpace) {
                at = PsiTreeUtil.prevLeaf((PsiElement)at);
            }
            if (at == null || PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{JSConditionalExpression.class}) != null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    JavaScriptTypedHandler.$$$reportNull$$$0(17);
                }
                return result;
            }
        }
        if (charTyped == '<') {
            Document document = editor.getDocument();
            if (offset > 0 && offset <= document.getTextLength() && document.getCharsSequence().charAt(offset - 1) != '.') {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    JavaScriptTypedHandler.$$$reportNull$$$0(18);
                }
                return result;
            }
        }
        autoPopupController.scheduleAutoPopup(editor);
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
        if (result == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(19);
        }
        return result;
    }

    private static boolean isImportOrRequireCall(@Nullable PsiElement at) {
        if (at == null) {
            return false;
        }
        if (at instanceof ES6FromClause || at instanceof ES6ImportDeclaration || at.getParent() instanceof ES6ImportCall) {
            return true;
        }
        if (!(at instanceof JSLiteralExpression)) {
            return false;
        }
        PsiElement parent = at.getParent();
        if (parent == null) {
            return false;
        }
        PsiElement callCandidate = parent.getParent();
        return callCandidate instanceof JSCallExpression && ((JSCallExpression)callCandidate).isRequireCall();
    }

    private static boolean isNotApplicableByLexer(char charTyped, Editor editor, int offset) {
        if (charTyped == ' ') {
            Document document = editor.getDocument();
            CharSequence charSequence = document.getCharsSequence();
            if (offset > 3 && offset <= document.getTextLength() && (charSequence.charAt(offset - 1) != 'w' || charSequence.charAt(offset - 2) != 'e' || charSequence.charAt(offset - 3) != 'n') && charSequence.charAt(offset - 1) != ':' && charSequence.charAt(offset - 1) != ',') {
                return true;
            }
        }
        if (offset == 0) {
            return true;
        }
        HighlighterIterator iterator2 = JavaScriptTypedHandler.createHighlighterIterator(editor, offset - 1);
        IElementType tokenType = iterator2.getTokenType();
        return JSElementTypes.COMMENTS.contains(tokenType) || tokenType instanceof JSDocElementType || StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(tokenType) || JavaScriptTypedHandler.isStringLiteralOrXmlValue(tokenType) && charTyped != '/';
    }

    private static boolean isStringLiteralOrXmlValue(IElementType tokenType) {
        return StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(tokenType) || tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER || tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
    }

    private static boolean charOfInterest(char charTyped) {
        return charTyped == '<' || charTyped == ' ' || charTyped == ',' || charTyped == '.' || charTyped == '/' || charTyped == '$' || charTyped == '#' || charTyped == '{' || charTyped == '\"' || charTyped == '\'';
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        int offset;
        JSParameterListElement param;
        int offset2;
        PsiElement at;
        DialectOptionHolder holder;
        if (project == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(21);
        }
        if (file == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(22);
        }
        if (fileType == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(23);
        }
        if (!this.isJSDialect(editor, file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(24);
            }
            return result;
        }
        boolean bl = this.myJavaScriptLTTyped = '<' == c && !(file instanceof HtmlFileImpl) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && (holder = DialectDetector.dialectOfElement((PsiElement)file)) != null && holder.hasFeature(JSLanguageFeature.GENERICS) && JavaScriptTypedHandler.shouldMatchGenericBraces(editor, false);
        if ('>' == c && !(file instanceof HtmlFileImpl) && (holder = DialectDetector.dialectOfElement((PsiElement)file)) != null) {
            WebEditorOptions webEditorOptions;
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
                if (holder.hasFeature(JSLanguageFeature.GENERICS) && TypedHandlerUtil.handleGenericGT((Editor)editor, (IElementType)JSTokenTypes.LT, (IElementType)JSTokenTypes.GT, (TokenSet)Holder.INVALID_INSIDE_REFERENCE)) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        JavaScriptTypedHandler.$$$reportNull$$$0(25);
                    }
                    return result;
                }
                if (JavaScriptTypedHandler.isWithinJSDoc(editor, false) && TypedHandlerUtil.handleGenericGT((Editor)editor, (IElementType)JSDocTokenTypes.DOC_LT, (IElementType)JSDocTokenTypes.DOC_GT, (TokenSet)Holder.INVALID_INSIDE_JSDOC_GENERIC)) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        JavaScriptTypedHandler.$$$reportNull$$$0(26);
                    }
                    return result;
                }
            }
            if ((webEditorOptions = WebEditorOptions.getInstance()) != null && webEditorOptions.isAutomaticallyInsertClosingTag() && holder.hasFeature(JSLanguageFeature.E4X)) {
                IElementType tokenType;
                PsiElement previousElement;
                PsiElement element;
                FileViewProvider provider = file.getViewProvider();
                int offset3 = editor.getCaretModel().getOffset();
                if (offset3 < editor.getDocument().getTextLength() && (element = provider.findElementAt(offset3, XMLLanguage.class)) instanceof PsiWhiteSpace && (previousElement = provider.findElementAt(offset3 - 1, XMLLanguage.class)) instanceof XmlToken && (tokenType = ((XmlToken)previousElement).getTokenType()) == XmlTokenType.XML_START_TAG_START) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"</>", (boolean)false, (int)0);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
                    if (result == null) {
                        JavaScriptTypedHandler.$$$reportNull$$$0(27);
                    }
                    return result;
                }
            }
        }
        if (c == '.' && (at = JavaScriptTypedHandler.getElementAtOffset(file, offset2 = editor.getCaretModel().getOffset())) != null && at.getParent().getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) && !JavaScriptTypedHandler.isNotApplicableByLexer(c, editor, offset2)) {
            AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
        }
        if (c == ';' && JavaScriptTypedHandler.handleSemicolon(editor)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(28);
            }
            return result;
        }
        if (c == '{' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            LeafPsiElement nextLeaf;
            PsiElement skipWhitespace;
            int offset4 = editor.getCaretModel().getOffset();
            at = JavaScriptTypedHandler.getElementAtOffset(file, offset4);
            if (JavaScriptTypedHandler.isAtEmptyAttributeValue(at)) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"{}", (boolean)false, (int)1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaScriptTypedHandler.$$$reportNull$$$0(29);
                }
                return result;
            }
            PsiElement psiElement = skipWhitespace = at instanceof PsiWhiteSpace ? at.getNextSibling() : at;
            if (skipWhitespace instanceof LeafPsiElement && (nextLeaf = (LeafPsiElement)skipWhitespace).getElementType() == JSTokenTypes.XML_RBRACE && at.getParent() instanceof JSEmbeddedContent) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"{}", (boolean)false, (int)1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaScriptTypedHandler.$$$reportNull$$$0(30);
                }
                return result;
            }
        }
        if (c == ',' && (param = JavaScriptTypedHandler.getSingleArgArrowFunctionParamIfPresent(at = JavaScriptTypedHandler.getElementAtOffset(file, offset = editor.getCaretModel().getOffset()))) != null) {
            int paramNameOffset = param.getTextLength();
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)(-paramNameOffset));
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"(", (boolean)false);
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)paramNameOffset);
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)",)", (boolean)false, (int)1);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(31);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = super.beforeCharTyped(c, project, editor, file, fileType);
        if (result == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(32);
        }
        return result;
    }

    private static boolean isAtEmptyAttributeValue(@Nullable PsiElement at) {
        XmlToken eq;
        if (at == null) {
            return false;
        }
        IElementType atElementType = at.getNode().getElementType();
        if (JSKeywordSets.PROPERTY_NAMES.contains(atElementType) || JSTokenTypes.RBRACES.contains(atElementType)) {
            return false;
        }
        PsiElement atPrev = at.getPrevSibling();
        if (atPrev instanceof JSXmlAttributeImpl) {
            JSXmlAttributeImpl attribute = (JSXmlAttributeImpl)atPrev;
            PsiElement psiElement = attribute.getLastChild();
            if (!(psiElement instanceof JSXmlAttributeValueImpl)) {
                return false;
            }
            JSXmlAttributeValueImpl attributeValue = (JSXmlAttributeValueImpl)psiElement;
            if (attributeValue.getTextLength() != 0) {
                return false;
            }
            atPrev = attributeValue.getPrevSibling();
        }
        return atPrev instanceof XmlToken && (eq = (XmlToken)atPrev).getTokenType() == JSTokenTypes.XML_ATTR_EQUAL;
    }

    public static boolean shouldMatchGenericBraces(@NotNull Editor editor, boolean isBackspace) {
        IElementType tokenType;
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(33);
        }
        int offset = editor.getCaretModel().getOffset();
        if (isBackspace) {
            --offset;
        }
        if (TypedHandlerUtil.isAfterClassLikeIdentifierOrDot((int)offset, (Editor)editor, (IElementType)JSTokenTypes.DOT, (IElementType)JSTokenTypes.IDENTIFIER, (boolean)false)) {
            return true;
        }
        HighlighterIterator iterator2 = editor.getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            return false;
        }
        if (offset != iterator2.getEnd() && iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        if ((tokenType = iterator2.getTokenType()) != JSTokenTypes.IDENTIFIER) {
            return false;
        }
        iterator2.advance();
        if (isBackspace) {
            if (iterator2.atEnd() || iterator2.getTokenType() != JSTokenTypes.LT) {
                return false;
            }
            iterator2.advance();
            if (iterator2.atEnd() || iterator2.getTokenType() != JSTokenTypes.GT) {
                return false;
            }
            iterator2.advance();
        }
        return !iterator2.atEnd() && iterator2.getTokenType() == JSTokenTypes.LPAR;
    }

    public static boolean isWithinJSDoc(@NotNull Editor editor, boolean isBackspace) {
        HighlighterIterator iterator2;
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(34);
        }
        int offset = editor.getCaretModel().getOffset();
        if (isBackspace) {
            --offset;
        }
        if ((iterator2 = editor.getHighlighter().createIterator(offset)).atEnd()) {
            return false;
        }
        IElementType tokenType = iterator2.getTokenType();
        return JSDocTokenTypes.ALL.contains(tokenType);
    }

    private static boolean handleSemicolon(Editor editor) {
        CharSequence sequence;
        int offset = editor.getCaretModel().getOffset();
        if (offset >= (sequence = editor.getDocument().getCharsSequence()).length()) {
            return false;
        }
        char charAt = sequence.charAt(offset);
        if (charAt != ';') {
            return false;
        }
        HighlighterIterator hi = editor.getHighlighter().createIterator(offset);
        if (hi.atEnd() || hi.getTokenType() != JSTokenTypes.SEMICOLON) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(35);
        }
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(36);
        }
        if (file == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(37);
        }
        if (!this.isJSDialect(editor, file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(38);
            }
            return result;
        }
        if (this.myJavaScriptLTTyped) {
            this.myJavaScriptLTTyped = false;
            TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)JSTokenTypes.LT, (IElementType)JSTokenTypes.GT, (TokenSet)Holder.INVALID_INSIDE_REFERENCE);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(39);
            }
            return result;
        }
        if (c == '<' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            HighlighterIterator iterator2 = editor.getHighlighter().createIterator(editor.getCaretModel().getOffset());
            iterator2.retreat();
            if (!iterator2.atEnd() && iterator2.getTokenType() == JSDocTokenTypes.DOC_LT) {
                TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)JSDocTokenTypes.DOC_LT, (IElementType)JSDocTokenTypes.DOC_GT, (TokenSet)Holder.INVALID_INSIDE_JSDOC_GENERIC);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaScriptTypedHandler.$$$reportNull$$$0(40);
                }
                return result;
            }
        }
        if (!JavaScriptTypedHandler.isJSDialectAtCaret(editor, file)) {
            TypedHandlerDelegate.Result result = super.charTyped(c, project, editor, file);
            if (result == null) {
                JavaScriptTypedHandler.$$$reportNull$$$0(41);
            }
            return result;
        }
        if (c == ',' || c == ':' || c == '.' && JavaScriptTypedHandler.isIndentChainedCalls(file)) {
            PsiElement parent;
            int offset = editor.getCaretModel().getOffset();
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement at = file.findElementAt(offset - 1);
            PsiElement psiElement = parent = at != null ? at.getParent() : null;
            if (parent != null) {
                int indentPos = -1;
                IElementType parentType = parent.getNode().getElementType();
                if (BasicTypeScriptElementTypes.VAR_STATEMENTS.contains(parentType) || parentType == JSElementTypes.REFERENCE_EXPRESSION) {
                    indentPos = at.getTextOffset() - 1;
                } else if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(parentType)) {
                    indentPos = parent.getTextOffset() - 1;
                }
                if (indentPos >= 0 && JavaScriptTypedHandler.isAfterLineStart(indentPos, editor.getDocument())) {
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, indentPos);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        JavaScriptTypedHandler.$$$reportNull$$$0(42);
                    }
                    return result;
                }
            }
        }
        TypedHandlerDelegate.Result result = super.charTyped(c, project, editor, file);
        if (result == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(43);
        }
        return result;
    }

    @NotNull
    public static HighlighterIterator createHighlighterIterator(@NotNull Editor editor, int offset) {
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(44);
        }
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(offset);
        if (highlighterIterator == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(45);
        }
        return highlighterIterator;
    }

    private static boolean isJSDialectAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(46);
        }
        if (file == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(47);
        }
        int offset = editor.getCaretModel().getOffset();
        return JavaScriptTypedHandler.isJSDialectAtOffset(file, offset);
    }

    public static boolean isJSDialectAtOffset(@NotNull PsiFile file, int offset) {
        PsiElement at;
        if (file == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(48);
        }
        if ((at = JavaScriptTypedHandler.getElementAtOffset(file, offset)) == null) {
            return false;
        }
        Language language = PsiUtilCore.findLanguageFromElement((PsiElement)at);
        return language instanceof JSLanguageDialect;
    }

    @Nullable
    private static PsiElement getElementAtOffset(@NotNull PsiFile file, int offset) {
        PsiElement prevElement;
        PsiElement element;
        if (file == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(49);
        }
        Object object = offset < file.getTextLength() ? file.findElementAt(offset) : (element = offset > 0 ? file.findElementAt(offset - 1) : null);
        if (PsiUtilCore.getElementType((PsiElement)element) == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && offset > 0 && (prevElement = file.findElementAt(offset - 1)) != null) {
            return prevElement;
        }
        return element;
    }

    private static boolean isIndentChainedCalls(@NotNull PsiFile file) {
        if (file == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(50);
        }
        JSCodeStyleSettings settings = (JSCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, JSCodeStyleSettings.class);
        return settings.INDENT_CHAINED_CALLS;
    }

    private static boolean isAfterLineStart(int indentPos, @NotNull Document document) {
        if (document == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(51);
        }
        int firstNonSpace = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)indentPos, (String)" \t");
        return document.getCharsSequence().charAt(firstNonSpace) == '\n';
    }

    protected boolean isJSDialect(@Nullable Editor editor, @Nullable PsiFile file) {
        return editor != null && (file instanceof JSFile || file != null && JavaScriptTypedHandler.isJSDialectAtCaret(editor, file));
    }

    @Nullable
    private static JSParameterListElement getSingleArgArrowFunctionParamIfPresent(@Nullable PsiElement elem) {
        JSParameterList parameterList;
        JSFunctionExpression funcExpr;
        PsiElement parent;
        PsiElement psiElement = parent = elem != null ? elem.getParent() : null;
        if (!(parent instanceof JSFunctionExpression) || !(funcExpr = (JSFunctionExpression)parent).isArrowFunction()) {
            return null;
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)elem);
        if (!(prev instanceof JSParameterList) || (parameterList = (JSParameterList)prev) != funcExpr.getParameterList()) {
            return null;
        }
        if (!JSCommonRefactoringUtil.noBracesAroundSingleParameter(parameterList)) {
            return null;
        }
        JSParameterListElement[] params = parameterList.getParameters();
        if (params.length == 1) {
            return params[0];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 24, 25, 26, 27, 28, 29, 30, 31, 32, 38, 39, 40, 41, 42, 43, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 21: 
            case 33: 
            case 34: 
            case 36: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: 
            case 22: 
            case 37: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JavaScriptTypedHandler";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JavaScriptTypedHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopupByChar";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighterIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopupByChar";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "shouldMatchGenericBraces";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isWithinJSDoc";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighterIterator";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isJSDialectAtCaret";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isJSDialectAtOffset";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtOffset";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isIndentChainedCalls";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isAfterLineStart";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 24, 25, 26, 27, 28, 29, 30, 31, 32, 38, 39, 40, 41, 42, 43, 45 -> new IllegalStateException(string);
        };
    }

    public static final class Holder {
        public static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.SEMICOLON, JSTokenTypes.LBRACE, JSTokenTypes.RBRACE});
        public static final TokenSet INVALID_INSIDE_JSDOC_GENERIC = TokenSet.create((IElementType[])new IElementType[]{JSDocTokenTypes.DOC_COMMENT_END});
    }
}

