/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.chainedMethods;

import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.javascript.formatter.SpacingStrategy;
import com.intellij.lang.javascript.formatter.chainedMethods.CallChainBlock;
import com.intellij.lang.javascript.formatter.chainedMethods.CallChainDotBlock;
import com.intellij.lang.javascript.formatter.chainedMethods.ParameterListBlock;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainedBlocksSpacingStrategy
implements SpacingStrategy {
    private final CommonCodeStyleSettings myLangSettings;

    public ChainedBlocksSpacingStrategy(@NotNull CommonCodeStyleSettings langSettings) {
        if (langSettings == null) {
            ChainedBlocksSpacingStrategy.$$$reportNull$$$0(0);
        }
        this.myLangSettings = langSettings;
    }

    @Override
    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            ChainedBlocksSpacingStrategy.$$$reportNull$$$0(1);
        }
        if (child1 instanceof CallChainBlock && child2 instanceof CallChainBlock) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myLangSettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (child2 instanceof ParameterListBlock) {
            int spaces = this.myLangSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.myLangSettings.KEEP_LINE_BREAKS, (int)this.myLangSettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (child1 instanceof CallChainDotBlock) {
            return this.createDotSpacing(this.isDotOnNewLine());
        }
        if (child2 instanceof CallChainDotBlock) {
            return this.createDotSpacing(!this.isDotOnNewLine());
        }
        return null;
    }

    private Spacing createDotSpacing(boolean removeLineBreaks) {
        return Spacing.createSpacing((int)0, (int)0, (int)0, (!removeLineBreaks && this.myLangSettings.KEEP_LINE_BREAKS ? 1 : 0) != 0, (int)(removeLineBreaks ? 0 : this.myLangSettings.KEEP_BLANK_LINES_IN_CODE));
    }

    protected boolean isDotOnNewLine() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/chainedMethods/ChainedBlocksSpacingStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

