/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.highlighting.BraceMatcherTerminationAspect;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSBraceMatcher;", "Lcom/intellij/lang/PairedBraceMatcher;", "Lcom/intellij/codeInsight/highlighting/BraceMatcherTerminationAspect;", "<init>", "()V", "getPairs", "", "Lcom/intellij/lang/BracePair;", "()[Lcom/intellij/lang/BracePair;", "isPairedBracesAllowedBeforeType", "", "lbraceType", "Lcom/intellij/psi/tree/IElementType;", "tokenType", "getCodeConstructStart", "", "file", "Lcom/intellij/psi/PsiFile;", "openingBraceOffset", "shouldStopMatch", "forward", "braceType", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "Companion", "intellij.javascript.common"})
public final class JSBraceMatcher
implements PairedBraceMatcher,
BraceMatcherTerminationAspect {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final BracePair[] PAIRS;
    @NotNull
    private static final TokenSet TRIGGER_TOKENS;

    @NotNull
    public BracePair[] getPairs() {
        return PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)lbraceType, (String)"lbraceType");
        return TRIGGER_TOKENS.contains(tokenType) || JSElementTypes.WHITE_SPACES.contains(tokenType) || JSElementTypes.COMMENTS.contains(tokenType) || tokenType == JSTokenTypes.GT && JSTokenTypes.LBRACES.contains(lbraceType) || tokenType == null;
    }

    public int getCodeConstructStart(@NotNull PsiFile file, int openingBraceOffset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement element = file.findElementAt(openingBraceOffset);
        if (element == null || element instanceof PsiFile) {
            return openingBraceOffset;
        }
        PsiElement parent = element.getParent();
        if (JSElementTypes.BLOCK_STATEMENTS.contains(PsiTreeUtilKt.getElementType((PsiElement)parent))) {
            parent = parent.getParent();
        }
        return parent.getTextRange().getStartOffset();
    }

    public boolean shouldStopMatch(boolean forward, @NotNull IElementType braceType, @NotNull HighlighterIterator iterator2) {
        Intrinsics.checkNotNullParameter((Object)braceType, (String)"braceType");
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        IElementType currType = iterator2.getTokenType();
        if (forward && currType == JSTokenTypes.RPAR && braceType != JSTokenTypes.LPAR) {
            int retreatCount = 0;
            iterator2.retreat();
            ++retreatCount;
            currType = iterator2.getTokenType();
            if (currType == JSTokenTypes.WHITE_SPACE) {
                iterator2.retreat();
                ++retreatCount;
                currType = iterator2.getTokenType();
            }
            for (int i = retreatCount; 0 < i; --i) {
                iterator2.advance();
            }
            if (currType == braceType) {
                return true;
            }
        }
        return false;
    }

    static {
        BracePair[] bracePairArray = new BracePair[]{new BracePair(JSTokenTypes.LPAR, JSTokenTypes.RPAR, false), new BracePair(JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, false), new BracePair(JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, true), new BracePair(JSTokenTypes.XML_LBRACE, JSTokenTypes.XML_RBRACE, false), new BracePair(JSDocTokenTypes.DOC_LBRACE, JSDocTokenTypes.DOC_RBRACE, false), new BracePair(JSDocTokenTypes.DOC_LPAR, JSDocTokenTypes.DOC_RPAR, false), new BracePair(JSDocTokenTypes.DOC_LBRACKET, JSDocTokenTypes.DOC_RBRACKET, false), new BracePair(JSDocTokenTypes.DOC_LT, JSDocTokenTypes.DOC_GT, false)};
        PAIRS = bracePairArray;
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.SEMICOLON, JSTokenTypes.COMMA, JSTokenTypes.RPAR, JSTokenTypes.RBRACKET, JSTokenTypes.RBRACE, JSTokenTypes.STRING_TEMPLATE_PART, JSTokenTypes.BACKQUOTE, JSDocTokenTypes.DOC_WHITESPACE_HIGHLIGHTING, JSDocTokenTypes.DOC_COMMENT_DATA, JSDocTokenTypes.DOC_NAMEPATH_PART, JSDocTokenTypes.DOC_RBRACE, JSDocTokenTypes.DOC_RPAR, JSDocTokenTypes.DOC_RBRACKET, JSDocTokenTypes.DOC_GT, JSTokenTypes.XML_RBRACE, JSTokenTypes.XML_ATTR_VALUE_END, JSTokenTypes.XML_END_TAG_START};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        TRIGGER_TOKENS = tokenSet;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSBraceMatcher$Companion;", "", "<init>", "()V", "PAIRS", "", "Lcom/intellij/lang/BracePair;", "getPAIRS", "()[Lcom/intellij/lang/BracePair;", "[Lcom/intellij/lang/BracePair;", "TRIGGER_TOKENS", "Lcom/intellij/psi/tree/TokenSet;", "getTRIGGER_TOKENS", "()Lcom/intellij/psi/tree/TokenSet;", "intellij.javascript.common"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BracePair[] getPAIRS() {
            return PAIRS;
        }

        @NotNull
        public final TokenSet getTRIGGER_TOKENS() {
            return TRIGGER_TOKENS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

