/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.psi.resolve.complexity.JSNamedEvaluationTask;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEvaluationLogger {
    private static final boolean PRINT_TO_STDOUT = false;
    private static final boolean PRINT_CONDITIONALLY = false;
    private static final boolean PRINT_CONSISTENTLY = true;
    private static final boolean PRINT_DEPTHS = false;
    private static final boolean PRINT_CHILD_NUMBER = true;
    private static final int CHILDREN_SHIFT = 4;
    @NotNull
    private static final Logger LOG = Logger.getInstance(JSEvaluationLogger.class);
    @NotNull
    private static final JSEvaluationLogger DUMMY = new JSEvaluationLogger(){

        @Override
        public void cachedValueUsed(int depth, Object key, Object value) {
        }

        @Override
        public void startTask(@Nullable Supplier<String> taskName) {
        }

        @Override
        public void finishTask(@Nullable Supplier<String> messageSuffix) {
        }

        @Override
        public void finishTask(@Nullable Supplier<String> messageSuffix, @Nullable Throwable throwable) {
        }

        public void startComplexityTrackerTask(@NotNull Supplier<?> task, int depthBefore, int maxBranchDepthBefore) {
            if (task == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void finishComplexityTrackerTask(@NotNull Supplier<? extends @Nullable Object> task, @Nullable Object value, int maxBranchDepth, @Nullable Throwable throwable) {
            if (task == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void cachingProhibited() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "task";
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationLogger$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startComplexityTrackerTask";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finishComplexityTrackerTask";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    private static final ThreadLocal<JSEvaluationLogger> ourLoggers = ThreadLocal.withInitial(JSEvaluationLogger::new);
    @NotNull
    private static final ThreadLocal<Boolean> ourIsConditionalEvaluationStarted = ThreadLocal.withInitial(() -> false);
    @Nullable
    private JSEvaluationCallNode myCurrentNode = null;
    private boolean myExceptionCaught = false;

    @NotNull
    public static JSEvaluationLogger getInstance() {
        JSEvaluationLogger jSEvaluationLogger = LOG.isTraceEnabled() ? ourLoggers.get() : DUMMY;
        if (jSEvaluationLogger == null) {
            JSEvaluationLogger.$$$reportNull$$$0(0);
        }
        return jSEvaluationLogger;
    }

    public static boolean startLoggingConditionally(boolean condition) {
        throw new IllegalStateException("Set PRINT_CONDITIONALLY to use this method");
    }

    public static void finishLoggingConditionally(boolean previousValue) {
        ourIsConditionalEvaluationStarted.set(previousValue);
    }

    public void cachedValueUsed(int depth, Object key, Object value) {
        String depthString = "";
        String s = String.format("Cached value for %s used. %sValue = %s", key, depthString, JSEvaluationLogger.toPresentable(value));
        JSEvaluationCallNode.addChild(this.myCurrentNode, s);
    }

    public void cachingProhibited() {
        JSEvaluationCallNode.addChild(this.myCurrentNode, "Caching prohibited");
    }

    public void startTask(@Nullable Supplier<String> taskName) {
        String name = null;
        try {
            name = taskName != null ? taskName.get() : null;
        }
        finally {
            if (name == null) {
                name = "Task";
            }
            this.myCurrentNode = JSEvaluationCallNode.addChild(this.myCurrentNode, name);
        }
    }

    public void finishTask(@Nullable Supplier<String> messageSuffix) {
        this.finishTask(messageSuffix, null);
    }

    public void finishTask(@Nullable Supplier<String> messageSuffix, @Nullable Throwable throwable) {
        String message;
        if (this.myCurrentNode == null) {
            Logger.getInstance(JSEvaluationLogger.class).error("myCurrentNode is null");
            return;
        }
        if (messageSuffix != null && (message = messageSuffix.get()) != null) {
            this.myCurrentNode.myMessage = this.myCurrentNode.myMessage + message;
        }
        if (throwable != null && !(throwable instanceof ControlFlowException)) {
            this.myExceptionCaught = true;
        }
        JSEvaluationCallNode prevNode = this.myCurrentNode;
        this.myCurrentNode = this.myCurrentNode.myParent;
        if (this.myCurrentNode == null && (this.myExceptionCaught || LOG.isTraceEnabled())) {
            prevNode.printTree();
        }
    }

    public void startComplexityTrackerTask(@NotNull Supplier<? extends @Nullable Object> task, int depthBefore, int maxBranchDepthBefore) {
        if (task == null) {
            JSEvaluationLogger.$$$reportNull$$$0(1);
        }
        if (task instanceof JSNamedEvaluationTask && ((JSNamedEvaluationTask)task).isOnlyForTrackingComplexity()) {
            return;
        }
        this.startTask(() -> task.toString());
    }

    public void finishComplexityTrackerTask(@NotNull Supplier<? extends @Nullable Object> task, @Nullable Object value, int maxBranchDepth, @Nullable Throwable throwable) {
        if (task == null) {
            JSEvaluationLogger.$$$reportNull$$$0(2);
        }
        if (task instanceof JSNamedEvaluationTask && ((JSNamedEvaluationTask)task).isOnlyForTrackingComplexity()) {
            return;
        }
        this.finishTask(() -> " --> " + JSEvaluationLogger.toPresentable(value), throwable);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String toPresentable(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ResolveResult[]) {
            return "[" + StringUtil.join((Object[])((ResolveResult[])object), Object::toString, (String)"; ") + "]";
        }
        if (object instanceof Collection) {
            return "[" + StringUtil.join((Collection)((Collection)object), Object::toString, (String)"; ") + "]";
        }
        if (object instanceof PsiElement) {
            return JSEvaluationLogger.psiToPresentable((PsiElement)object);
        }
        if (object instanceof JSTypeSignatureChooser.FunctionTypeWithKind) {
            return JSEvaluationLogger.toPresentable(((JSTypeSignatureChooser.FunctionTypeWithKind)object).getJsFunction());
        }
        return object.toString();
    }

    @Nullable
    private static String psiToPresentable(@Nullable PsiElement psiElement) {
        Object location;
        if (psiElement == null) {
            return null;
        }
        Object suffix = "";
        if (psiElement instanceof StubBasedPsiElement && ((StubBasedPsiElement)psiElement).getStub() != null) {
            location = "stub tree";
        } else if (psiElement instanceof PsiFile) {
            location = ((PsiFile)psiElement).getViewProvider().getVirtualFile().getCanonicalPath();
        } else {
            int lineNumber;
            String text = JSEvaluationLogger.getShortenedText(psiElement);
            if (text != null) {
                suffix = "(" + text + ")";
            }
            location = (lineNumber = JSEvaluationLogger.getLineNumber(psiElement)) >= 0 ? "line " + lineNumber : null;
        }
        return String.valueOf(psiElement) + (String)suffix + " at " + (String)location;
    }

    @Nullable
    public static String getShortenedText(@NotNull PsiElement element) {
        String text;
        if (element == null) {
            JSEvaluationLogger.$$$reportNull$$$0(3);
        }
        return (text = element.getText()) != null ? StringUtil.trimLog((String)text, (int)30).replace('\n', ' ') : null;
    }

    public static int getLineNumber(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return -1;
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject());
        PsiFile containingFile = injectedLanguageManager.getTopLevelFile(element);
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(containingFile);
        if (document == null) {
            return -1;
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return -1;
        }
        textRange = injectedLanguageManager.injectedToHost(element, textRange);
        return document.getLineNumber(textRange.getStartOffset()) + 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startComplexityTrackerTask";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "finishComplexityTrackerTask";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getShortenedText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static final class JSEvaluationCallNode {
        private String myMessage;
        private final List<JSEvaluationCallNode> myChildren;
        @Nullable
        private final JSEvaluationCallNode myParent;
        private final long myStartTime;

        private JSEvaluationCallNode(@Nullable JSEvaluationCallNode parent, @NotNull String message) {
            if (message == null) {
                JSEvaluationCallNode.$$$reportNull$$$0(0);
            }
            this.myChildren = new SmartList();
            this.myParent = parent;
            this.myMessage = message;
            this.myStartTime = System.currentTimeMillis();
        }

        @NotNull
        static JSEvaluationCallNode addChild(@Nullable JSEvaluationCallNode parent, @NotNull String message) {
            if (message == null) {
                JSEvaluationCallNode.$$$reportNull$$$0(1);
            }
            JSEvaluationCallNode child = new JSEvaluationCallNode(parent, message);
            if (parent != null) {
                parent.myChildren.add(child);
            }
            JSEvaluationCallNode jSEvaluationCallNode = child;
            if (jSEvaluationCallNode == null) {
                JSEvaluationCallNode.$$$reportNull$$$0(2);
            }
            return jSEvaluationCallNode;
        }

        void printTree() {
            StringBuilder builder = new StringBuilder();
            this.printToBuilder(builder, 0, 1);
            LOG.debug(builder.insert(0, '\n').toString());
        }

        private void printToBuilder(StringBuilder builder, int prefix, int childNumber) {
            builder.append(StringUtil.repeat((String)" ", (int)prefix));
            if (childNumber > 0) {
                builder.append(childNumber).append(". ");
            }
            builder.append(this.myMessage.replace('\n', ' ')).append("\n");
            for (int i = 0; i < this.myChildren.size(); ++i) {
                JSEvaluationCallNode child = this.myChildren.get(i);
                child.printToBuilder(builder, prefix + 4, i + 1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationLogger$JSEvaluationCallNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationLogger$JSEvaluationCallNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addChild";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addChild";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

