/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.accessibility;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPropertyAccessorChecker {
    @Nullable
    public static JSResolveResult.ProblemKind getPropertyAccessError(@Nullable PsiElement place, @NotNull PsiElement element, boolean isCompletion) {
        if (element == null) {
            JSPropertyAccessorChecker.$$$reportNull$$$0(0);
        }
        if (place instanceof JSProperty) {
            return null;
        }
        if (place != null && element instanceof JSFunction) {
            JSFunction function = (JSFunction)element;
            if (!(element instanceof JSFunctionExpression) && (function.isGetProperty() || function.isSetProperty())) {
                ReadWriteAccessDetector.Access context = JSPropertyAccessorChecker.doSetterProcessing(place, isCompletion);
                if (context == ReadWriteAccessDetector.Access.Write || place instanceof JSFunction && ((JSFunction)place).isSetProperty()) {
                    JSClass clazz;
                    if (!(!function.isGetProperty() || isCompletion && place.getParent() instanceof JSExpressionStatement && (clazz = JSUtils.getMemberContainingClass(function)) != null && clazz.findFunctionByNameAndKind(function.getName(), JSFunction.FunctionKind.SETTER) == null)) {
                        return JSResolveResult.ProblemKind.PROPERTY_IS_READ_ONLY;
                    }
                } else if (context == ReadWriteAccessDetector.Access.Read && function.isSetProperty() && !(place instanceof PsiFile) && !(place instanceof JSClass)) {
                    return JSResolveResult.ProblemKind.PROPERTY_IS_WRITE_ONLY;
                }
            }
        }
        if (place != null && element instanceof JSProperty) {
            JSProperty property = (JSProperty)element;
            ReadWriteAccessDetector.Access access = JSPropertyAccessorChecker.doSetterProcessing(place, isCompletion);
            if (access == ReadWriteAccessDetector.Access.Write && property.isGetProperty()) {
                return JSResolveResult.ProblemKind.PROPERTY_IS_READ_ONLY;
            }
            if (access == ReadWriteAccessDetector.Access.Read && property.isSetProperty()) {
                return JSResolveResult.ProblemKind.PROPERTY_IS_WRITE_ONLY;
            }
        }
        return null;
    }

    @NotNull
    private static ReadWriteAccessDetector.Access doSetterProcessing(@Nullable PsiElement place, boolean isCompletionProcessor) {
        if (isCompletionProcessor && place != null && place.getParent() instanceof JSExpressionStatement) {
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
            if (access == null) {
                JSPropertyAccessorChecker.$$$reportNull$$$0(1);
            }
            return access;
        }
        ReadWriteAccessDetector.Access access = place != null ? JSReadWriteAccessDetector.ourInstance.getExpressionAccess(place) : ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            JSPropertyAccessorChecker.$$$reportNull$$$0(2);
        }
        return access;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/accessibility/JSPropertyAccessorChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/accessibility/JSPropertyAccessorChecker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doSetterProcessing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyAccessError";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

