/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.connectionFrame;

import com.intellij.ide.ui.laf.SystemDarkThemeDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.system.OS;
import com.intellij.util.ui.UIUtil;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\b\u0010\u000e\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/gateway/connectionFrame/TrayIconHelper;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Ljava/awt/TrayIcon;", "processName", "", "restoreFrame", "Lkotlin/Function0;", "", "disconnectFrame", "getTrayIconName", "intellij.gateway"})
@SourceDebugExtension(value={"SMAP\nTrayIconHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrayIconHelper.kt\ncom/jetbrains/gateway/connectionFrame/TrayIconHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n13#2:72\n*S KotlinDebug\n*F\n+ 1 TrayIconHelper.kt\ncom/jetbrains/gateway/connectionFrame/TrayIconHelper\n*L\n11#1:72\n*E\n"})
public final class TrayIconHelper {
    @NotNull
    public static final TrayIconHelper INSTANCE = new TrayIconHelper();
    @NotNull
    private static final Logger logger;

    private TrayIconHelper() {
    }

    @Nullable
    public final TrayIcon create(@NlsSafe @NotNull String processName, @NotNull Function0<Unit> restoreFrame, @NotNull Function0<Unit> disconnectFrame) {
        TrayIcon trayIcon;
        MenuItem item;
        MenuItem menuItem;
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter(restoreFrame, (String)"restoreFrame");
        Intrinsics.checkNotNullParameter(disconnectFrame, (String)"disconnectFrame");
        if (!SystemTray.isSupported()) {
            logger.info("Tray is not supported");
            return null;
        }
        PopupMenu menu = new PopupMenu();
        MenuItem menuItem2 = menuItem = new MenuItem("Show status...");
        PopupMenu popupMenu = menu;
        boolean bl = false;
        item.addActionListener(arg_0 -> TrayIconHelper.create$lambda$0$0(restoreFrame, arg_0));
        popupMenu.add(menuItem);
        item = menuItem = new MenuItem("Disconnect " + processName);
        popupMenu = menu;
        boolean bl2 = false;
        item.addActionListener(arg_0 -> TrayIconHelper.create$lambda$1$0(disconnectFrame, arg_0));
        popupMenu.add(menuItem);
        String uriName = "tray/" + this.getTrayIconName();
        URL uri = INSTANCE.getClass().getClassLoader().getResource(uriName);
        TrayIcon it = trayIcon = new TrayIcon(Toolkit.getDefaultToolkit().getImage(uri), processName, menu);
        boolean bl3 = false;
        it.setImageAutoSize(true);
        TrayIcon trayIcon2 = trayIcon;
        trayIcon2.addActionListener(arg_0 -> TrayIconHelper.create$lambda$3(restoreFrame, arg_0));
        return trayIcon2;
    }

    private final String getTrayIconName() {
        if (OS.CURRENT == OS.macOS) {
            boolean isMacOSBigSurExact;
            boolean bl = isMacOSBigSurExact = OS.CURRENT.isAtLeast(10, 16) && !OS.CURRENT.isAtLeast(12, 0);
            if (isMacOSBigSurExact || SystemDarkThemeDetector.Companion.createDetector(TrayIconHelper::getTrayIconName$lambda$0).isDark()) {
                return UIUtil.isRetina() ? "gateway_tray_white@2x.png" : "gateway_tray_white.png";
            }
            return UIUtil.isRetina() ? "gateway_tray_black@2x.png" : "gateway_tray_black.png";
        }
        return "gateway_tray_color.png";
    }

    private static final void create$lambda$0$0(Function0 $restoreFrame, ActionEvent it) {
        try {
            $restoreFrame.invoke();
        }
        catch (Throwable t) {
            logger.error(t);
        }
    }

    private static final void create$lambda$1$0(Function0 $disconnectFrame, ActionEvent it) {
        try {
            $disconnectFrame.invoke();
        }
        catch (Throwable t) {
            logger.error(t);
        }
    }

    private static final void create$lambda$3(Function0 $restoreFrame, ActionEvent it) {
        try {
            $restoreFrame.invoke();
        }
        catch (Throwable t) {
            logger.error(t);
        }
    }

    private static final void getTrayIconName$lambda$0(Boolean it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TrayIconHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TrayIconHelper.logger = logger;
    }
}

