/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.generator.dml.set;

import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.redis.generator.dml.UtilKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/redis/generator/dml/set/RedisSetSelectGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/script/generator/dml/SelectGenerationResult;", "Lcom/intellij/database/script/generator/dml/SelectTask;", "task", "<init>", "(Lcom/intellij/database/script/generator/dml/SelectTask;)V", "generate", "supportsLimit", "", "version", "Lcom/intellij/database/util/Version;", "intellij.database.dialects.redis"})
public final class RedisSetSelectGenerator
extends DmlGenerator<SelectGenerationResult, SelectTask> {
    public RedisSetSelectGenerator(@NotNull SelectTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        super((DmlTask)task);
    }

    @NotNull
    public SelectGenerationResult generate() {
        DdlBuilder builder = ((SelectTask)this.getTask()).getOutput();
        DasObject table = ((SelectTask)this.getTask()).getTable();
        if (UtilKt.isNotBlank(((SelectTask)this.getTask()).getWhereClause())) {
            UtilKt.generateWhereHint(builder, "value", ((SelectTask)this.getTask()).getWhereClause());
            DdlBuilder ddlBuilder = builder.plain("SMISMEMBER").space();
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
            DdlBuilder ddlBuilder2 = UtilKt.key(ddlBuilder, table).space();
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"space(...)");
            UtilKt.generateWhere(ddlBuilder2, ((SelectTask)this.getTask()).getWhereClause());
            return new SelectGenerationResult(builder, null, null, 6, null);
        }
        if (this.supportsLimit(((SelectTask)this.getTask()).getVersion()) && ((SelectTask)this.getTask()).getLimit() > 0) {
            DdlBuilder ddlBuilder = builder.plain("SRANDMEMBER").space();
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
            v3 = UtilKt.key(ddlBuilder, table).space().number(((SelectTask)this.getTask()).getLimit());
        } else {
            DdlBuilder ddlBuilder = builder.plain("SMEMBERS").space();
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
            v3 = UtilKt.key(ddlBuilder, table);
        }
        return new SelectGenerationResult(builder, null, null, 6, null);
    }

    private final boolean supportsLimit(Version version) {
        boolean bl;
        Version version2 = version;
        if (version2 != null) {
            int[] nArray = new int[]{2, 6};
            bl = version2.isOrGreater(nArray);
        } else {
            bl = false;
        }
        return bl;
    }
}

