/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverClasspathManager;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverUtils;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.EelParametersTuner;
import com.intellij.database.dataSource.IsolateClassPathOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.idea.AppMode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SingleRootClasspathElement;
import it.unimi.dsi.fastutil.Hash;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public final class JdbcConsoleRunContext
implements ConsoleRunConfiguration.RunContext {
    private static final Logger LOG = Logger.getInstance(JdbcConsoleRunContext.class);
    private static final Collection<String> IGNORED_SUFFIXES = Arrays.asList(".txt", ".me", ".info", ".pom", ".xml");
    public static final String MAIN_CLASS = "com.intellij.database.remote.RemoteJdbcServer";
    static final String ZONE_PROPERTY = "user.timezone";
    private static final String LIBRARY_PATH = "java.library.path";
    private final LocalDataSource myDataSource;
    private final Project myProject;
    private static List<Pair<Class<?>, String>> additionalIsolatedClasspath = List.of(new Pair(JdbcNativeUtil.class, (Object)"com.intellij.database.remote.jdbc.SqliteShim"));

    JdbcConsoleRunContext(LocalDataSource dataSource, Project project) {
        this.myDataSource = dataSource;
        this.myProject = project;
    }

    public static void addUtilJars(@NotNull PathsList cp, boolean addGroovy) {
        if (cp == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(0);
        }
        cp.add(PathUtil.getJarPathForClass(StringUtilRt.class));
        cp.add(PathUtil.getJarPathForClass(Hash.Strategy.class));
        if (addGroovy) {
            JdbcConsoleRunContext.addClassJar(cp, JdbcConsoleRunContext.class, "groovy.lang.GroovyShell");
        }
    }

    public static void addJdbcConsoleJars(PathsList cp) {
        JdbcConsoleRunContext.addClassJar(cp, JdbcConsoleRunContext.class, MAIN_CLASS);
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFederatedProvider");
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.intellij.database.remote.jdbc.LobInfo");
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.intellij.desktop.DesktopActionsUtils");
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.jetbrains.JBR");
        JdbcConsoleRunContext.addJdbcHelpersJars(cp);
    }

    public static void addJdbcHelpersJars(PathsList cp) {
        for (DbmsExtension.Bean b : DbImplUtilCore.JDBC_HELPER_EP.allExtensions()) {
            cp.add(PathUtil.getJarPathForClass((Class)((JdbcHelper)b.getInstance()).getClass()));
        }
    }

    public static void addClassJar(@NotNull PathsList cp, @NotNull Class<?> context, @NotNull String className) {
        String s;
        if (cp == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(2);
        }
        if (className == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(3);
        }
        if ((s = PathManager.getResourceRoot(context, (String)("/" + className.replace('.', '/') + ".class"))) == null) {
            return;
        }
        cp.add(new File(s).getAbsoluteFile().getAbsolutePath());
    }

    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    @Override
    public String getMainClassName() {
        return MAIN_CLASS;
    }

    @Override
    public void collectClassPath(PathsList cp) {
        JdbcConsoleRunContext.addUtilJars(cp, true);
        JdbcConsoleRunContext.addJdbcConsoleJars(cp);
        if (!JdbcConsoleRunContext.shouldIsolateClassPath(this.myDataSource)) {
            JdbcConsoleRunContext.addIsolatedClassPath(cp, this.myDataSource, this.myProject, true);
        }
    }

    private static void addIsolatedClassPath(PathsList cp, LocalDataSource dataSource, Project project, Boolean withAdditionalIsolatedClassPath) {
        if (withAdditionalIsolatedClassPath.booleanValue()) {
            additionalIsolatedClasspath.forEach(pair -> JdbcConsoleRunContext.addClassJar(cp, (Class)pair.getFirst(), (String)pair.getSecond()));
        }
        JdbcConsoleRunContext.addJdbcDrivers(cp, dataSource, project);
    }

    public static void addJdbcDrivers(PathsList cp, LocalDataSource dataSource, Project project) {
        boolean sensitive = StandardFileSystems.local().isCaseSensitive();
        DatabaseArtifactContext context = DatabaseArtifactContext.Companion.getInstance(project, dataSource);
        DatabaseDriver driver = dataSource.getDatabaseDriver();
        if (driver == null) {
            return;
        }
        Iterator iterator = JdbcConsoleRunContext.expandPackUrls(DatabaseDriverClasspathManager.Companion.getInstance(project).getClasspathElements(driver, context), context).iterator();
        while (iterator.hasNext()) {
            String url;
            String path = url = (String)iterator.next();
            if (!context.useEel()) {
                path = PathUtil.toPresentableUrl((String)url);
            }
            if (JdbcConsoleRunContext.isIgnored(sensitive, path)) continue;
            cp.add(path);
        }
    }

    public static boolean isIgnored(boolean sensitive, String path) {
        for (String suffix : IGNORED_SUFFIXES) {
            if (!(sensitive ? path.endsWith(suffix) : StringUtil.endsWithIgnoreCase((String)path, (String)suffix))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Sdk getSdk() {
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        String path = driver == null ? null : ((DatabaseDriverImpl)driver).getJrePath();
        return path == null ? null : new SimpleJavaSdkType().createJdk("tmp-custom", path);
    }

    @Override
    public void tuneParams(@NotNull Project project, @NotNull SimpleJavaParameters params) throws ExecutionException {
        String driverClass;
        if (project == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(4);
        }
        if (params == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)(driverClass = this.myDataSource.getDriverClass()))) {
            throw new ExecutionException(DatabaseBundle.message((String)"dialog.message.no.driver.class.for", (Object[])new Object[]{this.myDataSource.getName()}));
        }
        ParametersList vmParams = params.getVMParametersList();
        if (!vmParams.hasProperty(ZONE_PROPERTY)) {
            vmParams.addProperty(ZONE_PROPERTY, "UTC");
        }
        Bitness bitness = JdbcConsoleRunContext.detectBitness(params);
        List<Path> nativePaths = this.getNativeLibrariesPaths(bitness);
        this.setNativePaths(params, nativePaths);
        JdbcConsoleRunContext.setDefaultMemoryOption(vmParams, "-Xmx");
        JdbcConsoleRunContext.setDefaultMemoryOption(vmParams, "-Xms");
        if (JdbcConsoleRunContext.shouldRunHeadless()) {
            vmParams.addProperty("java.awt.headless", "true");
        }
        JdbcConsoleRunContext.addIllegalAccessOptions(vmParams);
        params.getProgramParametersList().add(driverClass);
        String dir = this.myDataSource.getWorkingDir();
        if ("".equals(dir)) {
            String string = dir = this.myDataSource.isGlobal() ? null : project.getBasePath();
        }
        if (dir != null) {
            params.setWorkingDirectory(JdbcConsoleRunContext.expand(project, dir));
        }
        for (ConsoleRunContextParametersTuner parametersTuner : (ConsoleRunContextParametersTuner[])PARAMETERS_TUNERS.getExtensions()) {
            parametersTuner.tuneParams(project, this.myDataSource, params);
        }
    }

    public static PathsList getIsolatedClassPath(LocalDataSource dataSource, Project project) {
        PathsList cp = new PathsList();
        JdbcConsoleRunContext.addIsolatedClassPath(cp, dataSource, project, false);
        PathsList temp = new PathsList();
        additionalIsolatedClasspath.forEach(pair -> JdbcConsoleRunContext.addClassJar(temp, (Class)pair.getFirst(), (String)pair.getSecond()));
        EelParametersTuner.Companion.transferPathListIfNeeded(project, temp, dataSource, false);
        cp.addAll(temp.getPathList());
        return cp;
    }

    public static void passJnaPath(ParametersList vmParams) {
        String jnaBootLibraryPath = System.getProperty("jna.boot.library.path");
        if (jnaBootLibraryPath != null) {
            vmParams.addProperty("jna.boot.library.path", jnaBootLibraryPath);
            vmParams.addProperty("jna.nosys", "true");
            vmParams.addProperty("jna.noclasspath", "true");
        }
    }

    public static boolean shouldPassJnaPath(@NotNull LocalDataSource dataSource) {
        String options;
        if (dataSource == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(6);
        }
        return (options = dataSource.getVmOptions()) == null || !options.contains("-Djna.boot.library.path") && !options.contains("-Djna.nosys") && !options.contains("-Djna.noclasspath");
    }

    public static boolean shouldIsolateClassPath(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(7);
        }
        return !RemoteObject.IN_PROCESS && Boolean.TRUE.equals(DbOptionProvider.getOptionValue((Object)dataSource, IsolateClassPathOptionProvider.class));
    }

    static boolean shouldRunHeadless() {
        return AppMode.isHeadless() || AppMode.isRemoteDevHost();
    }

    static void addIllegalAccessOptions(@NotNull ParametersList params) {
        ParamsGroup group;
        if (params == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(8);
        }
        if ((group = params.getParamsGroup("exports")) != null) {
            group.addParameter("--add-opens=jdk.unsupported/sun.misc=ALL-UNNAMED");
            group.addParameter("--add-opens=java.base/java.nio=ALL-UNNAMED");
            group.addParameter("--add-opens=java.base/java.util=ALL-UNNAMED");
        }
    }

    public static String expand(@NotNull Project project, String dir) {
        String expanded;
        if (project == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(9);
        }
        if (dir == null) {
            return null;
        }
        DataContext context = SimpleDataContext.getProjectContext((Project)project);
        try {
            expanded = MacroManager.getInstance().expandSilentMacros(dir, true, context);
        }
        catch (Macro.ExecutionCancelledException e) {
            expanded = dir;
        }
        return (String)ObjectUtils.notNull((Object)expanded, (Object)dir);
    }

    static void setDefaultMemoryOption(ParametersList vmParams, String option) {
        String value = (String)ContainerUtil.find((Iterable)vmParams.getParameters(), p2 -> p2.startsWith(option));
        if (value != null) {
            return;
        }
        String current = (String)ContainerUtil.find(ManagementFactory.getRuntimeMXBean().getInputArguments(), p2 -> p2.startsWith(option));
        if (current == null) {
            return;
        }
        vmParams.add(current);
    }

    public void setNativePaths(@NotNull SimpleJavaParameters params, List<Path> nativePaths) {
        String ldPath;
        if (params == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(10);
        }
        if (nativePaths.isEmpty()) {
            return;
        }
        ParametersList vmParams = params.getVMParametersList();
        String existing = StringUtil.nullize((String)vmParams.getPropertyValue(LIBRARY_PATH));
        String path = StringUtil.join((Iterable)JBIterable.from(nativePaths).map(Path::toAbsolutePath), (String)File.pathSeparator);
        vmParams.addProperty(LIBRARY_PATH, (String)(existing == null ? path : existing + File.pathSeparator + path));
        String string = SystemInfo.isMac ? "DYLD_FALLBACK_LIBRARY_PATH" : (SystemInfo.isUnix ? "LD_LIBRARY_PATH" : (ldPath = SystemInfo.isWindows ? "PATH" : null));
        if (ldPath != null) {
            String prev = StringUtil.nullize((String)((String)params.getEnv().get(path)));
            if (prev == null) {
                prev = StringUtil.nullize((String)((String)EnvironmentUtil.getEnvironmentMap().get(ldPath)));
            }
            String newPath = prev == null ? path : prev + File.pathSeparator + path;
            LOG.info("Extending " + ldPath + " " + prev + "\nto " + newPath);
            params.addEnv(ldPath, newPath);
        }
    }

    @NotNull
    private List<Path> getNativeLibrariesPaths(Bitness bitness) {
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        if (driver == null) {
            List<Path> list = Collections.emptyList();
            if (list == null) {
                JdbcConsoleRunContext.$$$reportNull$$$0(11);
            }
            return list;
        }
        DatabaseArtifactList.Item.Arch arch = switch (bitness) {
            default -> throw new MatchException(null, null);
            case Bitness.x32 -> DatabaseArtifactList.Item.Arch.X86;
            case Bitness.x64 -> DatabaseArtifactList.Item.Arch.X86_64;
        };
        List list = DatabaseDriverUtils.getNativeLibrariesPaths((DatabaseDriver)driver, (DatabaseArtifactList.Item.Arch)arch, (Project)this.myProject, (DatabaseArtifactContext)DatabaseArtifactContext.Companion.getInstance(this.myProject, this.myDataSource));
        if (list == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static boolean isZip(String url) {
        return StringUtil.endsWithIgnoreCase((String)url, (String)".zip");
    }

    @NotNull
    static Bitness detectBitness(@NotNull SimpleJavaParameters params) {
        JdkVersionDetector.JdkVersionInfo info;
        String homePath;
        Sdk jdk;
        if (params == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(13);
        }
        if ((jdk = params.getJdk()) != null && (homePath = jdk.getHomePath()) != null && (info = JdkVersionDetector.getInstance().detectJdkVersionInfo(homePath)) != null && info.arch.width == 32) {
            Bitness bitness = Bitness.x32;
            if (bitness == null) {
                JdbcConsoleRunContext.$$$reportNull$$$0(14);
            }
            return bitness;
        }
        Bitness bitness = Bitness.x64;
        if (bitness == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(15);
        }
        return bitness;
    }

    @NotNull
    public static JBIterable<SimpleClasspathElement> expandPacks(@NotNull List<SimpleClasspathElement> items, DatabaseArtifactContext context) {
        if (items == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(16);
        }
        JBIterable jBIterable = JdbcConsoleRunContext.expandPackUrls(items, context).map(SingleRootClasspathElement::new);
        if (jBIterable == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<String> expandPackUrls(@NotNull List<SimpleClasspathElement> items, DatabaseArtifactContext context) {
        if (items == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(18);
        }
        DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
        JBIterable jBIterable = JBIterable.from(items).flatten(item -> {
            List urls = item.getClassesRootUrls();
            if (ContainerUtil.find((Iterable)urls, u -> JdbcConsoleRunContext.isZip(u)) == null) {
                return item.getClassesRootUrls();
            }
            ArrayList<Object> unzipped = new ArrayList<Object>();
            for (String url : urls) {
                if (!JdbcConsoleRunContext.isZip(url)) {
                    unzipped.add(url);
                    continue;
                }
                File dir = loader.unpackZipIfNeeded(Path.of(StringUtil.trimStart((String)url, (String)"file://"), new String[0]), context).toFile();
                for (File file : ((JBTreeTraverser)FileUtil.fileTraverser((File)dir).filter(File::isFile)).traverse()) {
                    unzipped.add("file://" + file.getAbsolutePath());
                }
            }
            return unzipped;
        });
        if (jBIterable == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 14, 15, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcConsoleRunContext";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcConsoleRunContext";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeLibrariesPaths";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "detectBitness";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "expandPacks";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "expandPackUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addUtilJars";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addClassJar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tuneParams";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldPassJnaPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldIsolateClassPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addIllegalAccessOptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setNativePaths";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "detectBitness";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "expandPacks";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "expandPackUrls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 14, 15, 17, 19 -> new IllegalStateException(string);
        };
    }
}

