/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.BatchInsertsStatement;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.dbimport.DatabaseTableSource;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportTarget;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.model.DasObject;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.LambdaMetafactory;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DatabaseImportTarget
implements ImportTarget {
    private final DatabaseConnection myConnection;
    private final ImportManager myManager;
    private final boolean mySingleConnection;
    private final JdbcTarget myJdbcTarget;

    public DatabaseImportTarget(@NotNull DatabaseConnection connection2, @NotNull ImportManager manager, boolean singleConnection) {
        if (connection2 == null) {
            DatabaseImportTarget.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DatabaseImportTarget.$$$reportNull$$$0(1);
        }
        this.myConnection = connection2;
        this.myManager = manager;
        this.mySingleConnection = singleConnection;
        this.myJdbcTarget = new JdbcTarget(manager, connection2);
    }

    public void beforeImportStart(@NotNull ImportInfo info) throws Exception {
        if (info == null) {
            DatabaseImportTarget.$$$reportNull$$$0(2);
        }
        this.retrieveColumns(info);
        this.myJdbcTarget.beforeImportStart(info);
    }

    public void afterImportEnd(@NotNull ImportInfo info) {
        if (info == null) {
            DatabaseImportTarget.$$$reportNull$$$0(3);
        }
        this.myJdbcTarget.afterImportEnd(info);
    }

    @NotNull
    public List<ErrorRecord> importBatch(@NotNull ImportInfo info, @NotNull BatchRecords records) throws SQLException, RemoteException {
        if (info == null) {
            DatabaseImportTarget.$$$reportNull$$$0(4);
        }
        if (records == null) {
            DatabaseImportTarget.$$$reportNull$$$0(5);
        }
        List<ErrorRecord> list = this.myJdbcTarget.importBatch(info, records);
        if (list == null) {
            DatabaseImportTarget.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public Long getInsertedRows() throws RemoteException {
        return this.myJdbcTarget.getInsertedRows();
    }

    @NotNull
    public ImportTarget.Combination combine(@NotNull ReaderTask.Source source) {
        if (source == null) {
            DatabaseImportTarget.$$$reportNull$$$0(7);
        }
        if (source instanceof DatabaseTableSource) {
            LocalDataSource dataSource;
            DatabaseTableSource dbInput = (DatabaseTableSource)source;
            if (this.mySingleConnection && (dataSource = dbInput.getDataSource()) == this.myConnection.getConnectionPoint().getDataSource() && dbInput.isSingleConnection()) {
                ImportTarget.Combination combination = ImportTarget.SerialCombination.INSTANCE;
                if (combination == null) {
                    DatabaseImportTarget.$$$reportNull$$$0(8);
                }
                return combination;
            }
        }
        ImportTarget.Combination combination = ImportTarget.ConcurrentCombination.INSTANCE;
        if (combination == null) {
            DatabaseImportTarget.$$$reportNull$$$0(9);
        }
        return combination;
    }

    private void retrieveColumns(@NotNull ImportInfo info) throws Exception {
        if (info == null) {
            DatabaseImportTarget.$$$reportNull$$$0(10);
        }
        SelectTask task = DmlTaskKt.allColumns((DasObject)info.cache().getBasicTable()).version(this.myConnection.getVersion()).limit(1).build(ImportManager.createConfiguredBuilder((ImportEditorContext)info.getContext()));
        DdlBuilder builder = ((SelectGenerationResult)DmlUtilKt.dmlGenerator((Dbms)this.myConnection.getDbms()).generate((DmlTask)task)).getBuilder();
        List<JdbcColumnDescriptor> columns = this.getColumns(this.myConnection, builder);
        if (columns != null) {
            info.setConsumers(columns);
        }
    }

    @Nullable
    private List<JdbcColumnDescriptor> getColumns(@NotNull DatabaseConnection connection2, @NotNull DdlBuilder builder) throws SQLException {
        if (connection2 == null) {
            DatabaseImportTarget.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            DatabaseImportTarget.$$$reportNull$$$0(12);
        }
        return (List)SmartStatements.poweredBy(connection2).simple().noisy().execute((Object)builder.getStatement(), StandardResultsProcessors.throwableResultsTransformer(rs -> Arrays.asList(JdbcEngineUtils.getColumnDescriptors((RemoteResultSet)rs))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/DatabaseImportTarget";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/DatabaseImportTarget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "importBatch";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "combine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "beforeImportStart";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "afterImportEnd";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importBatch";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "retrieveColumns";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class JdbcTarget
    implements ImportTarget {
        private final ImportManager myManager;
        private final DatabaseConnection myConnection;
        private BatchInsertsStatement myStatement;
        private List<ImportManager.ConnectionStateSwitch> mySwitches;

        JdbcTarget(@NotNull ImportManager manager, @NotNull DatabaseConnection connection2) {
            if (manager == null) {
                JdbcTarget.$$$reportNull$$$0(0);
            }
            if (connection2 == null) {
                JdbcTarget.$$$reportNull$$$0(1);
            }
            this.myManager = manager;
            this.myConnection = connection2;
        }

        /*
         * Unable to fully structure code
         */
        public void beforeImportStart(@NotNull ImportInfo info) throws Exception {
            if (info == null) {
                JdbcTarget.$$$reportNull$$$0(2);
            }
            if ((metaData = this.myConnection.getRemoteMetaData()) == null) ** GOTO lbl-1000
            if (JdbcNativeUtil.getBooleanSafe((ThrowableComputable)(ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, supportsTransactions(), ()Ljava/lang/Boolean;)((RemoteDatabaseMetaData)metaData)) && this.myManager.shouldUseTransactions()) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = transactions = false;
            }
            if (metaData == null) ** GOTO lbl-1000
            if (JdbcNativeUtil.getBooleanSafe((ThrowableComputable)(ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, supportsBatchUpdates(), ()Ljava/lang/Boolean;)((RemoteDatabaseMetaData)metaData)) && this.myManager.shouldUseBatches()) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = batches = false;
            }
            if (metaData == null) ** GOTO lbl-1000
            if (JdbcNativeUtil.getBooleanSafe((ThrowableComputable)(ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, supportsSavepoints(), ()Ljava/lang/Boolean;)((RemoteDatabaseMetaData)metaData)) && this.myManager.shouldUseSavepoints()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            savepoints = v2;
            linesPerStatement = this.myManager.getLinesPerStatement();
            this.mySwitches = this.myManager.getConnectionStateSwitches(info);
            for (ImportManager.ConnectionStateSwitch oneSwitch : this.mySwitches) {
                oneSwitch.turnOn((DatabaseConnectionCore)this.myConnection);
            }
            queriesBefore = this.myManager.getFastModeOnQueries(info);
            if (info.shouldLockTable()) {
                JdbcTarget.execute(this.myConnection, queriesBefore);
            }
            if (transactions) {
                this.myConnection.setAutoCommit(false);
            }
            statement = ImportManager.getInsertStatement((ImportInfo)info, (int)linesPerStatement);
            oneLine = ImportManager.getInsertStatement((ImportInfo)info, (int)1);
            lockQuery = info.shouldLockTable() != false ? this.myManager.getLockQuery(info) : null;
            columnInfos = info.cache().getColumnInfos();
            configuration = new RemoteBatchPreparedStatementImpl.Configuration(statement, oneLine, lockQuery, columnInfos, transactions, savepoints, batches, linesPerStatement);
            this.myStatement = SmartStatements.poweredBy(this.myConnection).batchInserts(configuration);
        }

        @NotNull
        public List<ErrorRecord> importBatch(@NotNull ImportInfo info, @NotNull BatchRecords records) throws RemoteException, SQLException {
            if (info == null) {
                JdbcTarget.$$$reportNull$$$0(3);
            }
            if (records == null) {
                JdbcTarget.$$$reportNull$$$0(4);
            }
            if (records.isEmpty()) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    JdbcTarget.$$$reportNull$$$0(5);
                }
                return list;
            }
            int lastCount = records.getLinesCount() % this.myManager.getLinesPerStatement();
            String lastSql = ImportManager.getInsertStatement((ImportInfo)info, (int)(lastCount == 0 ? this.myManager.getLinesPerStatement() : lastCount));
            List list = this.myStatement.addBatch(records, lastSql);
            if (list == null) {
                JdbcTarget.$$$reportNull$$$0(6);
            }
            return list;
        }

        public void afterImportEnd(@NotNull ImportInfo info) {
            if (info == null) {
                JdbcTarget.$$$reportNull$$$0(7);
            }
            if (this.mySwitches == null) {
                return;
            }
            for (ImportManager.ConnectionStateSwitch oneSwitch : this.mySwitches) {
                oneSwitch.turnOff((DatabaseConnectionCore)this.myConnection);
            }
            List queriesAfter = this.myManager.getFastModeOffQueries(info);
            if (info.shouldLockTable()) {
                JdbcTarget.executeIgnore(this.myConnection, queriesAfter);
            }
            DbImplUtil.closeSafe((AutoCloseable)this.myStatement);
        }

        @Nullable
        public Long getInsertedRows() throws RemoteException {
            return this.myStatement == null ? null : Long.valueOf(this.myStatement.getInsertedLinesCount());
        }

        @NotNull
        public ImportTarget.Combination combine(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ReaderTask.Source source) {
            if (source == null) {
                JdbcTarget.$$$reportNull$$$0(8);
            }
            throw new UnsupportedOperationException("Mustn't be called");
        }

        private static void execute(@NotNull DatabaseConnection connection2, @NotNull @Unmodifiable List<String> queries) throws SQLException {
            if (connection2 == null) {
                JdbcTarget.$$$reportNull$$$0(9);
            }
            if (queries == null) {
                JdbcTarget.$$$reportNull$$$0(10);
            }
            try (ReusableSmartStatement statement = SmartStatements.poweredBy(connection2).simple().reuse();){
                for (String query : queries) {
                    statement.barren().execute((Object)query);
                }
            }
        }

        private static void executeIgnore(@NotNull DatabaseConnection connection2, @NotNull List<String> queries) {
            if (connection2 == null) {
                JdbcTarget.$$$reportNull$$$0(11);
            }
            if (queries == null) {
                JdbcTarget.$$$reportNull$$$0(12);
            }
            try {
                JdbcTarget.execute(connection2, queries);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "records";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/DatabaseImportTarget$JdbcTarget";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/DatabaseImportTarget$JdbcTarget";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "importBatch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeImportStart";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "importBatch";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "afterImportEnd";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "combine";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "executeIgnore";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

