/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.moveattributein;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBBox;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.RefactorXBundle;
import com.sixrr.xrp.utils.XMLRefactoringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

class MoveAttributeInDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JTextField tagNameField;
    private final XmlAttribute attribute;
    private final XmlTag tag;

    MoveAttributeInDialog(XmlAttribute attribute) {
        super(attribute.getProject(), true);
        this.attribute = attribute;
        this.tag = attribute.getParent();
        XmlFile containingFile = (XmlFile)this.tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle(RefactorXBundle.message("dialog.title.move.attribute.in", new Object[0]));
        this.attributeNameLabel.setText(RefactorXBundle.message("dialog.title.move.attribute.to.subtag", new Object[0]));
        this.tagNameField = new JTextField("");
        Document document = this.tagNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.MoveAttributeIn";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.tagNameField;
    }

    public String getTagName() {
        return this.tagNameField.getText().trim();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        String attributeName = this.attribute.getName();
        JPanel panel = new JPanel(new BorderLayout());
        TitledBorder border = IdeBorderFactory.createTitledBorder((String)RefactorXBundle.message("border.text.move.attribute.0.of.tag.1.in.to.subtag", attributeName, tagName));
        panel.add((Component)this.attributeNameLabel, "North");
        JBBox box = JBBox.createVerticalBox();
        panel.setBorder(border);
        this.tagNameField.setEditable(true);
        box.add((Component)this.tagNameField);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        String tagName = this.getTagName();
        boolean tagNameEntered = XMLRefactoringUtil.tagNameIsValid(tagName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return tagNameEntered && scopeIsValid;
    }

    @Override
    protected String calculateXSLT() {
        String attributeName = this.attribute.getName();
        String parentTagName = this.attribute.getParent().getName();
        String childTagName = this.getTagName();
        return "<xsl:template match=\"" + parentTagName + "[@" + attributeName + "]/" + childTagName + "\">\n\t<xsl:copy> \n\t\t<xsl:attribute name = \"" + attributeName + "\">\n\t\t\t<xsl:value-of select=\"../@" + attributeName + "\"/>\n\t\t</xsl:attribute>\n\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t</xsl:copy>          \n</xsl:template>  \n<xsl:template match = \"@" + attributeName + "[parent::" + parentTagName + "]\"/>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "refactoring.moveAttributeIn";
    }
}

