/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.tagtoattribute;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.sixrr.xrp.base.BaseTagRefactoringHandler;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.tagtoattribute.TagToAttributeDialog;
import com.sixrr.xrp.tagtoattribute.TagToAttributeProcessor;
import com.sixrr.xrp.utils.RefactorXBundle;
import org.jetbrains.annotations.Nullable;

class TagToAttributeHandler
extends BaseTagRefactoringHandler {
    TagToAttributeHandler() {
    }

    @Override
    protected String getHelpID() {
        return "refactoring.tagToAttribute";
    }

    @Override
    protected String getRefactoringName() {
        return RefactorXBundle.message("tag.to.attribute", new Object[0]);
    }

    @Override
    protected void handleTag(XmlTag tag, Project project) {
        TagToAttributeDialog dialog = new TagToAttributeDialog(tag);
        if (!dialog.showAndGet()) {
            return;
        }
        Context context = dialog.getContext();
        String attributeName = dialog.getAttributeName();
        boolean previewUsages = dialog.isPreviewUsages();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            TagToAttributeProcessor processor = new TagToAttributeProcessor(tag, attributeName, context);
            processor.setPreviewUsages(previewUsages);
            processor.run();
        }, RefactorXBundle.message("command.name.replace.tag.with.attribute", new Object[0]), null);
    }

    @Override
    @Nullable
    protected String getProblemMessage(XmlTag tag) {
        if (tag.getParentTag() == null) {
            return RefactorXBundle.message("cannot.perform.the.refactoring.this.refactoring.is.not.available.for.top.level.tags", new Object[0]);
        }
        return null;
    }
}

