/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.collection.SimpleArray;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.StructContentType;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.internal.parser.ItemBuilder;
import org.openjdk.jmc.flightrecorder.internal.util.DisjointBuilder;
import org.openjdk.jmc.flightrecorder.parser.IEventSink;
import org.openjdk.jmc.flightrecorder.parser.IEventSinkFactory;
import org.openjdk.jmc.flightrecorder.parser.ValueField;

class RepositoryBuilder
implements IEventSinkFactory {
    private static final Logger LOGGER = Logger.getLogger(RepositoryBuilder.class.getName());
    private final Map<String, EventTypeEntry> eventTypes = new HashMap<String, EventTypeEntry>();
    private static final DisjointBuilder.ArrayFactory<IItem> ARRAY_FACTORY = new DisjointBuilder.ArrayFactory<IItem>(){

        public IItem[] createArray(int size) {
            return new IItem[size];
        }
    };

    RepositoryBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IEventSink create(String identifier, String label2, String[] category, String description, List<ValueField> dataStructure) {
        Map<String, EventTypeEntry> map2 = this.eventTypes;
        synchronized (map2) {
            EventTypeEntry eventTypeEntry = this.eventTypes.get(identifier);
            if (eventTypeEntry == null) {
                eventTypeEntry = RepositoryBuilder.createEventTypeEntry(identifier, label2, category, description, dataStructure);
                this.eventTypes.put(identifier, eventTypeEntry);
                return eventTypeEntry.createSink();
            }
            while (!eventTypeEntry.isCompatibleWith(dataStructure)) {
                if (eventTypeEntry.next == null) {
                    eventTypeEntry.next = RepositoryBuilder.createEventTypeEntry(identifier + UUID.randomUUID().toString(), label2, category, description, dataStructure);
                    LOGGER.log(Level.WARNING, MessageFormat.format("Created new event type entry for {0} because the fields did not match those of the previously created one. New identifier is {1}", identifier, ((EventTypeEntry)eventTypeEntry).next.eventType.getIdentifier()));
                    return eventTypeEntry.next.createSink();
                }
                eventTypeEntry = eventTypeEntry.next;
            }
            return eventTypeEntry.createSink();
        }
    }

    private static EventTypeEntry createEventTypeEntry(String identifier, String label2, String[] category, String description, List<ValueField> dataStructure) {
        StructContentType<IItem> eventType = new StructContentType<IItem>(identifier, label2, description);
        ItemBuilder.IItemFactory itemFactory = ItemBuilder.createItemFactory(eventType, dataStructure);
        IMemberAccessor<IQuantity, IItem> stAccessor = JfrAttributes.START_TIME.getAccessor(eventType);
        IMemberAccessor<IQuantity, IItem> etAccessor = JfrAttributes.END_TIME.getAccessor(eventType);
        if (stAccessor != null && stAccessor != etAccessor) {
            return new DurationEventTypeEntry(eventType, category, itemFactory, dataStructure, stAccessor, etAccessor);
        }
        return new InstantEventTypeEntry(eventType, category, itemFactory, dataStructure, etAccessor);
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<EventTypeEntry> getEventTypes() {
        Map<String, EventTypeEntry> map2 = this.eventTypes;
        synchronized (map2) {
            final Iterator<EventTypeEntry> it = this.eventTypes.values().iterator();
            return new Iterator<EventTypeEntry>(){
                private EventTypeEntry rem;

                @Override
                public boolean hasNext() {
                    return this.rem != null || it.hasNext();
                }

                @Override
                public EventTypeEntry next() {
                    EventTypeEntry tmp = this.rem == null ? (EventTypeEntry)it.next() : this.rem;
                    this.rem = tmp.next;
                    return tmp;
                }

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class InstantEventTypeEntry
    extends EventTypeEntry {
        private final List<SimpleArray<IItem>> eventsLanes = new ArrayList<SimpleArray<IItem>>();
        private final IMemberAccessor<IQuantity, IItem> order;

        public InstantEventTypeEntry(StructContentType<IItem> eventType, String[] category, ItemBuilder.IItemFactory itemFactory, List<ValueField> dataStructure, IMemberAccessor<IQuantity, IItem> order) {
            super(eventType, category, itemFactory, dataStructure);
            this.order = order;
        }

        @Override
        synchronized Collection<IItem[]> buildSortedArrays() {
            int eventCount = 0;
            for (SimpleArray<IItem> a : this.eventsLanes) {
                eventCount += a.size();
            }
            if (eventCount == 0) {
                return Collections.emptyList();
            }
            IItem[] events = new IItem[eventCount];
            int offset = 0;
            for (SimpleArray<IItem> a : this.eventsLanes) {
                a.copyTo((IItem[])events, offset);
                offset += a.size();
            }
            if (this.order != null) {
                Arrays.sort(events, new Comparator<IItem>(){

                    @Override
                    public int compare(IItem o1, IItem o2) {
                        return ((IQuantity)order.getMember(o1)).compareTo((IQuantity)order.getMember(o2));
                    }
                });
            }
            return Arrays.asList(new IItem[][]{events});
        }

        private synchronized SimpleArray<IItem> createLane() {
            SimpleArray<IItem> lane = new SimpleArray<IItem>(new IItem[3]);
            this.eventsLanes.add(lane);
            return lane;
        }

        @Override
        public IEventSink createSink() {
            return new IEventSink(){
                private final SimpleArray<IItem> events;
                {
                    this.events = this.createLane();
                }

                @Override
                public void addEvent(Object[] values) {
                    this.events.add(itemFactory.createEvent(values));
                }
            };
        }
    }

    private static class DurationEventTypeEntry
    extends EventTypeEntry {
        private final List<DisjointBuilder<IItem>> eventsLanes = new ArrayList<DisjointBuilder<IItem>>();
        private final IMemberAccessor<IQuantity, IItem> startAccessor;
        private final IMemberAccessor<IQuantity, IItem> endAccessor;

        public DurationEventTypeEntry(StructContentType<IItem> eventType, String[] category, ItemBuilder.IItemFactory itemFactory, List<ValueField> dataStructure, IMemberAccessor<IQuantity, IItem> startAccessor, IMemberAccessor<IQuantity, IItem> endAccessor) {
            super(eventType, category, itemFactory, dataStructure);
            this.startAccessor = startAccessor;
            this.endAccessor = endAccessor;
        }

        @Override
        synchronized Collection<IItem[]> buildSortedArrays() {
            return DisjointBuilder.toArrays(this.eventsLanes, ARRAY_FACTORY);
        }

        private synchronized DisjointBuilder<IItem> createLane() {
            DisjointBuilder<IItem> lane = new DisjointBuilder<IItem>(this.startAccessor, this.endAccessor);
            this.eventsLanes.add(lane);
            return lane;
        }

        @Override
        public IEventSink createSink() {
            return new IEventSink(){
                private final DisjointBuilder<IItem> events;
                {
                    this.events = this.createLane();
                }

                @Override
                public void addEvent(Object[] values) {
                    this.events.add(itemFactory.createEvent(values));
                }
            };
        }
    }

    static abstract class EventTypeEntry {
        final StructContentType<IItem> eventType;
        final String[] category;
        final ItemBuilder.IItemFactory itemFactory;
        final List<ValueField> dataStructure;
        private EventTypeEntry next;

        public EventTypeEntry(StructContentType<IItem> eventType, String[] category, ItemBuilder.IItemFactory itemFactory, List<ValueField> dataStructure) {
            this.eventType = eventType;
            this.category = category;
            this.itemFactory = itemFactory;
            this.dataStructure = dataStructure;
        }

        private boolean isCompatibleWith(List<ValueField> fields) {
            if (this.dataStructure.size() == fields.size()) {
                for (int i = 0; i < this.dataStructure.size(); ++i) {
                    ValueField vf1 = this.dataStructure.get(i);
                    ValueField vf2 = fields.get(i);
                    if (vf1.getIdentifier().equals(vf2.getIdentifier()) && vf1.getContentType().equals(vf2.getContentType())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        abstract Collection<IItem[]> buildSortedArrays();

        abstract IEventSink createSink();
    }
}

