/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ProducerParser;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.TypedArrayParser;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ProducerDescriptor;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

class ChunkMetadata {
    private final ProducerDescriptor[] producers;
    private final IQuantity startTime;
    private final IQuantity endTime;
    private final long startTimeNanos;
    private final long startTicks;
    private final double ticksPerNano;
    private final int previousCheckPoint;
    private final LinearUnit ticksUnit;
    private static final TypedArrayParser<ProducerDescriptor> PRODUCERS_PARSER = new TypedArrayParser<ProducerDescriptor>(new ProducerParser());

    ChunkMetadata(ByteBufferWrapper data2, int metadataOffset) throws InvalidJfrFileException {
        Offset offset = new Offset(data2, metadataOffset);
        offset.increase(4);
        this.producers = PRODUCERS_PARSER.read(data2, offset);
        long startTimeMillis = NumberReaders.readLong(data2, offset);
        this.startTime = UnitLookup.EPOCH_MS.quantity(startTimeMillis);
        this.startTimeNanos = startTimeMillis * 1000L * 1000L;
        this.endTime = UnitLookup.EPOCH_MS.quantity(NumberReaders.readLong(data2, offset));
        this.startTicks = NumberReaders.readLong(data2, offset);
        this.ticksPerNano = (double)NumberReaders.readLong(data2, offset) / 1.0E9;
        this.previousCheckPoint = (int)NumberReaders.readLong(data2, offset);
        this.ticksUnit = UnitLookup.TIMESPAN.makeUnit("ticks", (ITypedQuantity<LinearUnit>)UnitLookup.TIMESPAN.getUnit(DecimalPrefix.NANO).quantity(1.0 / this.ticksPerNano));
    }

    ProducerDescriptor[] getProducers() {
        return this.producers;
    }

    IQuantity getStartTime() {
        return this.startTime;
    }

    IQuantity getEndTime() {
        return this.endTime;
    }

    long getStartTicks() {
        return this.startTicks;
    }

    LinearUnit getTicksUnit() {
        return this.ticksUnit;
    }

    int getPreviousCheckPoint() {
        return this.previousCheckPoint;
    }

    long asNanoTimestamp(long relativeTicks) {
        return this.startTimeNanos + (long)((double)(relativeTicks - this.startTicks) / this.ticksPerNano);
    }
}

