/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace.tree;

import java.util.List;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.MCFrame;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.AggregatableFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.Node;

public class StacktraceTreeModel {
    private static final FrameSeparator DEFAULT_FRAME_SEPARATOR = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
    private static final IMCFrame UNKNOWN_FRAME = new MCFrame(null, null, null, IMCFrame.Type.UNKNOWN);
    private static final IMCFrame ROOT_FRAME = new MCFrame(null, null, null, IMCFrame.Type.UNKNOWN);
    private final IItemCollection items;
    private final FrameSeparator frameSeparator;
    private final IAttribute<IQuantity> attribute;
    private final boolean invertedStacks;
    private final Node root;

    public StacktraceTreeModel(IItemCollection items) {
        this(items, DEFAULT_FRAME_SEPARATOR, false, null);
    }

    public StacktraceTreeModel(IItemCollection items, FrameSeparator frameSeparator) {
        this(items, frameSeparator, false, null);
    }

    public StacktraceTreeModel(IItemCollection items, FrameSeparator frameSeparator, boolean invertedStacks) {
        this(items, frameSeparator, invertedStacks, null);
    }

    public StacktraceTreeModel(IItemCollection items, FrameSeparator frameSeparator, boolean invertedStacks, IAttribute<IQuantity> attribute) {
        this.items = items;
        this.frameSeparator = frameSeparator;
        this.attribute = attribute;
        this.invertedStacks = invertedStacks;
        AggregatableFrame rootFrame = new AggregatableFrame(frameSeparator, ROOT_FRAME);
        this.root = Node.newRootNode(rootFrame);
        for (IItemIterable iterable : items) {
            IMemberAccessor<IMCStackTrace, IItem> stacktraceAccessor = StacktraceTreeModel.getAccessor(iterable, JfrAttributes.EVENT_STACKTRACE);
            if (stacktraceAccessor == null) continue;
            IMemberAccessor<IQuantity, IItem> quantityAccessor = StacktraceTreeModel.getAccessor(iterable, attribute);
            iterable.forEach(item -> this.addItem((IItem)item, stacktraceAccessor, quantityAccessor));
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public IItemCollection getItems() {
        return this.items;
    }

    private void addItem(IItem item, IMemberAccessor<IMCStackTrace, IItem> stacktraceAccessor, IMemberAccessor<IQuantity, IItem> quantityAccessor) {
        double value;
        IMCStackTrace stacktrace = stacktraceAccessor.getMember(item);
        if (stacktrace == null) {
            return;
        }
        List<? extends IMCFrame> frames = stacktrace.getFrames();
        if (frames == null || frames.isEmpty()) {
            return;
        }
        if (this.attribute != null && quantityAccessor == null) {
            return;
        }
        double d = value = quantityAccessor != null ? quantityAccessor.getMember(item).doubleValue() : 1.0;
        if (this.attribute != null && value == 0.0) {
            return;
        }
        Node parent = this.getRoot();
        for (int processedFrames = 0; processedFrames < frames.size(); ++processedFrames) {
            int idx = this.invertedStacks ? processedFrames : frames.size() - 1 - processedFrames;
            AggregatableFrame frame = stacktrace.getTruncationState().isTruncated() && !this.invertedStacks && processedFrames == 0 ? new AggregatableFrame(this.frameSeparator, UNKNOWN_FRAME) : new AggregatableFrame(this.frameSeparator, frames.get(idx));
            Node current = this.getOrCreateNode(parent, frame);
            current.cumulativeWeight += value;
            if (processedFrames == frames.size() - 1) {
                current.weight += value;
            }
            parent = current;
        }
    }

    private Node getOrCreateNode(Node parent, AggregatableFrame frame) {
        return parent.children.stream().filter(child -> child.getFrame().equals(frame)).findAny().orElseGet(() -> {
            Node result = new Node(parent, frame);
            parent.children.add(result);
            return result;
        });
    }

    private static <T> IMemberAccessor<T, IItem> getAccessor(IItemIterable iterable, IAttribute<T> attr) {
        return attr != null ? iterable.getType().getAccessor(attr.getKey()) : null;
    }
}

