/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.database;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.actions.DbDeleteProvider;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewPanel;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.ds.CustomDataSourceHandler;
import com.intellij.jpa.jpb.model.model.CustomDataStore;
import com.intellij.jpa.jpb.model.service.DataStoreManagerExtension;
import com.intellij.liquibase.common.util.NotificationUtilsKt;
import com.intellij.liquibase.database.CredentialsDialog;
import com.intellij.liquibase.database.DataStoreUtils;
import com.intellij.liquibase.database.DataStoreUtilsKt;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u001a\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0016J%\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016H\u0016\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u001bH\u0016J2\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\r0\"H\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/liquibase/database/UDataStoreManagerExtension;", "Lcom/intellij/jpa/jpb/model/service/DataStoreManagerExtension;", "<init>", "()V", "createDataStore", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "project", "Lcom/intellij/openapi/project/Project;", "templateDataStore", "Lcom/intellij/jpa/jpb/model/model/CustomDataStore;", "createDataStoreWithResult", "createAction", "Lkotlin/Function0;", "", "editDataStore", "dataStore", "showDataSourceDialog", "selection", "", "deleteDataStore", "applyInitialCredentials", "dbProperties", "", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;)V", "updateDbConnection", "oldUrl", "", "newDataStore", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "isExistDbConnection", "", "url", "deleteAction", "Lkotlin/Function2;", "Lcom/intellij/database/psi/DbDataSourceImpl;", "Lcom/intellij/database/view/DatabaseView;", "intellij.liquibase.database"})
@SourceDebugExtension(value={"SMAP\nUDataStoreManagerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UDataStoreManagerExtension.kt\ncom/intellij/liquibase/database/UDataStoreManagerExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n774#2:212\n865#2:213\n2746#2,3:214\n866#2:217\n1374#2:218\n1460#2,5:219\n1869#2,2:225\n1761#2,3:227\n808#2,11:230\n1#3:224\n*S KotlinDebug\n*F\n+ 1 UDataStoreManagerExtension.kt\ncom/intellij/liquibase/database/UDataStoreManagerExtension\n*L\n69#1:212\n69#1:213\n70#1:214,3\n69#1:217\n74#1:218\n74#1:219,5\n99#1:225,2\n145#1:227,3\n150#1:230,11\n*E\n"})
public final class UDataStoreManagerExtension
implements DataStoreManagerExtension {
    @Nullable
    public DataStore createDataStore(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.createDataStoreWithResult(project, (Function0<Unit>)((Function0)() -> UDataStoreManagerExtension.createDataStore$lambda$0(this, project)));
    }

    @Nullable
    public DataStore createDataStore(@NotNull Project project, @NotNull CustomDataStore templateDataStore) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)templateDataStore, (String)"templateDataStore");
        DbProperties dbProperties = templateDataStore.getDbProperties();
        DbType dbType = dbProperties.getType();
        Intrinsics.checkNotNullExpressionValue((Object)dbType, (String)"getType(...)");
        LocalDataSource ideaDs = DataStoreUtils.Companion.createLocalDataSource(dbType);
        ideaDs.setName(templateDataStore.getName());
        ideaDs.setUrl(dbProperties.getUrl());
        ideaDs.setUsername(dbProperties.getUser());
        ideaDs.getPasswordStorage();
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)dbPsiFacade, (String)"null cannot be cast to non-null type com.intellij.database.psi.DbPsiFacadeImpl");
        DbPsiFacadeImpl dbPsiFacade2 = (DbPsiFacadeImpl)dbPsiFacade;
        LocalDataSourceManager localDataSourceManager = LocalDataSourceManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)localDataSourceManager, (String)"getInstance(...)");
        LocalDataSourceManager dataSourceManager = localDataSourceManager;
        DbDataSource dbDataSource = dbPsiFacade2.createDataSourceWrapperElement((RawDataSource)ideaDs, (DataSourceManager)dataSourceManager);
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"createDataSourceWrapperElement(...)");
        DbDataSource newElement = dbDataSource;
        return this.createDataStoreWithResult(project, (Function0<Unit>)((Function0)() -> UDataStoreManagerExtension.createDataStore$lambda$1(this, project, newElement)));
    }

    /*
     * WARNING - void declaration
     */
    private final DataStore createDataStoreWithResult(Project project, Function0<Unit> createAction) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        List list = DataSourceStorage.getProjectStorage((Project)project).getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        List oldDataSources = list;
        createAction.invoke();
        List list2 = DataSourceStorage.getProjectStorage((Project)project).getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDataSources(...)");
        List currDataSources = list2;
        Iterable $this$filter$iv = currDataSources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                LocalDataSource currDs = (LocalDataSource)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = oldDataSources;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        LocalDataSource oldDs = (LocalDataSource)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)oldDs.getUniqueId(), (Object)currDs.getUniqueId())) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newDataSources = (List)destination$iv$iv;
        $this$filter$iv = newDataSources;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LocalDataSource it = (LocalDataSource)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv$iv = DataStoreUtils.Companion.createDataStores(project, it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (DataStore)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    public void editDataStore(@NotNull Project project, @NotNull CustomDataStore dataStore) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
            List list = DataSourceStorage.getProjectStorage((Project)project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                LocalDataSource it = (LocalDataSource)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!DataStoreUtilsKt.isSame((DasDataSource)it, (AbstractRdbmsStore)dataStore)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        LocalDataSource ideaDs = v1;
        this.showDataSourceDialog(project, ideaDs);
    }

    private final void showDataSourceDialog(Project project, Object selection) {
        DataSourceManagerDialog.showDialog((DbPsiFacade)DbPsiFacade.getInstance((Project)project), (Object)selection, null);
        ((CustomDataSourceHandler)project.getMessageBus().syncPublisher(CustomDataSourceHandler.TOPIC)).dataSourcesChanged();
    }

    public void deleteDataStore(@NotNull Project project, @NotNull CustomDataStore dataStore) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
        this.deleteDataStore(project, dataStore, (Function2<? super DbDataSourceImpl, ? super DatabaseView, Unit>)((Function2)(arg_0, arg_1) -> UDataStoreManagerExtension.deleteDataStore$lambda$0(project, arg_0, arg_1)));
    }

    public void applyInitialCredentials(@NotNull Project project, @NotNull DbProperties[] dbProperties) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
        Iterable $this$forEach$iv = ArraysKt.filterNotNull((Object[])dbProperties);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CredentialsDialog dialog;
            OneTimeString password;
            LocalDataSource.Storage passwordStorage;
            LocalDataSource ideaDataSource;
            Object v1;
            DbProperties dbProperty;
            block2: {
                dbProperty = (DbProperties)element$iv;
                boolean bl = false;
                List list = DataSourceStorage.getProjectStorage((Project)project).getDataSources();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
                Iterable iterable = list;
                for (Object t : iterable) {
                    LocalDataSource it = (LocalDataSource)t;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getUrl(), (Object)dbProperty.getUrl()) && Intrinsics.areEqual((Object)it.getUsername(), (Object)dbProperty.getUser()))) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            if ((LocalDataSource)v1 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)ideaDataSource.getPasswordStorage(), (String)"getPasswordStorage(...)");
            if (passwordStorage == LocalDataSource.Storage.PERSIST) continue;
            OneTimeString oneTimeString = password = DataStoreUtils.Companion.getDataSourcePassword((DasDataSource)ideaDataSource);
            String passwordAsString = oneTimeString != null ? oneTimeString.toString() : null;
            CharSequence charSequence = passwordAsString;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) || !(dialog = new CredentialsDialog(project, ideaDataSource)).showAndGet()) continue;
            dbProperty.setPassword(dialog.getPassword());
        }
    }

    public void updateDbConnection(@NotNull Project project, @NotNull String oldUrl, @NotNull AbstractRdbmsStore newDataStore) {
        Object v1;
        Object[] objectArray;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)oldUrl, (String)"oldUrl");
            Intrinsics.checkNotNullParameter((Object)newDataStore, (String)"newDataStore");
            List list = DataSourceStorage.getProjectStorage((Project)project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            objectArray = (Object[])list;
            for (Object t : objectArray) {
                LocalDataSource it = (LocalDataSource)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)oldUrl)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        LocalDataSource localDataSource = v1;
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ideaDs = localDataSource;
        DbProperties dbProperties = newDataStore.getDbProperties();
        ideaDs.setUsername(dbProperties.getUser());
        ideaDs.setUrl(dbProperties.getUrl());
        DataSourceStorage.getProjectStorage((Project)project).updateDataSource(ideaDs);
        ((CustomDataSourceHandler)project.getMessageBus().syncPublisher(CustomDataSourceHandler.TOPIC)).dataSourcesChanged();
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)JpaModelBundle.message((String)"open.db.connection", (Object[])new Object[0]), () -> UDataStoreManagerExtension.updateDbConnection$lambda$1(this, project, ideaDs));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
        NotificationAction openDbConnectionAction = notificationAction;
        objectArray = new Object[]{ideaDs.getName()};
        String string = JpaModelBundle.message((String)"db.connection.updated", (Object[])objectArray);
        objectArray = new NotificationAction[]{openDbConnectionAction};
        NotificationUtilsKt.showDiffGenerationGroupNotification(project, null, string, NotificationType.INFORMATION, (NotificationAction[])objectArray);
    }

    public boolean isExistDbConnection(@NotNull Project project, @NotNull String url) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            List list = DataSourceStorage.getProjectStorage((Project)project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LocalDataSource it = (LocalDataSource)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)url)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteDataStore(Project project, CustomDataStore dataStore, Function2<? super DbDataSourceImpl, ? super DatabaseView, Unit> deleteAction) {
        Object v2;
        block5: {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            List list = DbPsiFacade.getInstance((Project)project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            Iterable iterable = list;
            boolean $i$f$filterIsInstance22 = false;
            Iterator iterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DbDataSourceImpl)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv;
            for (Object t : $i$f$filterIsInstance22) {
                boolean bl;
                DbDataSourceImpl it = (DbDataSourceImpl)t;
                boolean bl2 = false;
                Object object = it.getDelegate();
                if ((object instanceof AbstractDataSource ? (AbstractDataSource)object : null) == null) {
                    bl = false;
                } else {
                    AbstractDataSource dataSource;
                    dataSource = dataSource;
                    bl = DataStoreUtilsKt.isSame((DasDataSource)dataSource, (AbstractRdbmsStore)dataStore);
                }
                if (!bl) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        DbDataSourceImpl dbDataSourceImpl = v2;
        if (dbDataSourceImpl == null) {
            return;
        }
        DbDataSourceImpl foundDbElement = dbDataSourceImpl;
        DatabaseView databaseView = DatabaseView.getDatabaseView((Project)project);
        DatabaseNodeWrappingService databaseNodeWrappingService = (DatabaseNodeWrappingService)project.getService(DatabaseNodeWrappingService.class);
        BasicNode node = databaseNodeWrappingService.unwrap((PsiElement)foundDbElement);
        databaseView.selectNode(node).onSuccess(arg_0 -> UDataStoreManagerExtension.deleteDataStore$lambda$3(arg_0 -> UDataStoreManagerExtension.deleteDataStore$lambda$2(deleteAction, foundDbElement, databaseView, project, arg_0), arg_0));
    }

    private static final Unit createDataStore$lambda$0(UDataStoreManagerExtension this$0, Project $project) {
        this$0.showDataSourceDialog($project, null);
        return Unit.INSTANCE;
    }

    private static final Unit createDataStore$lambda$1(UDataStoreManagerExtension this$0, Project $project, DbDataSource $newElement) {
        this$0.showDataSourceDialog($project, $newElement);
        return Unit.INSTANCE;
    }

    private static final Unit deleteDataStore$lambda$0(Project $project, DbDataSourceImpl foundDbElement, DatabaseView databaseView) {
        block4: {
            DatabaseViewPanel databaseViewPanel;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)foundDbElement, (String)"foundDbElement");
                    Intrinsics.checkNotNullParameter((Object)databaseView, (String)"databaseView");
                    databaseViewPanel = databaseView.getPanelIfAny();
                    if (databaseViewPanel == null) break block2;
                    DatabaseViewPanel it = databaseViewPanel;
                    boolean bl = false;
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)it);
                    databaseViewPanel = dataContext;
                    if (dataContext != null) break block3;
                }
                DataContext dataContext = SimpleDataContext.getProjectContext((Project)$project);
                databaseViewPanel = dataContext;
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getProjectContext(...)");
            }
            DatabaseViewPanel dataContext = databaseViewPanel;
            DeleteProvider deleteProvider = DbDeleteProvider.getDeleteProvider((Iterable)CollectionsKt.listOf((Object)foundDbElement));
            if (deleteProvider == null) break block4;
            deleteProvider.deleteElement((DataContext)dataContext);
        }
        return Unit.INSTANCE;
    }

    private static final void updateDbConnection$lambda$1(UDataStoreManagerExtension this$0, Project $project, LocalDataSource $ideaDs) {
        this$0.showDataSourceDialog($project, $ideaDs);
    }

    private static final Unit deleteDataStore$lambda$2(Function2 $deleteAction, DbDataSourceImpl $foundDbElement, DatabaseView $databaseView, Project $project, Void it) {
        ApplicationManager.getApplication().invokeLater(() -> UDataStoreManagerExtension.deleteDataStore$lambda$2$0($deleteAction, $foundDbElement, $databaseView, $project));
        return Unit.INSTANCE;
    }

    private static final void deleteDataStore$lambda$2$0(Function2 $deleteAction, DbDataSourceImpl $foundDbElement, DatabaseView $databaseView, Project $project) {
        Intrinsics.checkNotNull((Object)$databaseView);
        $deleteAction.invoke((Object)$foundDbElement, (Object)$databaseView);
        ((CustomDataSourceHandler)$project.getMessageBus().syncPublisher(CustomDataSourceHandler.TOPIC)).dataSourcesChanged();
    }

    private static final void deleteDataStore$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

