/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.inspection;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.quickFix.AbstractCreateFileFix;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.codeInsight.daemon.quickFix.TargetDirectory;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.jpa.jpb.model.JpaIcons;
import com.intellij.liquibase.common.action.CreateChangeLogAction;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.IconUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001-B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J3\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0096\u0002J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\nH\u0002J(\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aH\u0002J \u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001a2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aH\u0002J#\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"H\u0003\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0016\u00a8\u0006."}, d2={"Lcom/intellij/liquibase/inspection/CreateDiffChangelogQuickFix;", "Lcom/intellij/codeInsight/daemon/quickFix/AbstractCreateFileFix;", "Lcom/intellij/openapi/util/Iconable;", "element", "Lcom/intellij/psi/PsiElement;", "location", "Lcom/intellij/codeInsight/daemon/quickFix/NewFileLocation;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/codeInsight/daemon/quickFix/NewFileLocation;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "createChangelog", "targetDirectory", "showOptionsPopup", "directories", "", "Lcom/intellij/codeInsight/daemon/quickFix/TargetDirectory;", "getTargetDirectoryListItems", "Lcom/intellij/liquibase/inspection/CreateDiffChangelogQuickFix$TargetDirectoryListItem;", "getPresentableContentRootPath", "directory", "Lcom/intellij/psi/PsiDirectory;", "pathToCreate", "", "(Lcom/intellij/psi/PsiDirectory;[Ljava/lang/String;)Ljava/lang/String;", "getContentRootIcon", "Ljavax/swing/Icon;", "startInWriteAction", "", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "getIcon", "flags", "", "TargetDirectoryListItem", "intellij.liquibase"})
@SourceDebugExtension(value={"SMAP\nCreateDiffChangelogQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateDiffChangelogQuickFix.kt\ncom/intellij/liquibase/inspection/CreateDiffChangelogQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n774#2:179\n865#2,2:180\n1563#2:182\n1634#2,3:183\n*S KotlinDebug\n*F\n+ 1 CreateDiffChangelogQuickFix.kt\ncom/intellij/liquibase/inspection/CreateDiffChangelogQuickFix\n*L\n64#1:179\n64#1:180,2\n128#1:182\n128#1:183,3\n*E\n"})
public final class CreateDiffChangelogQuickFix
extends AbstractCreateFileFix
implements Iconable {
    public CreateDiffChangelogQuickFix(@NotNull PsiElement element, @NotNull NewFileLocation location) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(element, location, "create.file.text");
        this.myIsAvailable = true;
        this.myIsAvailableTimeStamp = System.currentTimeMillis();
    }

    @NotNull
    public String getFamilyName() {
        String string = LiquibaseResourceBundle.message("fixes.createChangelogFamily", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        String string = LiquibaseResourceBundle.message("fixes.createDiffChangelogFile", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullExpressionValue((Object)this.mySubPath, (String)"mySubPath");
        String directoryName = ArraysKt.joinToString$default((Object[])this.mySubPath, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        if (this.isAvailable(project, null, psiFile)) {
            if (this.myDirectories.size() == 1) {
                Object object = ((TargetDirectory)this.myDirectories.get(0)).getDirectory();
                if (object == null || (object = object.getVirtualFile()) == null || (object = object.getPath()) == null) {
                    return;
                }
                Object directoryPath = object;
                Project project2 = this.myStartElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                this.createChangelog(project2, (String)directoryPath + "/" + directoryName);
            } else {
                void $this$filterTo$iv$iv;
                List list = this.myDirectories;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"myDirectories");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TargetDirectory it = (TargetDirectory)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getDirectory() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List directories = (List)destination$iv$iv;
                if (directories.isEmpty()) {
                    return;
                }
                if (editor == null || ApplicationManager.getApplication().isUnitTestMode()) {
                    Object object = ((TargetDirectory)directories.get(0)).getDirectory();
                    if (object == null || (object = object.getVirtualFile()) == null || (object = object.getPath()) == null) {
                        return;
                    }
                    Object directoryPath = object;
                    Project project3 = this.myStartElement.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                    this.createChangelog(project3, (String)directoryPath + "/" + directoryName);
                } else {
                    this.showOptionsPopup(project, editor, directories);
                }
            }
        }
    }

    private final void createChangelog(Project project, String targetDirectory) {
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(CommonDataKeys.PROJECT, (Object)project).add(CreateChangeLogAction.Companion.getINIT_DIRECTORY_NAME(), (Object)targetDirectory).add(CreateChangeLogAction.Companion.getINIT_FILE_NAME(), (Object)this.myNewFileName).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        DataContext dataContext2 = dataContext;
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)dataContext2, null, (String)"JpaChangelogQuickFixAction", (ActionUiKind)ActionUiKind.NONE, null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent anActionEvent2 = anActionEvent;
        ActionManager.getInstance().getAction("CreateDiffLiquibaseChangeLog").actionPerformed(anActionEvent2);
    }

    private final void showOptionsPopup(Project project, Editor editor, List<TargetDirectory> directories) {
        List<TargetDirectoryListItem> items = this.getTargetDirectoryListItems(directories);
        String filePath = this.myNewFileName;
        Intrinsics.checkNotNullExpressionValue((Object)this.mySubPath, (String)"mySubPath");
        if (!(((Object[])this.mySubPath).length == 0)) {
            filePath = FileUtil.toSystemDependentName((String)(StringUtil.join((String[])this.mySubPath, (String)"/") + "/" + this.myNewFileName));
        }
        SimpleListCellRenderer simpleListCellRenderer = SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> CreateDiffChangelogQuickFix.showOptionsPopup$lambda$1(CreateDiffChangelogQuickFix::showOptionsPopup$lambda$0, arg_0, arg_1, arg_2));
        Intrinsics.checkNotNullExpressionValue((Object)simpleListCellRenderer, (String)"create(...)");
        SimpleListCellRenderer renderer = simpleListCellRenderer;
        Object[] objectArray = new Object[]{filePath};
        JBPopupFactory.getInstance().createPopupChooserBuilder(items).setSelectionMode(0).setTitle(CodeInsightBundle.message((String)this.myKey, (Object[])objectArray)).setMovable(false).setResizable(false).setRequestFocus(true).setRenderer((ListCellRenderer)renderer).setNamerForFiltering(arg_0 -> CreateDiffChangelogQuickFix.showOptionsPopup$lambda$3(CreateDiffChangelogQuickFix::showOptionsPopup$lambda$2, arg_0)).setItemChosenCallback(arg_0 -> CreateDiffChangelogQuickFix.showOptionsPopup$lambda$5(arg_0 -> CreateDiffChangelogQuickFix.showOptionsPopup$lambda$4(this, project, arg_0), arg_0)).addListener(new JBPopupListener(project, editor){
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;
            {
                this.$project = $project;
                this.$editor = $editor;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                PsiFile file = PsiDocumentManager.getInstance((Project)this.$project).getPsiFile(this.$editor.getDocument());
                if (file != null) {
                    DaemonCodeAnalyzer.getInstance((Project)this.$project).restart(file, (Object)this);
                }
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    /*
     * WARNING - void declaration
     */
    private final List<TargetDirectoryListItem> getTargetDirectoryListItems(List<TargetDirectory> directories) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = directories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void targetDirectory;
            TargetDirectory targetDirectory2 = (TargetDirectory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiDirectory psiDirectory = targetDirectory;
            if (psiDirectory == null || (psiDirectory = psiDirectory.getDirectory()) == null) {
                throw new IllegalStateException("Invalid PsiDirectory instances found".toString());
            }
            PsiDirectory d = psiDirectory;
            String[] stringArray = targetDirectory.getPathToCreate();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getPathToCreate(...)");
            String presentablePath = this.getPresentableContentRootPath(d, stringArray);
            Icon icon = this.getContentRootIcon(d);
            collection.add(new TargetDirectoryListItem((TargetDirectory)targetDirectory, icon, presentablePath));
        }
        return (List)destination$iv$iv;
    }

    @NlsContexts.Label
    private final String getPresentableContentRootPath(PsiDirectory directory, String[] pathToCreate) {
        VirtualFile virtualFile = directory.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile f = virtualFile;
        Project project = directory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string = f.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Object path = string;
        if (!(pathToCreate.length == 0)) {
            path = (String)path + "/" + StringUtil.join((String[])pathToCreate, (String)"/");
        }
        String string2 = f.getFileSystem().extractPresentableUrl((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"extractPresentableUrl(...)");
        String presentablePath = string2;
        return ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)f, (String)presentablePath, (Project)project2, (boolean)true, (boolean)true);
    }

    private final Icon getContentRootIcon(PsiDirectory directory) {
        VirtualFile virtualFile = directory.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile file = virtualFile;
        Project project = directory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        VirtualFile sourceRoot = projectFileIndex2.getSourceRootForFile(file);
        return sourceRoot != null ? IconUtil.getIcon((VirtualFile)sourceRoot, (int)0, (Project)project2) : IconUtil.getIcon((VirtualFile)file, (int)0, (Project)project2);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = JpaIcons.DiffLiquibaseChangelog;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"DiffLiquibaseChangelog");
        return icon;
    }

    private static final Unit showOptionsPopup$lambda$0(JBLabel label, TargetDirectoryListItem value, int n) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        label.setIcon(value.getIcon());
        label.setText(value.getPresentablePath());
        return Unit.INSTANCE;
    }

    private static final void showOptionsPopup$lambda$1(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    private static final String showOptionsPopup$lambda$2(TargetDirectoryListItem item) {
        TargetDirectoryListItem targetDirectoryListItem = item;
        return targetDirectoryListItem != null ? targetDirectoryListItem.getPresentablePath() : null;
    }

    private static final String showOptionsPopup$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit showOptionsPopup$lambda$4(CreateDiffChangelogQuickFix this$0, Project $project, TargetDirectoryListItem chosenValue) {
        if (chosenValue == null) {
            return Unit.INSTANCE;
        }
        Object object = chosenValue.getTarget().getDirectory();
        if (object == null || (object = object.getVirtualFile()) == null || (object = object.getPath()) == null) {
            return Unit.INSTANCE;
        }
        Object directoryPath = object;
        Intrinsics.checkNotNullExpressionValue((Object)this$0.mySubPath, (String)"mySubPath");
        this$0.createChangelog($project, (String)directoryPath + "/" + ArraysKt.joinToString$default((Object[])this$0.mySubPath, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
        return Unit.INSTANCE;
    }

    private static final void showOptionsPopup$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/liquibase/inspection/CreateDiffChangelogQuickFix$TargetDirectoryListItem;", "", "target", "Lcom/intellij/codeInsight/daemon/quickFix/TargetDirectory;", "icon", "Ljavax/swing/Icon;", "presentablePath", "", "<init>", "(Lcom/intellij/codeInsight/daemon/quickFix/TargetDirectory;Ljavax/swing/Icon;Ljava/lang/String;)V", "getTarget", "()Lcom/intellij/codeInsight/daemon/quickFix/TargetDirectory;", "getIcon", "()Ljavax/swing/Icon;", "getPresentablePath", "()Ljava/lang/String;", "intellij.liquibase"})
    public static final class TargetDirectoryListItem {
        @NotNull
        private final TargetDirectory target;
        @NotNull
        private final Icon icon;
        @NotNull
        private final String presentablePath;

        public TargetDirectoryListItem(@NotNull TargetDirectory target, @NotNull Icon icon, @NlsContexts.Label @NotNull String presentablePath) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)presentablePath, (String)"presentablePath");
            this.target = target;
            this.icon = icon;
            this.presentablePath = presentablePath;
        }

        @NotNull
        public final TargetDirectory getTarget() {
            return this.target;
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public final String getPresentablePath() {
            return this.presentablePath;
        }
    }
}

