/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.jpa.orm;

import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.ForeignKeyModel;
import com.intellij.jpa.jpb.model.model.audit.AuditEntity;
import com.intellij.jpa.jpb.model.model.audit.RevAttribute;
import com.intellij.jpa.jpb.model.service.EnversService;
import com.intellij.jpa.jpb.model.service.JpabGeneratorManager;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.liquibase.common.LiquibaseElementsNamesHelper;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.LiquibaseGeneratorImpl;
import com.intellij.liquibase.common.ddl.model.JForeignKey;
import com.intellij.liquibase.common.ddl.model.JTable;
import com.intellij.liquibase.jpa.orm.JpaLiquibaseAttributesHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JpaLiquibaseFkHelper {
    private final LiquibaseGenerationContext context;
    private final Project project;
    private final JpabGeneratorManager ddlGeneratorManager;
    private final EntitySearch entitySearch;
    private final LiquibaseElementsNamesHelper liquibaseElementsNamesHelper;

    JpaLiquibaseFkHelper(LiquibaseGenerationContext context) {
        this.context = context;
        this.project = context.getProject();
        this.ddlGeneratorManager = JpabGeneratorManager.getInstance((Project)this.project);
        this.entitySearch = EntitySearch.getInstance((Project)this.project);
        this.liquibaseElementsNamesHelper = new LiquibaseElementsNamesHelper(context);
    }

    List<JForeignKey> generateForeignKeysConstraints(@NotNull Entity entity) {
        if (entity == null) {
            JpaLiquibaseFkHelper.$$$reportNull$$$0(0);
        }
        ArrayList<JForeignKey> cons = new ArrayList<JForeignKey>();
        Entity root = EntityDesignHelper.getHierarchyRoot((Entity)entity);
        Entity closestParentWithStrategy = EntityDesignHelper.getParentWithStrategy((Entity)entity);
        Entity persistentParent = EntityDesignHelper.getPersistentParent((Entity)entity);
        List attributes = EntityDesignHelper.getAttributesUseFromTablePerClass((Entity)entity);
        List hierarchyEntities = this.ddlGeneratorManager.getChildEntitiesHierarchyWithSingleTableStrategy(entity);
        for (Entity hierarchyEntity : hierarchyEntities) {
            attributes.addAll(hierarchyEntity.getAttributes());
        }
        attributes.addAll(EntityDesignHelper.getMappedSuperClassAttributes((Entity)entity));
        attributes.addAll(this.ddlGeneratorManager.getUnidirectionalO2MAttributes(entity));
        for (EntityAttribute attr : attributes) {
            List<JForeignKey> foreignKeyConstraint;
            Datatype attrType;
            if (entity instanceof AuditEntity && !(attr instanceof RevAttribute)) continue;
            EntityAttribute processedFkAttr = JpaLiquibaseAttributesHelper.tryToExtractGenericAttribute(this.project, entity, attr);
            if (processedFkAttr == null) {
                processedFkAttr = attr;
            }
            if (Optional.ofNullable(processedFkAttr.getForeignKey()).map(ForeignKeyModel::getNoConstraintMode).orElse(false).booleanValue() || processedFkAttr.getConverter() != null || !this.isPersistenceClass(processedFkAttr) && processedFkAttr.getTargetEntityFqn() == null && !processedFkAttr.isEmbedded() || (attrType = processedFkAttr.getType()) instanceof Entity && EntityDesignHelper.getInheritanceType((Entity)((Entity)attrType)) == Entity.InheritanceType.TABLE_PER_CLASS && EntityDesignHelper.existPersistentChild((Entity)((Entity)attrType), (Project)this.project) || (foreignKeyConstraint = this.generateForeignKeyConstraint(entity, processedFkAttr, null)) == null) continue;
            cons.addAll(foreignKeyConstraint);
        }
        if ((persistentParent != null && root != null && root.getInheritanceType() == Entity.InheritanceType.JOINED && root == closestParentWithStrategy && entity.getInheritanceType() == null || persistentParent != null && entity.getInheritanceType() == Entity.InheritanceType.JOINED || closestParentWithStrategy != null && root != closestParentWithStrategy && closestParentWithStrategy.getInheritanceType() == Entity.InheritanceType.JOINED) && Strings.isNotEmpty((String)entity.getTable())) {
            cons.add(this.joinedInheritanceForeignKey(entity));
        }
        return cons;
    }

    private List<JForeignKey> generateForeignKeyConstraint(Entity entity, EntityAttribute persistOrEmbeddedAttr, @Nullable String columnName) {
        Datatype persistOrEmbeddedType = persistOrEmbeddedAttr.getType();
        if (persistOrEmbeddedAttr.getTargetEntityFqn() != null) {
            persistOrEmbeddedType = this.entitySearch.findEntityByQualifiedName(persistOrEmbeddedAttr.getTargetEntityFqn());
        }
        if (persistOrEmbeddedAttr.isEmbedded()) {
            ArrayList<JForeignKey> embeddedConstraints = new ArrayList<JForeignKey>();
            Map embeddedAttrs = EntityDesignHelper.getInstance((Project)this.project).fetchEmbeddedAttributes(persistOrEmbeddedAttr);
            for (Map.Entry entry : embeddedAttrs.entrySet()) {
                List<JForeignKey> foreignKeyConstraint;
                EntityAttribute embeddedAttr = ((EntityDesignHelper.AttributeOverrideStore)entry.getValue()).getAttribute();
                if (!this.isPersistenceClass(embeddedAttr) && !embeddedAttr.isEmbedded() || (foreignKeyConstraint = this.generateForeignKeyConstraint(entity, embeddedAttr, (String)entry.getKey())) == null) continue;
                embeddedConstraints.addAll(foreignKeyConstraint);
            }
            return embeddedConstraints;
        }
        if (persistOrEmbeddedType instanceof Entity) {
            Entity persistEntity = (Entity)persistOrEmbeddedType;
            if (entity.getTable() == null) {
                throw new IllegalArgumentException("Table not found for " + entity.getFqn());
            }
            List<String> columnNames = LiquibaseGeneratorImpl.getColumnNames(persistOrEmbeddedAttr, columnName);
            String constraintName = this.liquibaseElementsNamesHelper.foreignKeyConstraintName(entity.getClearValidTable(), columnNames, persistOrEmbeddedAttr).toUpperCase(Locale.ROOT);
            String attrTable = this.getAttributeTable(persistOrEmbeddedAttr);
            EntityAttribute.OnDeleteAction onDeleteAction = JpaLiquibaseFkHelper.createOnDeleteAction(persistOrEmbeddedAttr, persistEntity);
            List<String> referencedColumnNames = this.getReferencedColumnNames(persistOrEmbeddedAttr, persistEntity);
            JForeignKey foreignKey = this.createForeignKey(constraintName, attrTable, persistEntity, entity, columnNames, referencedColumnNames, onDeleteAction);
            return Collections.singletonList(foreignKey);
        }
        return null;
    }

    private static EntityAttribute.OnDeleteAction createOnDeleteAction(@NotNull EntityAttribute persistOrEmbeddedAttr, @NotNull Entity persistEntity) {
        if (persistOrEmbeddedAttr == null) {
            JpaLiquibaseFkHelper.$$$reportNull$$$0(1);
        }
        if (persistEntity == null) {
            JpaLiquibaseFkHelper.$$$reportNull$$$0(2);
        }
        if (persistOrEmbeddedAttr.getOnDeleteAction() != null) {
            return persistOrEmbeddedAttr.getOnDeleteAction();
        }
        if (ContainerUtil.exists((Iterable)persistEntity.getAttributes(), attr -> Objects.equals(attr.getMappedBy(), persistOrEmbeddedAttr.getName()) && attr.getOnDeleteAction() == EntityAttribute.OnDeleteAction.CASCADE)) {
            return EntityAttribute.OnDeleteAction.CASCADE;
        }
        return EntityAttribute.OnDeleteAction.NO_ACTION;
    }

    @NotNull
    private JForeignKey createForeignKey(String constraintName, String primaryKeyTableName, Entity primaryKeyEntity, Entity foreignKeyEntity, List<String> foreignKeyColumnNames, List<String> referencedColumnNames, EntityAttribute.OnDeleteAction onDeleteAction) {
        JForeignKey foreignKey = new JForeignKey(constraintName, new JTable(primaryKeyTableName, primaryKeyEntity.getCatalog(), PhysicalNamingStrategy.getInstance((Project)this.project).toSchemaName(primaryKeyEntity.getSchema())), JTable.create(this.project, foreignKeyEntity), LiquibaseGeneratorImpl.convertOnDeleteAction(onDeleteAction));
        foreignKey.getPrimaryKeyColumns().addAll(referencedColumnNames);
        foreignKey.getForeignKeyColumns().addAll(foreignKeyColumnNames);
        JForeignKey jForeignKey = foreignKey;
        if (jForeignKey == null) {
            JpaLiquibaseFkHelper.$$$reportNull$$$0(3);
        }
        return jForeignKey;
    }

    private String getAttributeTable(@NotNull EntityAttribute attr) {
        if (attr == null) {
            JpaLiquibaseFkHelper.$$$reportNull$$$0(4);
        }
        if (Strings.isNotEmpty((String)attr.getTargetEntityFqn())) {
            return this.getTableName(attr.getTargetEntityFqn());
        }
        Datatype attributeType = attr.getType();
        if (attributeType instanceof Entity) {
            return JpaLiquibaseFkHelper.getTableName((Entity)attr.getType());
        }
        return this.getTableName(attr.getType().getFqn());
    }

    private String getTableName(String fqn) {
        Entity entity = this.entitySearch.findEntityByQualifiedName(fqn);
        if (entity == null) {
            throw new IllegalStateException("Cannot find entity " + fqn);
        }
        return JpaLiquibaseFkHelper.getTableName(entity);
    }

    private List<String> getReferencedColumnNames(EntityAttribute attribute, @Nullable Entity referencedEntity) {
        List<String> explicitNames = attribute.getJoinColumns().values().stream().filter(it -> it != null && !it.isEmpty()).toList();
        if (!explicitNames.isEmpty()) {
            return explicitNames;
        }
        return this.getPrimaryKeyColumns(referencedEntity);
    }

    private List<String> getPrimaryKeyColumns(Entity entity) {
        Entity closestParentPersistent = EntityDesignHelper.getPersistentParent((Entity)entity);
        if (!(closestParentPersistent == null || EntityDesignHelper.getInheritanceType((Entity)closestParentPersistent) != Entity.InheritanceType.JOINED && EntityDesignHelper.getInheritanceType((Entity)entity) != Entity.InheritanceType.JOINED || entity.getPrimaryKeyJoinColumnNames().isEmpty())) {
            return entity.getPrimaryKeyJoinColumnNames();
        }
        if (closestParentPersistent != null && !closestParentPersistent.getPrimaryKeyJoinColumnNames().isEmpty() && EntityDesignHelper.getInheritanceType((Entity)entity) == Entity.InheritanceType.SINGLE_TABLE) {
            return closestParentPersistent.getPrimaryKeyJoinColumnNames();
        }
        List tableAttributes = this.ddlGeneratorManager.getTableAttributes(entity, this.context.getMainDbType());
        ArrayList<EntityAttribute> idAttrs = ContainerUtil.filter((Collection)tableAttributes, EntityAttribute::isId);
        if (idAttrs.isEmpty()) {
            idAttrs = new ArrayList<EntityAttribute>();
            EntityAttribute idAttributeOrNull = entity.getIdAttributeOrNull();
            if (idAttributeOrNull != null) {
                idAttrs.add(idAttributeOrNull);
            }
        }
        if (idAttrs.isEmpty()) {
            throw new IllegalStateException("Id attribute is null for entity: " + entity.getFqn());
        }
        return idAttrs.stream().flatMap(a -> entity.getColumnNames(this.project, a).stream()).toList();
    }

    private static String getTableName(Entity entity) {
        String tableName = entity.getTable();
        for (Entity parent = entity.getParent(); Strings.isEmpty((String)tableName) && parent != null; parent = parent.getParent()) {
            tableName = parent.getTable();
        }
        if (Strings.isEmpty((String)tableName)) {
            throw new IllegalStateException("Cannot find table for entity: " + entity.getFqn());
        }
        return tableName;
    }

    private JForeignKey joinedInheritanceForeignKey(Entity entity) {
        if (entity.getParent() == null) {
            throw new IllegalArgumentException("Parent entity is null");
        }
        EntityAttribute id = entity.getIdAttribute();
        ArrayList<String> joinColumns = new ArrayList<String>();
        ArrayList<String> referencedColumns = new ArrayList<String>();
        if (entity instanceof AuditEntity) {
            String revisionFieldName = EnversService.Companion.getInstance(this.project).getActualEnversProperties().getRevisionFieldName();
            joinColumns.add(revisionFieldName);
            referencedColumns.add(revisionFieldName);
        }
        if (!entity.getPrimaryKeyJoinColumnNames().isEmpty()) {
            joinColumns.addAll(entity.getPrimaryKeyJoinColumnNames());
        } else {
            Datatype idType = id.getType();
            if (idType instanceof Entity) {
                joinColumns.addAll(((Entity)idType).getColumnNames(this.project, id));
            } else {
                joinColumns.add(id.getDdlManipulationColumn());
            }
        }
        Entity persistentParent = this.getJoinedPersistenceParentEntity(entity);
        if (Strings.isNotEmpty((String)entity.getPrimaryKeyReferencedColumnName())) {
            referencedColumns.add(entity.getPrimaryKeyReferencedColumnName());
        } else {
            List parentPkJoinColumnNames = persistentParent.getPrimaryKeyJoinColumnNames();
            if (!parentPkJoinColumnNames.isEmpty()) {
                referencedColumns.addAll(parentPkJoinColumnNames);
            } else {
                Datatype idType = id.getType();
                if (idType instanceof Entity) {
                    referencedColumns.addAll(((Entity)idType).getColumnNames(this.project, id));
                } else {
                    referencedColumns.add(id.getDdlManipulationColumn());
                }
            }
        }
        String constraintName = this.liquibaseElementsNamesHelper.foreignKeyConstraintName(entity.getClearValidTable(), joinColumns, null).toUpperCase(Locale.ROOT);
        JForeignKey jForeignKey = new JForeignKey(constraintName, JTable.create(this.project, persistentParent), JTable.create(this.project, entity));
        jForeignKey.getPrimaryKeyColumns().addAll(referencedColumns);
        jForeignKey.getForeignKeyColumns().addAll(joinColumns);
        return jForeignKey;
    }

    @NotNull
    private Entity getJoinedPersistenceParentEntity(@NotNull Entity entity) {
        Entity persistentParent;
        if (entity == null) {
            JpaLiquibaseFkHelper.$$$reportNull$$$0(5);
        }
        if (JpaUtils.isEclipseLinkProject((Project)this.project)) {
            persistentParent = EntityDesignHelper.getHierarchyRoot((Entity)entity);
        } else {
            persistentParent = EntityDesignHelper.getPersistentParent((Entity)entity);
            while (persistentParent != null && Strings.isEmpty((String)persistentParent.getTable())) {
                persistentParent = EntityDesignHelper.getPersistentParent((Entity)persistentParent);
            }
        }
        if (persistentParent == null) {
            throw new IllegalStateException("Not found persistent parent for entity: " + entity.getFqn());
        }
        Entity entity2 = persistentParent;
        if (entity2 == null) {
            JpaLiquibaseFkHelper.$$$reportNull$$$0(6);
        }
        return entity2;
    }

    @Nullable
    private EntityAttribute getAttributeByColumnName(@Nullable Entity entity, Collection<EntityAttribute> tableAttributes, String columnName) {
        return this.ddlGeneratorManager.findAttributeByColumnName(entity, tableAttributes, columnName);
    }

    private boolean isPersistenceClass(EntityAttribute attribute) {
        EntityAttribute.Cardinality attrCardinality = attribute.getCardinality();
        return (Strings.isNotEmpty((String)attribute.getColumn()) || attribute.isCompKeyType() && Strings.isNotEmpty((String)attribute.getConcatJoinColumns())) && attribute.isClass() && !attribute.isCardinalityMany() && (attrCardinality != EntityAttribute.Cardinality.ONE_TO_ONE || attribute.getMappedBy() == null) && (attrCardinality != EntityAttribute.Cardinality.ONE_TO_ONE && attrCardinality != EntityAttribute.Cardinality.MANY_TO_ONE || attribute.getJoinTable() == JoinTable.NULL_ANNOTATION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistOrEmbeddedAttr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistEntity";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/liquibase/jpa/orm/JpaLiquibaseFkHelper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/liquibase/jpa/orm/JpaLiquibaseFkHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createForeignKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJoinedPersistenceParentEntity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateForeignKeysConstraints";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createOnDeleteAction";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeTable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getJoinedPersistenceParentEntity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

