/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import java.util.ArrayList;
import liquibase.change.Change;
import liquibase.change.core.AlterSequenceChange;
import liquibase.database.Database;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Sequence;

public class ChangedSequenceChangeGenerator
extends liquibase.diff.output.changelog.core.ChangedSequenceChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        int priority = super.getPriority(objectType, database);
        return priority > 0 ? priority + 1 : priority;
    }

    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Difference incrementByDiff;
        if (!(referenceDatabase instanceof IntellijDatabase) && !(comparisonDatabase instanceof IntellijDatabase)) {
            return super.fixChanged(changedObject, differences, control, referenceDatabase, comparisonDatabase, chain);
        }
        if (LiquibaseUtils.getDatabaseType(referenceDatabase) == DbType.HSQL || LiquibaseUtils.getDatabaseType(comparisonDatabase) == DbType.HSQL) {
            return null;
        }
        Sequence sequence = (Sequence)changedObject;
        ArrayList<AlterSequenceChange> changes = new ArrayList<AlterSequenceChange>();
        AlterSequenceChange accumulatedChange = this.createAlterSequenceChange(sequence, control);
        if (differences.isDifferent("incrementBy") && (incrementByDiff = differences.getDifference("incrementBy")) != null && incrementByDiff.getComparedValue() != null) {
            AlterSequenceChange change = this.createAlterSequenceChange(sequence, control);
            change.setIncrementBy(sequence.getIncrementBy());
            accumulatedChange.setIncrementBy(sequence.getIncrementBy());
            changes.add(change);
        }
        if (changes.isEmpty()) {
            return null;
        }
        if (LiquibaseUtils.getDatabaseType(comparisonDatabase) == DbType.POSTGRES) {
            return new Change[]{accumulatedChange};
        }
        return changes.toArray(new Change[0]);
    }
}

