/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config.hints.defaultHint;

import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.microservices.jvm.config.hints.HintReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J1\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b*\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\u0016J3\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b*\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0002\u0010\u0018R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/microservices/jvm/config/hints/defaultHint/DefaultValueReferenceProvider;", "Lcom/intellij/microservices/jvm/config/hints/HintReferenceProvider;", "hintReferenceProvider", "defaultValue", "", "<init>", "(Lcom/intellij/microservices/jvm/config/hints/HintReferenceProvider;Ljava/lang/String;)V", "getReferences", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "textRanges", "", "Lcom/intellij/openapi/util/TextRange;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Ljava/util/List;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "hasHintReferences", "", "([Lcom/intellij/psi/PsiReference;)Z", "withDefaultValue", "([Lcom/intellij/psi/PsiReference;)[Lcom/intellij/psi/PsiReference;", "plusHintReferenceForDefault", "([Lcom/intellij/psi/PsiReference;Lcom/intellij/psi/PsiElement;Ljava/util/List;)[Lcom/intellij/psi/PsiReference;", "DefaultValueReference", "intellij.microservices.config"})
@SourceDebugExtension(value={"SMAP\nDefaultHintReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultHintReferenceProvider.kt\ncom/intellij/microservices/jvm/config/hints/defaultHint/DefaultValueReferenceProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,64:1\n12970#2,2:65\n4225#2,11:67\n12767#2,2:80\n1869#3,2:78\n37#4,2:82\n*S KotlinDebug\n*F\n+ 1 DefaultHintReferenceProvider.kt\ncom/intellij/microservices/jvm/config/hints/defaultHint/DefaultValueReferenceProvider\n*L\n30#1:65,2\n33#1:67,11\n42#1:80,2\n33#1:78,2\n46#1:82,2\n*E\n"})
final class DefaultValueReferenceProvider
implements HintReferenceProvider {
    @Nullable
    private final HintReferenceProvider hintReferenceProvider;
    @NotNull
    private final String defaultValue;

    public DefaultValueReferenceProvider(@Nullable HintReferenceProvider hintReferenceProvider, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        this.hintReferenceProvider = hintReferenceProvider;
        this.defaultValue = defaultValue;
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<? extends TextRange> textRanges, @NotNull ProcessingContext context) {
        PsiReference[] references;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(textRanges, (String)"textRanges");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiReference[] psiReferenceArray = this.hintReferenceProvider;
        if (this.hintReferenceProvider == null || (psiReferenceArray = psiReferenceArray.getReferences(element, textRanges, context)) == null) {
            psiReferenceArray = new PsiReference[]{};
        }
        return this.hasHintReferences(references = psiReferenceArray) ? this.withDefaultValue(references) : this.plusHintReferenceForDefault(references, element, textRanges);
    }

    private final boolean hasHintReferences(PsiReference[] $this$hasHintReferences) {
        boolean bl;
        block1: {
            PsiReference[] $this$any$iv = $this$hasHintReferences;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                PsiReference element$iv;
                PsiReference it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(it instanceof HintReferenceBase)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiReference[] withDefaultValue(PsiReference[] $this$withDefaultValue) {
        void $this$filterIsInstanceTo$iv$iv;
        PsiReference[] $this$filterIsInstance$iv = $this$withDefaultValue;
        boolean $i$f$filterIsInstance = false;
        PsiReference[] psiReferenceArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof HintReferenceBase)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HintReferenceBase it = (HintReferenceBase)((Object)element$iv);
            boolean bl = false;
            it.setDefaultValue(this.defaultValue);
        }
        return $this$withDefaultValue;
    }

    private final PsiReference[] plusHintReferenceForDefault(PsiReference[] $this$plusHintReferenceForDefault, PsiElement element, List<? extends TextRange> textRanges) {
        boolean bl;
        block2: {
            PsiReference[] $this$all$iv = $this$plusHintReferenceForDefault;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                PsiReference element$iv;
                PsiReference it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (it.isSoft()) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        boolean isSoft = bl;
        TextRange textRange = (TextRange)CollectionsKt.firstOrNull(textRanges);
        if (textRange == null) {
            return $this$plusHintReferenceForDefault;
        }
        TextRange textRange2 = textRange;
        PsiReference defaultReference = (PsiReference)new DefaultValueReference(this.defaultValue, element, textRange2, isSoft);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)$this$plusHintReferenceForDefault);
        spreadBuilder.add((Object)defaultReference);
        Collection $this$toTypedArray$iv = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new PsiReference[spreadBuilder.size()]));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0014J\b\u0010\u000f\u001a\u00020\tH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/microservices/jvm/config/hints/defaultHint/DefaultValueReferenceProvider$DefaultValueReference;", "Lcom/intellij/microservices/jvm/config/hints/HintReferenceBase;", "defaultValue", "", "element", "Lcom/intellij/psi/PsiElement;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "soft", "", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Z)V", "getSoft", "()Z", "doResolve", "isSoft", "intellij.microservices.config"})
    private static final class DefaultValueReference
    extends HintReferenceBase {
        private final boolean soft;

        public DefaultValueReference(@NotNull String defaultValue, @NotNull PsiElement element, @NotNull TextRange textRange, boolean soft) {
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            super(element, textRange);
            this.soft = soft;
            this.setDefaultValue(defaultValue);
        }

        public final boolean getSoft() {
            return this.soft;
        }

        @Override
        @Nullable
        protected PsiElement doResolve() {
            return null;
        }

        public boolean isSoft() {
            return this.soft;
        }
    }
}

