/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.kt;

import com.intellij.microservices.jvm.index.PropertyCodeReferenceIndexProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.StringSearcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingLexer;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/microservices/jvm/kt/KtPropertyCodeReferenceIndexProcessor;", "Lcom/intellij/microservices/jvm/index/PropertyCodeReferenceIndexProcessor;", "<init>", "()V", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "searcher", "Lcom/intellij/util/text/StringSearcher;", "accept", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findCodeReferences", "", "", "", "", "inputData", "Lcom/intellij/util/indexing/FileContent;", "isInSourceContent", "intellij.microservices.jvm.kt"})
public final class KtPropertyCodeReferenceIndexProcessor
implements PropertyCodeReferenceIndexProcessor {
    @NotNull
    private final FileType fileType;
    @NotNull
    private final StringSearcher searcher;

    public KtPropertyCodeReferenceIndexProcessor() {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"INSTANCE");
        this.fileType = (FileType)kotlinFileType;
        this.searcher = new StringSearcher("\\${", true, true);
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return this.fileType;
    }

    @Override
    public boolean accept(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.isInSourceContent(file);
    }

    @Override
    @NotNull
    public Map<String, List<Integer>> findCodeReferences(@NotNull FileContent inputData) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        VirtualFile virtualFile = inputData.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        if (!this.isInSourceContent(virtualFile)) {
            return MapsKt.emptyMap();
        }
        CharSequence charSequence = inputData.getContentAsText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContentAsText(...)");
        CharSequence content = charSequence;
        if (this.searcher.scan(content) < 0) {
            return MapsKt.emptyMap();
        }
        Map result = new LinkedHashMap();
        KotlinHighlightingLexer lexer = new KotlinHighlightingLexer();
        lexer.start(content);
        IElementType tokenType = lexer.getTokenType();
        int tokenIdx = 0;
        while (tokenType != null) {
            if (tokenIdx++ % 100 == 0) {
                ProgressManager.checkCanceled();
            }
            if (Intrinsics.areEqual((Object)tokenType, (Object)KtTokens.ESCAPE_SEQUENCE)) {
                CharSequence charSequence2 = lexer.getTokenSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getTokenSequence(...)");
                if (StringsKt.startsWith$default((CharSequence)charSequence2, (CharSequence)"\\$", (boolean)false, (int)2, null)) {
                    lexer.advance();
                    tokenType = lexer.getTokenType();
                    if (Intrinsics.areEqual((Object)tokenType, (Object)KtTokens.REGULAR_STRING_PART)) {
                        CharSequence tokenSeq;
                        Intrinsics.checkNotNullExpressionValue((Object)lexer.getTokenSequence(), (String)"getTokenSequence(...)");
                        String key = this.extractPropertyKey(tokenSeq, "{", "}");
                        if (key != null) {
                            result.computeIfAbsent(key, arg_0 -> KtPropertyCodeReferenceIndexProcessor.findCodeReferences$lambda$1(KtPropertyCodeReferenceIndexProcessor::findCodeReferences$lambda$0, arg_0)).add(lexer.getTokenStart());
                        }
                    }
                }
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        return result;
    }

    private final boolean isInSourceContent(VirtualFile file) {
        return !(file.getFileSystem() instanceof ArchiveFileSystem);
    }

    private static final List findCodeReferences$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List findCodeReferences$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

